/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary.constraint;

import java.util.Map;
import org.alfresco.repo.dictionary.constraint.ConstraintRegistry;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.DictionaryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RegisteredConstraint
implements Constraint {
    private static final String ERR_NAME_NOT_REGISTERED = "d_dictionary.constraint.registered.not_registered";
    private String shortName;
    private String registeredName;

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("RegisteredConstraint").append("[ registeredName=").append(this.registeredName).append(", constraint=").append(ConstraintRegistry.getInstance().getConstraint(this.registeredName)).append("]");
        return sb.toString();
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void setRegisteredName(String registeredName) {
        this.registeredName = registeredName;
    }

    @Override
    public void initialize() {
        if (this.registeredName == null) {
            throw new DictionaryException("d_dictionary.constraint.err.property_not_set", "registeredName");
        }
    }

    private Constraint getConstraint() {
        Constraint constraint = ConstraintRegistry.getInstance().getConstraint(this.registeredName);
        if (constraint == null) {
            throw new DictionaryException(ERR_NAME_NOT_REGISTERED, this.registeredName);
        }
        return constraint;
    }

    @Override
    public String getType() {
        return this.getConstraint().getType();
    }

    @Override
    public String getTitle() {
        return this.getConstraint().getTitle();
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.getConstraint().getParameters();
    }

    @Override
    public void evaluate(Object value) {
        this.getConstraint().evaluate(value);
    }
}

