/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.IOException;
import java.io.StringReader;
import junit.framework.TestCase;
import org.alfresco.repo.search.impl.lucene.analysis.PathTokenFilter;
import org.apache.lucene.analysis.Token;

public class PathTokenFilterTest
extends TestCase {
    public PathTokenFilterTest() {
    }

    public PathTokenFilterTest(String arg0) {
        super(arg0);
    }

    public void testFullPath() throws IOException {
        this.tokenise("{uri1}one", new String[]{"uri1", "one"});
        this.tokenise("/{uri1}one", new String[]{"uri1", "one"});
        this.tokenise("{uri1}one/{uri2}two/", new String[]{"uri1", "one", "uri2", "two"});
        this.tokenise("/{uri1}one/{uri2}two/", new String[]{"uri1", "one", "uri2", "two"});
        this.tokenise("{uri1}one/{uri2}two/{uri3}three", new String[]{"uri1", "one", "uri2", "two", "uri3", "three"});
        this.tokenise("/{uri1}one/{uri2}two/{uri3}three", new String[]{"uri1", "one", "uri2", "two", "uri3", "three"});
        try {
            this.tokenise("{uri1}one;{uri2}two/", new String[]{"uri1", "one", "uri2", "two"});
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testPrefixPath() throws IOException {
        this.tokenise("uri1:one", new String[]{"uri1", "one"});
        this.tokenise("/uri1:one", new String[]{"uri1", "one"});
        this.tokenise("uri1:one/uri2:two/", new String[]{"uri1", "one", "uri2", "two"});
        this.tokenise("/uri1:one/uri2:two/", new String[]{"uri1", "one", "uri2", "two"});
        this.tokenise("uri1:one/uri2:two/uri3:three", new String[]{"uri1", "one", "uri2", "two", "uri3", "three"});
        this.tokenise("/uri1:one/uri2:two/uri3:three", new String[]{"uri1", "one", "uri2", "two", "uri3", "three"});
        try {
            this.tokenise("{uri1}one;{uri2}two/", new String[]{"uri1", "one", "uri2", "two"});
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testMixedPath() throws IOException {
        this.tokenise("{uri1}one/uri2:two/", new String[]{"uri1", "one", "uri2", "two"});
        this.tokenise("/{uri1}one/uri2:two/", new String[]{"uri1", "one", "uri2", "two"});
        this.tokenise("uri1:one/{uri2}two/uri3:three", new String[]{"uri1", "one", "uri2", "two", "uri3", "three"});
        this.tokenise("/uri1:one/{uri2}two/uri3:three", new String[]{"uri1", "one", "uri2", "two", "uri3", "three"});
        try {
            this.tokenise("{uri1}one;{uri2}two/", new String[]{"uri1", "one", "uri2", "two"});
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void tokenise(String path, String[] tokens) throws IOException {
        Token t;
        StringReader reader = new StringReader(path);
        PathTokenFilter ts = new PathTokenFilter(reader, ';', ";", "<No Namespace>", '{', '}', true);
        int i = 0;
        while ((t = ts.next()) != null) {
            if (t.type().equals("PATH_ELEMENT_NAMESPACE")) {
                assert (i % 2 == 0);
                PathTokenFilterTest.assertEquals((String)t.termText(), (String)tokens[i++]);
                continue;
            }
            if (t.type().equals("PATH_ELEMENT_NAMESPACE_PREFIX")) {
                assert (i % 2 == 0);
                PathTokenFilterTest.assertEquals((String)t.termText(), (String)tokens[i++]);
                continue;
            }
            if (!t.type().equals("PATH_ELEMENT_NAME")) continue;
            assert (i % 2 == 1);
            PathTokenFilterTest.assertEquals((String)t.termText(), (String)tokens[i++]);
        }
        if (i != tokens.length) {
            PathTokenFilterTest.fail((String)("Invalid number of tokens, found " + i + " and expected " + tokens.length));
        }
    }
}

