/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene.functions;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.impl.functions.Child;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderContext;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneChild
extends Child
implements LuceneQueryBuilderComponent {
    @Override
    public Query addComponent(Set<String> selectors, Map<String, Argument> functionArgs, LuceneQueryBuilderContext luceneContext, FunctionEvaluationContext functionContext) throws ParseException {
        NodeRef nodeRef;
        LuceneQueryParser lqp = luceneContext.getLuceneQueryParser();
        Argument argument = functionArgs.get("Parent");
        String id = (String)((Object)argument.getValue(functionContext));
        argument = functionArgs.get("Selector");
        if (argument != null) {
            String selector = (String)((Object)argument.getValue(functionContext));
            if (!selectors.contains(selector)) {
                throw new QueryModelException("Unkown selector " + selector);
            }
        } else if (selectors.size() > 1) {
            throw new QueryModelException("Selector must be specified for child constraint (IN_FOLDER) and join");
        }
        if (NodeRef.isNodeRef(id)) {
            nodeRef = new NodeRef(id);
        } else {
            int lastIndex = id.lastIndexOf(47);
            String versionLabel = id.substring(lastIndex + 1);
            String actualId = id.substring(0, lastIndex);
            if (NodeRef.isNodeRef(actualId)) {
                String actualVersionLabel;
                nodeRef = new NodeRef(actualId);
                Serializable value = functionContext.getNodeService().getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL);
                if (value != null && !(actualVersionLabel = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value)).equals(versionLabel)) {
                    throw new QueryModelException("Object id does not refer to the current version" + id);
                }
            } else {
                throw new QueryModelException("Invalid Object Id " + id);
            }
        }
        if (!functionContext.getNodeService().exists(nodeRef)) {
            throw new QueryModelException("Object does not exist: " + id);
        }
        Query query = lqp.getFieldQuery("PARENT", nodeRef.toString());
        return query;
    }
}

