/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene.functions;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.ListArgument;
import org.alfresco.repo.search.impl.querymodel.LiteralArgument;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.impl.functions.In;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderContext;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIn
extends In
implements LuceneQueryBuilderComponent {
    @Override
    public Query addComponent(Set<String> selectors, Map<String, Argument> functionArgs, LuceneQueryBuilderContext luceneContext, FunctionEvaluationContext functionContext) throws ParseException {
        LuceneQueryParser lqp = luceneContext.getLuceneQueryParser();
        PropertyArgument propertyArgument = (PropertyArgument)functionArgs.get("Property");
        Argument inverseArgument = functionArgs.get("Not");
        Boolean not = DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)inverseArgument.getValue(functionContext));
        LiteralArgument modeArgument = (LiteralArgument)functionArgs.get("Mode");
        String modeString = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)modeArgument.getValue(functionContext));
        PredicateMode mode = PredicateMode.valueOf(modeString);
        ListArgument listArgument = (ListArgument)functionArgs.get("List");
        Collection collection = (Collection)((Object)listArgument.getValue(functionContext));
        Query query = functionContext.buildLuceneIn(lqp, propertyArgument.getPropertyName(), collection, not, mode);
        if (query == null) {
            throw new QueryModelException("No query time mapping for property  " + propertyArgument.getPropertyName() + ", it should not be allowed in predicates");
        }
        return query;
    }
}

