/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import junit.framework.TestCase;
import org.alfresco.util.SearchLanguageConversion;

public class SearchLanguageConversionTest
extends TestCase {
    private static final String BAD_STRING = "\\ | ! \" \u00a3 $ % ^ & * ( ) _ { } [ ] @ # ~ ' : ; , . < > + ? / \\\\ \\* \\? \\_";

    public void testEscapeXPathLike() {
        String good = SearchLanguageConversion.escapeForXPathLike(BAD_STRING);
        SearchLanguageConversionTest.assertEquals((String)"Escaping for xpath failed", (String)"\\\\ | ! \" \u00a3 $ \\% ^ & * ( ) \\_ { } \\[ \\] @ # ~ ' : ; , . < > + ? / \\\\\\\\ \\\\* \\\\? \\\\\\_", (String)good);
    }

    public void testEscapeRegex() {
        String good = SearchLanguageConversion.escapeForRegex(BAD_STRING);
        SearchLanguageConversionTest.assertEquals((String)"Escaping for regex failed", (String)"\\\\ \\| ! \" \u00a3 \\$ % \\^ & \\* \\( \\) _ \\{ \\} [ ] @ # ~ ' : ; , \\. < > \\+ \\? / \\\\\\\\ \\\\\\* \\\\\\? \\\\_", (String)good);
    }

    public void testEscapeLucene() {
        String good = SearchLanguageConversion.escapeForLucene(BAD_STRING);
        SearchLanguageConversionTest.assertEquals((String)"Escaping for Lucene failed", (String)"\\\\ \\| \\! \\\" \u00a3 $ % \\^ \\& \\* \\( \\) _ \\{ \\} \\[ \\] @ # \\~ ' \\: ; , . < > \\+ \\? / \\\\\\\\ \\\\\\* \\\\\\? \\\\_", (String)good);
    }

    public void testConvertXPathLikeToRegex() {
        String good = SearchLanguageConversion.convertXPathLikeToRegex(BAD_STRING);
        SearchLanguageConversionTest.assertEquals((String)"XPath like to regex failed", (String)"(?s) \\| ! \" \u00a3 \\$ .* \\^ & \\* \\( \\) . \\{ \\} [ ] @ # ~ ' : ; , \\. < > \\+ \\? / \\\\ \\* \\? _", (String)good);
    }

    public void testConvertXPathLikeToLucene() {
        String good = SearchLanguageConversion.convertXPathLikeToLucene(BAD_STRING);
        SearchLanguageConversionTest.assertEquals((String)"XPath like to Lucene failed", (String)" \\| \\! \\\" \u00a3 $ * \\^ \\& \\* \\( \\) ? \\{ \\} \\[ \\] @ # \\~ ' \\: ; , . < > \\+ \\? / \\\\ \\* \\? _", (String)good);
    }

    public void testSqlToLucene() {
        String sqlLike = "AB%_*?\\%\\_";
        String lucene = "AB*?\\*\\?%_";
        String converted = SearchLanguageConversion.convert(SearchLanguageConversion.DEF_SQL_LIKE, SearchLanguageConversion.DEF_LUCENE, sqlLike);
        SearchLanguageConversionTest.assertEquals((String)lucene, (String)converted);
    }

    public void testLuceneToRegexp() {
        String lucene = "AB*?\\*\\?.*.";
        String regexp = "AB.*.\\*\\?\\..*\\.";
        String converted = SearchLanguageConversion.convert(SearchLanguageConversion.DEF_LUCENE, SearchLanguageConversion.DEF_REGEX, lucene);
        SearchLanguageConversionTest.assertEquals((String)regexp, (String)converted);
    }
}

