/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.deployment.impl.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.deployment.DeploymentReceiverTransport;
import org.alfresco.deployment.DeploymentTarget;
import org.alfresco.deployment.DeploymentToken;
import org.alfresco.deployment.DeploymentTokenImpl;
import org.alfresco.deployment.DeploymentTransportInputFilter;
import org.alfresco.deployment.FileDescriptor;
import org.alfresco.deployment.TargetStatusImpl;
import org.alfresco.deployment.impl.DeploymentException;
import org.alfresco.deployment.impl.server.DeploymentCommandQueue;
import org.alfresco.deployment.impl.server.DeploymentReceiverAuthenticator;
import org.alfresco.deployment.impl.server.DeploymentTargetRegistry;
import org.alfresco.deployment.impl.server.DeploymentTracker;
import org.alfresco.deployment.impl.server.Housekeeper;
import org.alfresco.deployment.impl.server.ReaderManagement;
import org.alfresco.deployment.impl.server.TerminatorCommand;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentReceiverEngineImpl
implements DeploymentReceiverTransport,
DeploymentTargetRegistry,
Runnable,
ApplicationContextAware {
    List<DeploymentTransportInputFilter> transformers;
    private Set<Housekeeper> housekeepers;
    private ConfigurableApplicationContext fContext;
    private DeploymentCommandQueue commandQueue;
    private DeploymentReceiverAuthenticator authenticator;
    private Thread fThread;
    private boolean fDone = false;
    private static Log logger = LogFactory.getLog(DeploymentReceiverEngineImpl.class);
    private long pollDelay = 5000L;
    private boolean isDaemonThread = false;
    private Map<String, DeploymentTarget> targetByName = new HashMap<String, DeploymentTarget>();
    private Map<String, DeploymentTracker> trackerByTicket = Collections.synchronizedMap(new HashMap());
    private ReaderManagement readerManagement;
    private Map<String, OutputStream> fOutputs = Collections.synchronizedMap(new HashMap());
    private AtomicInteger handleGenerator = new AtomicInteger(1);

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"readerManagement", (Object)this.readerManagement);
        this.fThread = new Thread(this);
        this.fThread.setName("Deployment Receiver Engine Keep Alive");
        this.fThread.setDaemon(this.isDaemonThread);
        this.fThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        logger.info((Object)"Shutting down Implementation");
        this.fDone = true;
        DeploymentReceiverEngineImpl deploymentReceiverEngineImpl = this;
        synchronized (deploymentReceiverEngineImpl) {
            this.notifyAll();
        }
        try {
            this.fThread.join();
        }
        catch (InterruptedException e) {
            logger.error((Object)"Unable to join implementation thread while shutting down", (Throwable)e);
        }
    }

    @Override
    public synchronized void shutDown(String user, char[] password) {
        if (this.authenticator == null) {
            return;
        }
        if (this.authenticator.logon(user, password)) {
            this.shutDown();
            this.fContext.close();
        }
    }

    @Override
    public void run() {
        logger.info((Object)"Alfresco Deployment Receiver Engine Started");
        while (!this.fDone) {
            try {
                Thread.sleep(this.pollDelay);
                if (this.housekeepers == null) continue;
                for (Housekeeper housekeeper : this.housekeepers) {
                    housekeeper.poll();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        logger.info((Object)"Alfresco Deployment Receiver Engine Stopped");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.fContext = (ConfigurableApplicationContext)applicationContext;
    }

    public List<DeploymentTransportInputFilter> getTransformers() {
        return this.transformers;
    }

    public void setTransformers(List<DeploymentTransportInputFilter> transformers) {
        this.transformers = transformers;
    }

    @Override
    public void registerTarget(String name, DeploymentTarget target) {
        logger.info((Object)("deployment target registered, name=" + name));
        this.targetByName.put(name, target);
    }

    @Override
    public void unregisterTarget(String name) {
        this.targetByName.remove(name);
    }

    @Override
    public Map<String, DeploymentTarget> getTargets() {
        return this.targetByName;
    }

    private DeploymentTracker getDeploymentTracker(String ticket) {
        DeploymentTracker ret = this.trackerByTicket.get(ticket);
        if (ret == null) {
            String msg = "invalid ticket:" + ticket;
            throw new DeploymentException(msg);
        }
        return ret;
    }

    private DeploymentTarget getTarget(String targetName) {
        return this.targetByName.get(targetName);
    }

    @Override
    public DeploymentToken begin(String targetName, String storeName, int version, String user, char[] password) {
        try {
            logger.debug((Object)("begin of target:" + targetName));
            DeploymentTarget target = this.getTarget(targetName);
            if (target == null) {
                logger.warn((Object)("No such target:" + targetName));
                throw new DeploymentException("No such target: " + targetName);
            }
            String ticket = target.begin(targetName, storeName, version, user, password);
            this.trackerByTicket.put(ticket, new DeploymentTracker(target));
            DeploymentTokenImpl token = new DeploymentTokenImpl();
            token.setTicket(ticket);
            TargetStatusImpl ts = new TargetStatusImpl();
            ts.setCurrentVersion(target.getCurrentVersion(targetName, storeName));
            ts.setTargetName(targetName);
            ts.setStoreName(storeName);
            token.setTargetStatus(ts);
            return token;
        }
        catch (RuntimeException e) {
            MessageFormat f = new MessageFormat("error in begin user:{0}, password:{1}");
            Object[] objs = new Object[]{user, "****"};
            logger.error((Object)f.format(objs), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void abort(String ticket) {
        DeploymentTracker tracker = this.getDeploymentTracker(ticket);
        try {
            tracker.getTarget().abort(ticket);
            this.tearDown(tracker);
            this.trackerByTicket.remove(ticket);
        }
        catch (RuntimeException e) {
            MessageFormat f = new MessageFormat("error in abort ticket:{1}");
            Object[] objs = new Object[]{ticket};
            logger.error((Object)f.format(objs), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void prepare(String ticket) {
        DeploymentTracker tracker = this.getDeploymentTracker(ticket);
        try {
            tracker.getTarget().prepare(ticket);
        }
        catch (RuntimeException e) {
            this.commandQueue.queueCommand(new TerminatorCommand(this, ticket, "earlier exception"));
            MessageFormat f = new MessageFormat("error in prepare ticket:{1}");
            Object[] objs = new Object[]{ticket};
            logger.error((Object)f.format(objs), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void commit(String ticket) {
        DeploymentTracker tracker = this.getDeploymentTracker(ticket);
        try {
            tracker.getTarget().commit(ticket);
            this.tearDown(tracker);
            this.trackerByTicket.remove(ticket);
        }
        catch (RuntimeException e) {
            this.commandQueue.queueCommand(new TerminatorCommand(this, ticket, "earlier exception"));
            MessageFormat f = new MessageFormat("error in commit ticket:{0}");
            Object[] objs = new Object[]{ticket};
            logger.error((Object)f.format(objs), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void delete(String ticket, String path) {
        DeploymentTracker tracker = this.getDeploymentTracker(ticket);
        try {
            tracker.getTarget().delete(ticket, path);
        }
        catch (RuntimeException e) {
            this.commandQueue.queueCommand(new TerminatorCommand(this, ticket, "earlier exception"));
            MessageFormat f = new MessageFormat("error in delete ticket:{0}, path:{1}");
            Object[] objs = new Object[]{ticket, path};
            logger.error((Object)f.format(objs), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<FileDescriptor> getListing(String ticket, String path) {
        DeploymentTracker tracker = this.getDeploymentTracker(ticket);
        try {
            return tracker.getTarget().getListing(ticket, path);
        }
        catch (RuntimeException e) {
            this.commandQueue.queueCommand(new TerminatorCommand(this, ticket, "earlier exception"));
            MessageFormat f = new MessageFormat("error in getListing ticket:{0}, path:{1}");
            Object[] objs = new Object[]{ticket, path};
            logger.error((Object)f.format(objs), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void createDirectory(String ticket, String path, String guid, Set<String> aspects, Map<String, Serializable> props) {
        DeploymentTracker tracker = this.getDeploymentTracker(ticket);
        try {
            tracker.getTarget().createDirectory(ticket, path, guid, aspects, props);
        }
        catch (RuntimeException e) {
            this.commandQueue.queueCommand(new TerminatorCommand(this, ticket, "earlier exception"));
            MessageFormat f = new MessageFormat("error in mkdir ticket:{0}, path:{1}, guid:{2}");
            Object[] objs = new Object[]{ticket, path, guid};
            logger.error((Object)f.format(objs), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void updateDirectory(String ticket, String path, String guid, Set<String> aspects, Map<String, Serializable> properties) {
        DeploymentTracker tracker = this.getDeploymentTracker(ticket);
        try {
            tracker.getTarget().updateDirectory(ticket, path, guid, aspects, properties);
        }
        catch (RuntimeException e) {
            this.commandQueue.queueCommand(new TerminatorCommand(this, ticket, "earlier exception"));
            MessageFormat f = new MessageFormat("error in setGuid ticket:{0}, path:{1}, guid:{2}");
            Object[] objs = new Object[]{ticket, path, guid};
            logger.error((Object)f.format(objs), (Throwable)e);
            throw e;
        }
    }

    private String getNextHandle(String ticket) {
        int handle = this.handleGenerator.incrementAndGet();
        return String.valueOf(handle) + ":" + ticket;
    }

    private void tearDown(DeploymentTracker tracker) {
        Set<String> tokens = tracker.getTokens();
        for (String outputToken : tokens) {
            OutputStream out = this.fOutputs.get(outputToken);
            try {
                out.flush();
                out.close();
                this.readerManagement.closeCopyThread(outputToken);
            }
            catch (DeploymentException de) {
            }
            catch (IOException ie) {}
        }
    }

    @Override
    public OutputStream send(String token, boolean create, String path, String guid, String encoding, String mimeType, Set<String> aspects, Map<String, Serializable> props) {
        throw new DeploymentException("Forbidden call.");
    }

    @Override
    public String getSendToken(String ticket, boolean create, String path, String guid, String encoding, String mimeType, Set<String> aspects, Map<String, Serializable> props) {
        DeploymentTracker tracker = this.getDeploymentTracker(ticket);
        try {
            PipedOutputStream pos = new PipedOutputStream();
            PipedInputStream pis = new PipedInputStream();
            pis.connect(pos);
            InputStream is = pis;
            if (this.transformers != null && this.transformers.size() > 0) {
                for (DeploymentTransportInputFilter transformer : this.transformers) {
                    is = transformer.addFilter(is, path, encoding, mimeType);
                }
            }
            OutputStream out = tracker.getTarget().send(ticket, create, path, guid, encoding, mimeType, aspects, props);
            String token = this.getNextHandle(ticket);
            logger.debug((Object)("Open token " + token));
            this.readerManagement.addCopyThread(is, out, token);
            this.fOutputs.put(token, pos);
            tracker.addToken(token);
            return token;
        }
        catch (RuntimeException e) {
            this.commandQueue.queueCommand(new TerminatorCommand(this, ticket, "earlier exception"));
            MessageFormat f = new MessageFormat("error in getSendToken ticket:{0} path:{1}, guid:{2}");
            Object[] objs = new Object[]{ticket, path, guid};
            logger.error((Object)f.format(objs), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            this.commandQueue.queueCommand(new TerminatorCommand(this, ticket, "earlier exception"));
            MessageFormat f = new MessageFormat("error in getSendToken ticket:{0} path:{1}, guid:{2}");
            Object[] objs = new Object[]{ticket, path, guid};
            logger.error((Object)f.format(objs), (Throwable)e);
            throw new DeploymentException("Unable to open " + path + " for write.", e);
        }
    }

    @Override
    public void write(String ticket, String outputToken, byte[] data, int offset, int count) {
        OutputStream out = this.fOutputs.get(outputToken);
        if (out == null) {
            throw new DeploymentException("Invalid output stream token.");
        }
        try {
            out.write(data, offset, count);
        }
        catch (IOException e) {
            this.commandQueue.queueCommand(new TerminatorCommand(this, ticket, "earlier exception"));
            MessageFormat f = new MessageFormat("unable to write ticket:{0}, outputToken:{1}, data:{2}, offset:{3}, len:{4}");
            Object[] objs = new Object[]{ticket, outputToken, data, offset, count};
            logger.error((Object)f.format(objs), (Throwable)e);
            throw new DeploymentException("Failed write. ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishSend(String ticket, String outputToken) {
        DeploymentTracker tracker = this.getDeploymentTracker(ticket);
        try {
            logger.debug((Object)("finish token" + outputToken));
            OutputStream out = this.fOutputs.get(outputToken);
            if (out == null) {
                throw new DeploymentException("Invalid output token.");
            }
            try {
                out.flush();
                out.close();
            }
            finally {
                this.readerManagement.closeCopyThread(outputToken);
                this.fOutputs.remove(outputToken);
                tracker.removeToken(outputToken);
            }
        }
        catch (RuntimeException e) {
            this.commandQueue.queueCommand(new TerminatorCommand(this, ticket, "earlier exception"));
            MessageFormat f = new MessageFormat("error in finishSend ticket:{0}, outputToken:{1}");
            Object[] objs = new Object[]{ticket, outputToken};
            logger.error((Object)f.format(objs), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            this.commandQueue.queueCommand(new TerminatorCommand(this, ticket, "earlier exception"));
            MessageFormat f = new MessageFormat("error in finishSend ticket:{0}, outputToken:{1}");
            Object[] objs = new Object[]{ticket, outputToken};
            logger.error((Object)f.format(objs), (Throwable)e);
            throw new DeploymentException("FinishSend I/O error.", e);
        }
    }

    public void setAuthenticator(DeploymentReceiverAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public DeploymentReceiverAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setHousekeepers(Set<Housekeeper> housekeepers) {
        this.housekeepers = housekeepers;
    }

    public Set<Housekeeper> getHousekeepers() {
        return this.housekeepers;
    }

    public void setPollDelay(long pollDelay) {
        this.pollDelay = pollDelay;
    }

    public long getPollDelay() {
        return this.pollDelay;
    }

    public void setCommandQueue(DeploymentCommandQueue commandQueue) {
        this.commandQueue = commandQueue;
    }

    public DeploymentCommandQueue getCommandQueue() {
        return this.commandQueue;
    }

    public void setReaderManagement(ReaderManagement readerManagement) {
        this.readerManagement = readerManagement;
    }

    public ReaderManagement getReaderManagement() {
        return this.readerManagement;
    }

    public void setDaemonThread(boolean isDemonThread) {
        this.isDaemonThread = isDemonThread;
    }

    public boolean isDaemonThread() {
        return this.isDaemonThread;
    }
}

