/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import java.io.Serializable;
import org.alfresco.cmis.mapping.AbstractVersioningProperty;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;

public class IsLatestVersionProperty
extends AbstractVersioningProperty {
    public IsLatestVersionProperty(ServiceRegistry serviceRegistry) {
        super(serviceRegistry, "cmis:isLatestVersion");
    }

    public Serializable getValue(NodeRef nodeRef) {
        if (this.isWorkingCopy(nodeRef) || this.getVersionSeries(nodeRef).equals((Object)nodeRef) && !this.hasWorkingCopy(nodeRef)) {
            return Boolean.valueOf(true);
        }
        NodeRef versionSeries = this.getVersionSeries(nodeRef);
        if (this.hasWorkingCopy(versionSeries)) {
            return Boolean.valueOf(false);
        }
        ServiceRegistry serviceRegistry = this.getServiceRegistry();
        String versionLabel = (String)((Object)serviceRegistry.getNodeService().getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL));
        if (versionLabel == null) {
            return Boolean.valueOf(false);
        }
        VersionHistory versionHistory = serviceRegistry.getVersionService().getVersionHistory(versionSeries);
        if (versionHistory == null) {
            return Boolean.valueOf(false);
        }
        Version version = versionHistory.getVersion(versionLabel);
        if (version == null) {
            return Boolean.valueOf(false);
        }
        return Boolean.valueOf(versionHistory.getHeadVersion().getFrozenStateNodeRef().equals((Object)version.getFrozenStateNodeRef()));
    }
}

