/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.search;

import java.util.LinkedHashMap;
import java.util.Map;
import org.alfresco.cmis.CMISDataTypeEnum;
import org.alfresco.cmis.CMISDictionaryService;
import org.alfresco.cmis.CMISPropertyDefinition;
import org.alfresco.cmis.CMISQueryOptions;
import org.alfresco.cmis.CMISResultSetColumn;
import org.alfresco.cmis.CMISResultSetMetaData;
import org.alfresco.cmis.CMISResultSetSelector;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.search.CMISResultSetColumnImpl;
import org.alfresco.cmis.search.CMISResultSetSelectorImpl;
import org.alfresco.repo.search.impl.querymodel.Column;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.repo.search.impl.querymodel.Selector;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.ResultSetType;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.QName;

public class CMISResultSetMetaDataImpl
implements CMISResultSetMetaData {
    private CMISQueryOptions options;
    private SearchParameters searchParams;
    private LimitBy limitBy;
    private Map<String, CMISResultSetColumn> columnMetaData;
    private Map<String, CMISResultSetSelector> selectorMetaData;

    public CMISResultSetMetaDataImpl(CMISQueryOptions options, Query query, LimitBy limitBy, CMISDictionaryService cmisDictionaryService, DictionaryService alfrescoDictionaryService) {
        this.options = options;
        this.searchParams = new SearchParameters((QueryOptions)options);
        this.limitBy = limitBy;
        Map selectors = query.getSource().getSelectors();
        this.selectorMetaData = new LinkedHashMap<String, CMISResultSetSelector>();
        for (Selector selector : selectors.values()) {
            CMISTypeDefinition type = cmisDictionaryService.findTypeForClass(selector.getType(), new CMISScope[0]);
            CMISResultSetSelectorImpl smd = new CMISResultSetSelectorImpl(selector.getAlias(), type);
            this.selectorMetaData.put(smd.getName(), smd);
        }
        this.columnMetaData = new LinkedHashMap<String, CMISResultSetColumn>();
        for (Column column : query.getColumns()) {
            CMISPropertyDefinition propertyDefinition = null;
            CMISDataTypeEnum type = null;
            QName alfrescoPropertyQName = null;
            QName alfrescoDataTypeQName = null;
            if (column.getFunction().getName().equals("PropertyAccessor")) {
                PropertyArgument arg = (PropertyArgument)column.getFunctionArguments().get("Property");
                String propertyName = arg.getPropertyName();
                alfrescoPropertyQName = QName.createQName((String)propertyName);
                PropertyDefinition alfPropDef = alfrescoDictionaryService.getProperty(alfrescoPropertyQName);
                if (alfPropDef == null) {
                    alfrescoPropertyQName = null;
                } else {
                    alfrescoDataTypeQName = alfPropDef.getDataType().getName();
                }
                propertyDefinition = cmisDictionaryService.findProperty(propertyName, null);
                type = propertyDefinition.getDataType();
            }
            if (type == null) {
                type = cmisDictionaryService.findDataType(column.getFunction().getReturnType());
            }
            if (alfrescoDataTypeQName == null) {
                alfrescoDataTypeQName = type.getDefaultDataType();
            }
            CMISResultSetColumnImpl cmd = new CMISResultSetColumnImpl(column.getAlias(), propertyDefinition, type, alfrescoPropertyQName, alfrescoDataTypeQName);
            this.columnMetaData.put(cmd.getName(), cmd);
        }
    }

    public String[] getColumnNames() {
        return this.columnMetaData.keySet().toArray(new String[0]);
    }

    public CMISResultSetColumn[] getColumns() {
        return this.columnMetaData.values().toArray(new CMISResultSetColumn[0]);
    }

    public CMISResultSetColumn getColumn(String name) {
        return this.columnMetaData.get(name);
    }

    public CMISQueryOptions getQueryOptions() {
        return this.options;
    }

    public CMISResultSetSelector getSelector(String name) {
        return this.selectorMetaData.get(name);
    }

    public String[] getSelectorNames() {
        return this.selectorMetaData.keySet().toArray(new String[0]);
    }

    public CMISResultSetSelector[] getSelectors() {
        return this.selectorMetaData.values().toArray(new CMISResultSetSelector[0]);
    }

    public LimitBy getLimitedBy() {
        return this.limitBy;
    }

    public PermissionEvaluationMode getPermissionEvaluationMode() {
        throw new UnsupportedOperationException();
    }

    public ResultSetType getResultSetType() {
        return ResultSetType.COLUMN_AND_NODE_REF;
    }

    public SearchParameters getSearchParameters() {
        return this.searchParams;
    }
}

