/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server;

import org.alfresco.email.server.impl.subetha.SubethaEmailMessage;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.email.EmailMessage;
import org.alfresco.service.cmr.email.EmailService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.aopalliance.intercept.Interceptor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.remoting.rmi.RmiClientInterceptor;

public class EmailServiceRemotable
extends AbstractLifecycleBean
implements EmailService {
    private String rmiRegistryHost;
    private int rmiRegistryPort;
    private EmailService emailServiceProxy;

    public void setRmiRegistryHost(String rmiRegistryHost) {
        this.rmiRegistryHost = rmiRegistryHost;
    }

    public void setRmiRegistryPort(int rmiRegistryPort) {
        this.rmiRegistryPort = rmiRegistryPort;
    }

    public void importMessage(EmailMessage message) {
        if (message instanceof SubethaEmailMessage) {
            ((SubethaEmailMessage)message).setRmiRegistry(this.rmiRegistryHost, this.rmiRegistryPort);
        }
        this.emailServiceProxy.importMessage(message);
    }

    public void importMessage(NodeRef nodeRef, EmailMessage message) {
        if (message instanceof SubethaEmailMessage) {
            ((SubethaEmailMessage)message).setRmiRegistry(this.rmiRegistryHost, this.rmiRegistryPort);
        }
        this.emailServiceProxy.importMessage(nodeRef, message);
    }

    protected void onBootstrap(ApplicationEvent event) {
        if (this.rmiRegistryHost == null) {
            throw new AlfrescoRuntimeException("Property 'rmiRegistryHost' not set");
        }
        if (this.rmiRegistryPort == 0) {
            throw new AlfrescoRuntimeException("Property 'rmiRegistryPort' not set");
        }
        RmiClientInterceptor rmiClientInterceptor = new RmiClientInterceptor();
        rmiClientInterceptor.setRefreshStubOnConnectFailure(true);
        rmiClientInterceptor.setServiceUrl("rmi://" + this.rmiRegistryHost + ":" + this.rmiRegistryPort + "/emailService");
        this.emailServiceProxy = (EmailService)ProxyFactory.getProxy(EmailService.class, (Interceptor)rmiClientInterceptor);
    }

    protected void onShutdown(ApplicationEvent event) {
    }
}

