/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.auth.cifs;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.RealmCallback;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.alfresco.AlfrescoClientInfo;
import org.alfresco.filesys.auth.cifs.CifsAuthenticatorBase;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.auth.AuthenticatorException;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.auth.NTLanManAuthContext;
import org.alfresco.jlan.server.auth.kerberos.KerberosApReq;
import org.alfresco.jlan.server.auth.kerberos.KerberosDetails;
import org.alfresco.jlan.server.auth.kerberos.KrbAuthContext;
import org.alfresco.jlan.server.auth.kerberos.SessionSetupPrivilegedAction;
import org.alfresco.jlan.server.auth.ntlm.NTLM;
import org.alfresco.jlan.server.auth.ntlm.NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.NTLMv2Blob;
import org.alfresco.jlan.server.auth.ntlm.TargetInfo;
import org.alfresco.jlan.server.auth.ntlm.Type1NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type2NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type3NTLMMessage;
import org.alfresco.jlan.server.auth.spnego.NegTokenInit;
import org.alfresco.jlan.server.auth.spnego.NegTokenTarg;
import org.alfresco.jlan.server.auth.spnego.OID;
import org.alfresco.jlan.server.auth.spnego.SPNEGO;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.NoPooledMemoryException;
import org.alfresco.jlan.smb.dcerpc.UUID;
import org.alfresco.jlan.smb.server.SMBSrvException;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.smb.server.VirtualCircuit;
import org.alfresco.jlan.util.DataPacker;
import org.alfresco.jlan.util.HexDump;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.NTLMMode;
import org.alfresco.repo.security.authentication.ntlm.NLTMAuthenticator;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.ietf.jgss.Oid;
import org.springframework.extensions.config.ConfigElement;

public class EnterpriseCifsAuthenticator
extends CifsAuthenticatorBase
implements CallbackHandler {
    private static final String LoginConfigEntry = "AlfrescoCIFS";
    private static final int NTLM_FLAGS = -1610087807;
    private boolean m_useRawNTLMSSP = true;
    private boolean m_acceptNTLMv1 = true;
    private String m_accountName;
    private String m_password;
    private String m_krbRealm;
    private String m_loginEntryName = "AlfrescoCIFS";
    private LoginContext m_loginContext;
    private Vector<Oid> m_mechTypes;
    private byte[] m_negTokenInit;
    private String m_mecListMIC;
    private boolean kerberosDebug;
    private boolean disableNTLM;

    public EnterpriseCifsAuthenticator() {
        this.setExtendedSecurity(true);
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public void setRealm(String realm) {
        this.m_krbRealm = realm;
    }

    public void setJaasConfigEntryName(String jaasConfigEntryName) {
        this.m_loginEntryName = jaasConfigEntryName;
    }

    public void setKerberosDebug(boolean kerberosDebug) {
        this.kerberosDebug = kerberosDebug;
    }

    public void setDisableNTLM(boolean disableNTLM) {
        this.disableNTLM = disableNTLM;
    }

    public void setUseSPNEGO(boolean useSPNEGO) {
        this.m_useRawNTLMSSP = !useSPNEGO;
    }

    public void setDisallowNTLMv1(boolean disallowNTLMv1) {
        this.m_acceptNTLMv1 = !disallowNTLMv1;
    }

    public void initialize(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        this.setKerberosDebug(params.getChild("kerberosDebug") != null);
        ConfigElement krbRealm = params.getChild("Realm");
        if (krbRealm != null && krbRealm.getValue() != null && krbRealm.getValue().length() > 0) {
            this.setRealm(krbRealm.getValue());
            ConfigElement srvPassword = params.getChild("Password");
            if (srvPassword == null || srvPassword.getValue() == null || srvPassword.getValue().length() <= 0) {
                throw new InvalidConfigurationException("CIFS service account password not specified");
            }
            this.setPassword(srvPassword.getValue());
            ConfigElement loginEntry = params.getChild("LoginEntry");
            if (loginEntry != null) {
                if (loginEntry.getValue() != null && loginEntry.getValue().length() > 0) {
                    this.setJaasConfigEntryName(loginEntry.getValue());
                } else {
                    throw new InvalidConfigurationException("Invalid login entry specified");
                }
            }
            this.setDisableNTLM(params.getChild("disableNTLM") != null);
            this.setUseSPNEGO(true);
        } else {
            this.setUseSPNEGO(params.getChild("useSPNEGO") != null);
        }
        this.setDisallowNTLMv1(params.getChild("disallowNTLMv1") != null);
        super.initialize(config, params);
    }

    public void initialize() throws InvalidConfigurationException {
        super.initialize();
        if (this.kerberosDebug) {
            System.setProperty("sun.security.jgss.debug", "true");
            System.setProperty("sun.security.krb5.debug", "true");
        }
        if (this.m_krbRealm != null && this.m_krbRealm.length() > 0) {
            if (this.m_password == null || this.m_password.length() == 0) {
                throw new InvalidConfigurationException("CIFS service account password not specified");
            }
            if (this.m_loginEntryName == null || this.m_loginEntryName.length() == 0) {
                throw new InvalidConfigurationException("Invalid login entry specified");
            }
            try {
                this.m_loginContext = new LoginContext(this.m_loginEntryName, this);
                this.m_loginContext.login();
            }
            catch (LoginException ex) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"CIFS Kerberos authenticator error", (Throwable)ex);
                }
                throw new InvalidConfigurationException("Failed to login CIFS server service");
            }
            Subject subj = this.m_loginContext.getSubject();
            Principal princ = subj.getPrincipals().iterator().next();
            this.m_accountName = princ.getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Logged on using principal " + this.m_accountName));
            }
            this.m_mechTypes = new Vector();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Enabling mechTypes :-");
                logger.debug((Object)"  Kerberos5");
                logger.debug((Object)"  MS-Kerberos5");
            }
            this.m_mechTypes.add(OID.KERBEROS5);
            this.m_mechTypes.add(OID.MSKERBEROS5);
            if (!this.disableNTLM) {
                this.m_mechTypes.add(OID.NTLMSSP);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"  NTLMSSP");
                }
            }
            this.m_useRawNTLMSSP = false;
        } else if (!this.m_useRawNTLMSSP) {
            this.m_mechTypes = new Vector();
            this.m_mechTypes.add(OID.NTLMSSP);
        }
        if (!(this.isKerberosEnabled() || this.getAuthenticationComponent() instanceof NLTMAuthenticator && this.getNTLMAuthenticator().getNTLMMode() == NTLMMode.MD4_PROVIDER)) {
            logger.error((Object)"No valid CIFS authentication combination available");
            logger.error((Object)"Either enable Kerberos support or use an SSO-enabled authentication component that supports MD4 hashed passwords");
            throw new AlfrescoRuntimeException("Invalid CIFS authenticator configuration");
        }
    }

    private synchronized byte[] getNegTokenInit() throws AuthenticatorException {
        String mecListMIC = null;
        byte[] encoded = null;
        if (this.m_krbRealm != null && this.m_krbRealm.length() > 0) {
            StringBuilder mic = new StringBuilder();
            mic.append("cifs/");
            mic.append(this.m_config.getServerName().toLowerCase());
            mic.append("@");
            mic.append(this.m_krbRealm);
            mecListMIC = mic.toString();
            if (mecListMIC.equals(this.m_mecListMIC)) {
                encoded = this.m_negTokenInit;
            }
        } else if (!this.m_useRawNTLMSSP) {
            encoded = this.m_negTokenInit;
        } else {
            return null;
        }
        if (encoded != null) {
            return encoded;
        }
        try {
            NegTokenInit negTokenInit = new NegTokenInit(this.m_mechTypes, mecListMIC);
            this.m_negTokenInit = encoded = negTokenInit.encode();
            this.m_mecListMIC = mecListMIC;
        }
        catch (IOException ex) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"Error creating SPNEGO NegTokenInit blob", (Throwable)ex);
            }
            throw new AuthenticatorException("Failed to create SPNEGO NegTokenInit blob");
        }
        return encoded;
    }

    private final boolean isKerberosEnabled() {
        return this.m_krbRealm != null && this.m_loginContext != null;
    }

    private final boolean useRawNTLMSSP() {
        return this.m_useRawNTLMSSP;
    }

    private final boolean acceptNTLMv1Logon() {
        return this.m_acceptNTLMv1;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback cb;
            if (callbacks[i] instanceof NameCallback) {
                cb = (NameCallback)callbacks[i];
                ((NameCallback)cb).setName("");
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                cb = (PasswordCallback)callbacks[i];
                ((PasswordCallback)cb).setPassword(this.m_password.toCharArray());
                continue;
            }
            if (callbacks[i] instanceof RealmCallback) {
                cb = (RealmCallback)callbacks[i];
                ((TextInputCallback)cb).setText(this.m_krbRealm);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }

    public int getEncryptionKeyLength() {
        return 8;
    }

    public int getServerCapabilities() {
        return -2147433860;
    }

    public void generateNegotiateResponse(SMBSrvSession sess, SMBSrvPacket respPkt, boolean extendedSecurity) throws AuthenticatorException {
        if (!extendedSecurity) {
            super.generateNegotiateResponse(sess, respPkt, extendedSecurity);
            return;
        }
        if ((respPkt.getFlags2() & 0x800) == 0) {
            respPkt.setFlags2(respPkt.getFlags2() + 2048);
        }
        int pos = respPkt.getByteOffset();
        byte[] buf = respPkt.getBuffer();
        UUID serverGUID = sess.getSMBServer().getServerGUID();
        System.arraycopy(serverGUID.getBytes(), 0, buf, pos, 16);
        pos += 16;
        if (!this.useRawNTLMSSP()) {
            byte[] negTokenInit = this.getNegTokenInit();
            System.arraycopy(negTokenInit, 0, buf, pos, this.m_negTokenInit.length);
            pos += negTokenInit.length;
        }
        respPkt.setByteCount(pos - respPkt.getByteOffset());
    }

    public void processSessionSetup(final SMBSrvSession sess, final SMBSrvPacket reqPkt) throws SMBSrvException {
        if (!reqPkt.checkPacketIsValid(12, 0)) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        if (reqPkt.getParameterCount() == 13) {
            try {
                this.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    @Override
                    public Object execute() throws Throwable {
                        EnterpriseCifsAuthenticator.this.doHashedPasswordLogon(sess, reqPkt);
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                throw new SMBSrvException(-1073741790, 1, 5);
            }
            return;
        }
        int maxBufSize = reqPkt.getParameter(2);
        int maxMpx = reqPkt.getParameter(3);
        int vcNum = reqPkt.getParameter(4);
        final int secBlobLen = reqPkt.getParameter(7);
        int capabs = reqPkt.getParameterLong(10);
        int dataPos = reqPkt.getByteOffset();
        final byte[] buf = reqPkt.getBuffer();
        final boolean isUni = reqPkt.isUnicode();
        final int secBlobPos = dataPos;
        reqPkt.setPosition(dataPos += secBlobLen);
        String domain = "";
        if (reqPkt.hasMoreData() && (domain = reqPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        String clientOS = "";
        if (reqPkt.hasMoreData() && (clientOS = reqPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("NT Session setup " + (this.useRawNTLMSSP() ? "NTLMSSP" : "SPNEGO") + ", MID=" + reqPkt.getMultiplexId() + ", UID=" + reqPkt.getUserId() + ", PID=" + reqPkt.getProcessId()));
        }
        sess.setClientMaximumBufferSize(maxBufSize != 0 ? maxBufSize : 65540);
        sess.setClientMaximumMultiplex(maxMpx);
        sess.setClientCapabilities(capabs);
        final AlfrescoClientInfo client = new AlfrescoClientInfo();
        client.setDomain(domain);
        client.setOperatingSystem(clientOS);
        client.setLogonType(0);
        if (sess.hasRemoteAddress()) {
            client.setClientAddress(sess.getRemoteAddress().getHostAddress());
        }
        client.setProcessId(reqPkt.getProcessId());
        Object setupObj = sess.getSetupObject(client.getProcessId());
        byte[] respBlob = null;
        try {
            boolean isNTLMSSP;
            if (secBlobLen >= NTLM.Signature.length) {
                int idx;
                for (idx = 0; idx < NTLM.Signature.length && buf[secBlobPos + idx] == NTLM.Signature[idx]; ++idx) {
                }
                isNTLMSSP = idx == NTLM.Signature.length;
            } else {
                isNTLMSSP = false;
            }
            respBlob = this.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<byte[]>(){

                @Override
                public byte[] execute() throws Throwable {
                    if (isNTLMSSP) {
                        return EnterpriseCifsAuthenticator.this.doNtlmsspSessionSetup(sess, client, buf, secBlobPos, secBlobLen, isUni);
                    }
                    return EnterpriseCifsAuthenticator.this.doSpnegoSessionSetup(sess, client, buf, secBlobPos, secBlobLen, isUni);
                }
            });
        }
        catch (Exception ex) {
            sess.removeSetupObject(client.getProcessId());
            throw new SMBSrvException(-1073741790, 1, 5);
        }
        if (logger.isDebugEnabled() && sess.hasDebug(32)) {
            logger.debug((Object)("User " + client.getUserName() + " logged on " + (client != null ? " (type " + client.getLogonTypeString() + ")" : "")));
        }
        if (sess.getClientInformation() == null || sess.getClientInformation().getUserName().length() == 0) {
            sess.setClientInformation((ClientInfo)client);
        }
        int respLen = respBlob != null ? respBlob.length : 0;
        SMBSrvPacket respPkt = reqPkt;
        boolean loggedOn = false;
        if (respBlob != null || sess.hasSetupObject(client.getProcessId()) || setupObj != null) {
            if (sess.hasSetupObject(client.getProcessId())) {
                respPkt.setLongErrorCode(-1073741802);
            } else {
                respPkt.setLongErrorCode(0);
                loggedOn = true;
            }
            respPkt.setParameterCount(4);
            int reqLen = respLen + 100;
            if (reqLen > respPkt.getAvailableLength()) {
                try {
                    respPkt = sess.getPacketPool().allocatePacket(respPkt.getByteOffset() + reqLen, reqPkt);
                }
                catch (NoPooledMemoryException ex) {
                    if (this.hasDebug()) {
                        Debug.println((String)("Authenticator failed to allocate packet from pool, reqSiz=" + (respPkt.getByteOffset() + respLen)));
                    }
                    throw new SMBSrvException(-1073741811, 83, 2);
                }
            }
            respPkt.setParameter(0, 255);
            respPkt.setParameter(1, 0);
            respPkt.setParameter(2, 0);
            respPkt.setParameter(3, respLen);
        } else {
            respPkt.setLongErrorCode(0);
            respPkt.setParameterCount(12);
            respPkt.setParameter(0, 255);
            respPkt.setParameter(1, 0);
            respPkt.setParameter(2, 65540);
            respPkt.setParameter(3, 4);
            respPkt.setParameter(4, 0);
            respPkt.setParameterLong(5, 0);
            respPkt.setParameter(7, respLen);
            respPkt.setParameterLong(8, 0);
            respPkt.setParameterLong(10, this.getServerCapabilities());
            loggedOn = true;
        }
        int uid = 0;
        if (loggedOn) {
            sess.removeSetupObject(client.getProcessId());
            this.checkForAdminUserName(client);
            this.getHomeFolderForUser(client);
            VirtualCircuit vc = new VirtualCircuit(vcNum, (ClientInfo)client);
            uid = sess.addVirtualCircuit(vc);
            if (uid == -1) {
                if (logger.isDebugEnabled() && sess.hasDebug(32)) {
                    logger.debug((Object)("Failed to allocate UID for virtual circuit, " + vc));
                }
                throw new SMBSrvException(-1073741715, 5, 1);
            }
            if (logger.isDebugEnabled() && sess.hasDebug(32)) {
                logger.debug((Object)("Allocated UID=" + uid + " for VC=" + vc));
            }
        }
        respPkt.setCommand(reqPkt.getCommand());
        respPkt.setByteCount(0);
        respPkt.setTreeId(0);
        respPkt.setUserId(uid);
        int flags = respPkt.getFlags();
        respPkt.setFlags(flags &= 0xFFFFFFF7);
        int flags2 = 18433;
        if (isUni) {
            flags2 += 32768;
        }
        respPkt.setFlags2(flags2);
        int pos = respPkt.getByteOffset();
        byte[] buf1 = respPkt.getBuffer();
        if (respBlob != null) {
            System.arraycopy(respBlob, 0, buf1, pos, respBlob.length);
            pos += respBlob.length;
        }
        if (isUni) {
            pos = DataPacker.wordAlign((int)pos);
        }
        pos = DataPacker.putString((String)"Java", (byte[])buf1, (int)pos, (boolean)true, (boolean)isUni);
        pos = DataPacker.putString((String)("Alfresco CIFS Server " + sess.getServer().isVersion()), (byte[])buf1, (int)pos, (boolean)true, (boolean)isUni);
        pos = DataPacker.putString((String)this.getCIFSConfig().getDomainName(), (byte[])buf1, (int)pos, (boolean)true, (boolean)isUni);
        respPkt.setByteCount(pos - respPkt.getByteOffset());
    }

    private final byte[] doNtlmsspSessionSetup(SMBSrvSession sess, ClientInfo client, byte[] secbuf, int secpos, int seclen, boolean unicode) throws SMBSrvException {
        int msgType = NTLMMessage.isNTLMType((byte[])secbuf, (int)secpos);
        byte[] respBlob = null;
        if (msgType == -1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invalid NTLMSSP token received");
                logger.debug((Object)("  Token=" + HexDump.hexString((byte[])secbuf, (int)secpos, (int)seclen, (String)" ")));
            }
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        if (msgType == 1) {
            Type1NTLMMessage type1Msg = new Type1NTLMMessage(secbuf, secpos, seclen);
            int ntlmFlags = type1Msg.getFlags() & 0xA0080281;
            NTLanManAuthContext ntlmCtx = new NTLanManAuthContext();
            String domain = sess.getSMBServer().getServerName();
            ArrayList<TargetInfo> tList = new ArrayList<TargetInfo>();
            tList.add(new TargetInfo(2, domain));
            tList.add(new TargetInfo(1, sess.getServerName()));
            tList.add(new TargetInfo(4, domain));
            tList.add(new TargetInfo(3, domain));
            ntlmFlags = 1619657221;
            if (this.acceptNTLMv1Logon()) {
                ntlmFlags -= Integer.MIN_VALUE;
            }
            Type2NTLMMessage type2Msg = new Type2NTLMMessage();
            type2Msg.buildType2(ntlmFlags, domain, ntlmCtx.getChallenge(), null, tList);
            sess.setSetupObject(client.getProcessId(), (Object)type2Msg);
            respBlob = type2Msg.getBytes();
        } else if (msgType == 3) {
            Type3NTLMMessage type3Msg = new Type3NTLMMessage(secbuf, secpos, seclen, unicode);
            if (!sess.hasSetupObject(client.getProcessId()) || !(sess.getSetupObject(client.getProcessId()) instanceof Type2NTLMMessage)) {
                sess.removeSetupObject(client.getProcessId());
                throw new SMBSrvException(-1073741715, 5, 1);
            }
            if (type3Msg.hasFlag(0x20000000) && type3Msg.hasFlag(524288)) {
                if (type3Msg.getNTLMHashLength() > 24) {
                    this.doNTLMv2Logon(sess, client, type3Msg);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Logged on using NTLMSSP/NTLMv2");
                    }
                } else {
                    this.doNTLMv2SessionKeyLogon(sess, client, type3Msg);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Logged on using NTLMSSP/NTLMv2SessKey");
                    }
                }
            } else {
                this.doNTLMv1Logon(sess, client, type3Msg);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Logged on using NTLMSSP/NTLMv1");
                }
            }
        }
        return respBlob;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final byte[] doSpnegoSessionSetup(SMBSrvSession sess, ClientInfo client, byte[] secbuf, int secpos, int seclen, boolean unicode) throws SMBSrvException {
        NegTokenInit negToken;
        int tokType = -1;
        try {
            tokType = SPNEGO.checkTokenType((byte[])secbuf, (int)secpos, (int)seclen);
        }
        catch (IOException ex) {
            // empty catch block
        }
        NegTokenTarg negTarg = null;
        if (tokType == 1 && sess.hasSetupObject(client.getProcessId()) && sess.getSetupObject(client.getProcessId()) instanceof Type2NTLMMessage) {
            negToken = new NegTokenTarg();
            try {
                negToken.decode(secbuf, secpos, seclen);
            }
            catch (IOException ex) {
                logger.error((Object)ex);
                throw new SMBSrvException(-1073741715, 5, 1);
            }
            byte[] ntlmsspBlob = negToken.getResponseToken();
            byte[] ntlmsspRespBlob = this.doNtlmsspSessionSetup(sess, client, ntlmsspBlob, 0, ntlmsspBlob.length, unicode);
            int spnegoSts = 0;
            if (sess.hasSetupObject(client.getProcessId())) {
                spnegoSts = 1;
            }
            negTarg = new NegTokenTarg(spnegoSts, null, ntlmsspRespBlob);
        } else {
            if (tokType != 0) {
                logger.error((Object)"Unknown SPNEGO token type");
                throw new SMBSrvException(-1073741715, 5, 1);
            }
            negToken = new NegTokenInit();
            try {
                negToken.decode(secbuf, secpos, seclen);
            }
            catch (IOException ex) {
                logger.error((Object)ex);
                throw new SMBSrvException(-1073741715, 5, 1);
            }
            String oidStr = null;
            if (negToken.numberOfOids() > 0) {
                oidStr = negToken.getOidAt(0).toString();
            }
            if (oidStr != null && oidStr.equals("1.3.6.1.4.1.311.2.2.10")) {
                byte[] ntlmsspBlob = negToken.getMechtoken();
                byte[] ntlmsspRespBlob = this.doNtlmsspSessionSetup(sess, client, ntlmsspBlob, 0, ntlmsspBlob.length, unicode);
                int spnegoSts = 0;
                if (sess.hasSetupObject(client.getProcessId())) {
                    spnegoSts = 1;
                }
                negTarg = new NegTokenTarg(spnegoSts, OID.NTLMSSP, ntlmsspRespBlob);
            } else if (oidStr != null && (oidStr.equals("1.2.840.48018.1.2.2") || oidStr.equals("1.2.840.113554.1.2.2"))) {
                negTarg = this.doKerberosLogon(sess, negToken, client);
            } else {
                if (!logger.isDebugEnabled()) throw new SMBSrvException(-1073741715, 5, 1);
                logger.debug((Object)"No matching authentication OID found");
                logger.debug((Object)("  " + negToken.toString()));
                throw new SMBSrvException(-1073741715, 5, 1);
            }
        }
        byte[] respBlob = null;
        try {
            return negTarg.encode();
        }
        catch (IOException ex) {
            if (!logger.isDebugEnabled()) throw new SMBSrvException(-1073741715, 5, 1);
            logger.debug((Object)"Failed to encode NegTokenTarg", (Throwable)ex);
            throw new SMBSrvException(-1073741715, 5, 1);
        }
    }

    private final NegTokenTarg doKerberosLogon(SMBSrvSession sess, NegTokenInit negToken, ClientInfo client) throws SMBSrvException {
        NegTokenTarg negTokenTarg;
        block30: {
            KerberosDetails krbDetails = null;
            negTokenTarg = null;
            try {
                KerberosApReq krbApReq = new KerberosApReq();
                krbApReq.parseMechToken(negToken.getMechtoken());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Kerberos AP-REQ - " + krbApReq));
                }
                KrbAuthContext krbAuthCtx = null;
                if (krbApReq.hasMutualAuthentication()) {
                    krbAuthCtx = new KrbAuthContext();
                    krbAuthCtx.setDebug(this.hasDebug());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Kerberos mutual auth required, parsing AP-REQ");
                    }
                    try {
                        krbAuthCtx.parseKerberosApReq(this.m_loginContext.getSubject(), krbApReq);
                    }
                    catch (IOException ex) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Failed to parse AP-REQ, " + ex.toString()));
                        }
                        throw new SMBSrvException(-1073741715, 1, 5);
                    }
                }
                SessionSetupPrivilegedAction sessSetupAction = new SessionSetupPrivilegedAction(this.m_accountName, negToken.getMechtoken());
                Object result = Subject.doAs(this.m_loginContext.getSubject(), sessSetupAction);
                if (result != null) {
                    String userName;
                    block29: {
                        krbDetails = (KerberosDetails)result;
                        Oid respOid = null;
                        if (negToken.hasOid(OID.MSKERBEROS5)) {
                            respOid = OID.MSKERBEROS5;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Using OID MS Kerberos5 for NegTokenTarg");
                            }
                        } else {
                            respOid = OID.KERBEROS5;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Using OID Kerberos5 for NegTokenTarg");
                            }
                        }
                        if (krbAuthCtx != null) {
                            try {
                                byte[] respToken = krbAuthCtx.parseKerberosApRep(krbDetails.getResponseToken());
                                krbDetails.setResponseToken(respToken);
                                negTokenTarg = new NegTokenTarg(0, respOid, krbDetails.getResponseToken());
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Created NegTokenTarg using updated AP-REP, added subkey");
                                }
                                break block29;
                            }
                            catch (Exception ex) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"AP-REP Error:");
                                    logger.debug((Object)ex);
                                }
                                break block29;
                            }
                        }
                        negTokenTarg = new NegTokenTarg(0, respOid, krbDetails.getResponseToken());
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Created NegTokenTarg using standard Krb5 API response");
                        }
                    }
                    if ((userName = krbDetails.getUserName()) != null) {
                        if (userName.endsWith("$")) {
                            client.setLogonType(2);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Machine account logon, " + userName + ", as null logon"));
                            }
                        } else {
                            try {
                                AlfrescoClientInfo alfClient = (AlfrescoClientInfo)client;
                                this.getAuthenticationComponent().setCurrentUser(this.mapUserNameToPerson(krbDetails.getUserName()));
                                alfClient.setAuthenticationTicket(this.getAuthenticationService().getCurrentTicket());
                            }
                            catch (AuthenticationException e) {
                                throw new SMBSrvException(-1073741715, 1, 5);
                            }
                            client.setUserName(krbDetails.getUserName());
                            client.setGuest(false);
                            sess.setLoggedOn(true);
                        }
                    } else {
                        client.setLogonType(2);
                    }
                    sess.setLoggedOn(true);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Logged on using Kerberos, user " + userName));
                    }
                    break block30;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"No SPNEGO response, Kerberos logon failed");
                }
                throw new SMBSrvException(-1073741715, 1, 5);
            }
            catch (Exception ex) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"Kerberos logon error");
                    logger.error((Object)ex);
                }
                throw new SMBSrvException(-1073741715, 1, 5);
            }
        }
        return negTokenTarg;
    }

    private final void doNTLMv1Logon(SMBSrvSession sess, ClientInfo client, Type3NTLMMessage type3Msg) throws SMBSrvException {
        String userName;
        if (!this.acceptNTLMv1Logon()) {
            logger.warn((Object)("NTLMv1 not accepted, client " + sess.getRemoteName()));
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        Type2NTLMMessage type2Msg = (Type2NTLMMessage)sess.getSetupObject(client.getProcessId());
        sess.removeSetupObject(client.getProcessId());
        if (this.getNTLMAuthenticator().getNTLMMode() == NTLMMode.MD4_PROVIDER) {
            userName = type3Msg.getUserName();
            if (userName.length() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Null logon");
                }
                client.setLogonType(2);
                return;
            }
            String md4hash = this.getNTLMAuthenticator().getMD4HashedPassword(userName);
            if (md4hash != null) {
                byte[] p21 = new byte[21];
                byte[] md4byts = this.m_md4Encoder.decodeHash(md4hash);
                System.arraycopy(md4byts, 0, p21, 0, 16);
                byte[] localHash = null;
                try {
                    localHash = this.getEncryptor().doNTLM1Encryption(p21, type2Msg.getChallenge());
                }
                catch (NoSuchAlgorithmException ex) {
                    // empty catch block
                }
                byte[] clientHash = type3Msg.getNTLMHash();
                if (clientHash != null && localHash != null && clientHash.length == localHash.length) {
                    int i;
                    for (i = 0; i < clientHash.length && clientHash[i] == localHash[i]; ++i) {
                    }
                    if (i != clientHash.length) {
                        throw new SMBSrvException(-1073741715, 5, 1);
                    }
                }
                try {
                    AlfrescoClientInfo alfClient = (AlfrescoClientInfo)client;
                    this.getAuthenticationComponent().setCurrentUser(this.mapUserNameToPerson(userName));
                    alfClient.setAuthenticationTicket(this.getAuthenticationService().getCurrentTicket());
                }
                catch (AuthenticationException e) {
                    throw new SMBSrvException(-1073741715, 1, 5);
                }
            }
            logger.warn((Object)("User does not exist, " + userName));
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        logger.warn((Object)"Authentication component does not support MD4 password hashes");
        throw new SMBSrvException(-1073741715, 5, 1);
        client.setUserName(userName.toLowerCase());
        client.setGuest(false);
        sess.setLoggedOn(true);
    }

    private final void doNTLMv1Logon(SMBSrvSession sess, ClientInfo client) throws SMBSrvException {
        if (!this.acceptNTLMv1Logon()) {
            logger.warn((Object)("NTLMv1 not accepted, client " + sess.getRemoteName()));
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        if (this.getNTLMAuthenticator().getNTLMMode() == NTLMMode.MD4_PROVIDER) {
            if (client.getUserName().length() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Null logon");
                }
                client.setLogonType(2);
                return;
            }
            String md4hash = this.getNTLMAuthenticator().getMD4HashedPassword(client.getUserName());
            if (md4hash != null) {
                byte[] p21 = new byte[21];
                byte[] md4byts = this.m_md4Encoder.decodeHash(md4hash);
                System.arraycopy(md4byts, 0, p21, 0, 16);
                byte[] challenge = null;
                if (sess.hasAuthenticationContext()) {
                    NTLanManAuthContext ntlmCtx = (NTLanManAuthContext)sess.getAuthenticationContext();
                    challenge = ntlmCtx.getChallenge();
                }
                byte[] localHash = null;
                try {
                    localHash = this.getEncryptor().doNTLM1Encryption(p21, challenge);
                }
                catch (NoSuchAlgorithmException ex) {
                    // empty catch block
                }
                byte[] clientHash = client.getPassword();
                if (clientHash != null && localHash != null && clientHash.length == localHash.length) {
                    int i;
                    for (i = 0; i < clientHash.length && clientHash[i] == localHash[i]; ++i) {
                    }
                    if (i != clientHash.length) {
                        throw new SMBSrvException(-1073741715, 5, 1);
                    }
                }
                try {
                    AlfrescoClientInfo alfClient = (AlfrescoClientInfo)client;
                    this.getAuthenticationComponent().setCurrentUser(this.mapUserNameToPerson(client.getUserName()));
                    alfClient.setAuthenticationTicket(this.getAuthenticationService().getCurrentTicket());
                }
                catch (AuthenticationException e) {
                    throw new SMBSrvException(-1073741715, 1, 5);
                }
            }
            logger.warn((Object)("User does not exist, " + client.getUserName()));
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        logger.warn((Object)"Authentication component does not support MD4 password hashes");
        throw new SMBSrvException(-1073741715, 5, 1);
        client.setGuest(false);
        sess.setLoggedOn(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doNTLMv2Logon(SMBSrvSession sess, ClientInfo client, Type3NTLMMessage type3Msg) throws SMBSrvException {
        Type2NTLMMessage type2Msg = (Type2NTLMMessage)sess.getSetupObject(client.getProcessId());
        sess.removeSetupObject(client.getProcessId());
        if (this.getNTLMAuthenticator().getNTLMMode() != NTLMMode.MD4_PROVIDER) {
            logger.warn((Object)"Authentication component does not support MD4 password hashes");
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        String userName = type3Msg.getUserName();
        if (userName.length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Null logon");
            }
            client.setLogonType(2);
            return;
        }
        String md4hash = this.getNTLMAuthenticator().getMD4HashedPassword(userName);
        if (md4hash == null) {
            logger.warn((Object)("User does not exist, " + userName));
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        try {
            byte[] v2hash = this.getEncryptor().doNTLM2Encryption(this.m_md4Encoder.decodeHash(md4hash), type3Msg.getUserName(), type3Msg.getDomain());
            NTLMv2Blob v2blob = new NTLMv2Blob(type3Msg.getNTLMHash());
            byte[] srvChallenge = type2Msg.getChallenge();
            byte[] srvHmac = v2blob.calculateHMAC(srvChallenge, v2hash);
            byte[] clientHmac = v2blob.getHMAC();
            if (clientHmac != null && srvHmac != null && clientHmac.length == srvHmac.length) {
                int i;
                for (i = 0; i < clientHmac.length && clientHmac[i] == srvHmac[i]; ++i) {
                }
                if (i != clientHmac.length) {
                    throw new SMBSrvException(-1073741715, 5, 1);
                }
            }
            AlfrescoClientInfo alfClient = (AlfrescoClientInfo)client;
            this.getAuthenticationComponent().setCurrentUser(this.mapUserNameToPerson(userName));
            alfClient.setAuthenticationTicket(this.getAuthenticationService().getCurrentTicket());
            client.setUserName(userName.toLowerCase());
            client.setGuest(false);
            sess.setLoggedOn(true);
            return;
        }
        catch (Exception ex) {
            if (ex instanceof AuthenticationException) {
                logger.debug((Object)ex);
                throw new SMBSrvException(-1073741715, 5, 1);
            }
            logger.error((Object)ex);
            throw new SMBSrvException(-1073741715, 5, 1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doNTLMv2Logon(SMBSrvSession sess, ClientInfo client) throws SMBSrvException {
        if (this.getNTLMAuthenticator().getNTLMMode() != NTLMMode.MD4_PROVIDER) {
            logger.warn((Object)"Authentication component does not support MD4 password hashes");
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        if (client.getUserName().length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Null logon");
            }
            client.setLogonType(2);
            return;
        }
        String md4hash = this.getNTLMAuthenticator().getMD4HashedPassword(client.getUserName());
        if (md4hash == null) {
            logger.warn((Object)("User does not exist, " + client.getUserName()));
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        try {
            NTLMv2Blob v2blob = new NTLMv2Blob(client.getPassword());
            byte[] v2hash = this.getEncryptor().doNTLM2Encryption(this.m_md4Encoder.decodeHash(md4hash), client.getUserName(), client.getDomain());
            byte[] srvChallenge = null;
            if (sess.hasAuthenticationContext()) {
                NTLanManAuthContext ntlmCtx = (NTLanManAuthContext)sess.getAuthenticationContext();
                srvChallenge = ntlmCtx.getChallenge();
            }
            byte[] srvHmac = v2blob.calculateHMAC(srvChallenge, v2hash);
            byte[] clientHmac = v2blob.getHMAC();
            if (clientHmac != null && srvHmac != null && clientHmac.length == srvHmac.length) {
                int i;
                for (i = 0; i < clientHmac.length && clientHmac[i] == srvHmac[i]; ++i) {
                }
                if (i != clientHmac.length) {
                    throw new SMBSrvException(-1073741715, 5, 1);
                }
            }
            AlfrescoClientInfo alfClient = (AlfrescoClientInfo)client;
            this.getAuthenticationComponent().setCurrentUser(this.mapUserNameToPerson(client.getUserName()));
            alfClient.setAuthenticationTicket(this.getAuthenticationService().getCurrentTicket());
            client.setGuest(false);
            sess.setLoggedOn(true);
            return;
        }
        catch (Exception ex) {
            if (ex instanceof AuthenticationException) {
                logger.debug((Object)ex);
                throw new SMBSrvException(-1073741715, 5, 1);
            }
            logger.error((Object)ex);
            throw new SMBSrvException(-1073741715, 5, 1);
        }
    }

    private final void doNTLMv2SessionKeyLogon(SMBSrvSession sess, ClientInfo client, Type3NTLMMessage type3Msg) throws SMBSrvException {
        String userName;
        Type2NTLMMessage type2Msg = (Type2NTLMMessage)sess.getSetupObject(client.getProcessId());
        sess.removeSetupObject(client.getProcessId());
        if (this.getNTLMAuthenticator().getNTLMMode() == NTLMMode.MD4_PROVIDER) {
            userName = type3Msg.getUserName();
            if (userName.length() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Null logon");
                }
                client.setLogonType(2);
                return;
            }
            String md4hash = this.getNTLMAuthenticator().getMD4HashedPassword(userName);
            if (md4hash != null) {
                byte[] nonce = new byte[16];
                System.arraycopy(type2Msg.getChallenge(), 0, nonce, 0, 8);
                System.arraycopy(type3Msg.getLMHash(), 0, nonce, 8, 8);
                MessageDigest md5 = null;
                byte[] v2challenge = new byte[8];
                try {
                    md5 = MessageDigest.getInstance("MD5");
                    md5.update(nonce);
                    byte[] md5nonce = md5.digest();
                    System.arraycopy(md5nonce, 0, v2challenge, 0, 8);
                }
                catch (NoSuchAlgorithmException ex) {
                    logger.error((Object)ex);
                }
                byte[] p21 = new byte[21];
                byte[] md4byts = this.m_md4Encoder.decodeHash(md4hash);
                System.arraycopy(md4byts, 0, p21, 0, 16);
                byte[] localHash = null;
                try {
                    localHash = this.getEncryptor().doNTLM1Encryption(p21, v2challenge);
                }
                catch (NoSuchAlgorithmException ex) {
                    logger.error((Object)ex);
                }
                byte[] clientHash = type3Msg.getNTLMHash();
                if (clientHash != null && localHash != null && clientHash.length == localHash.length) {
                    int i;
                    for (i = 0; i < clientHash.length && clientHash[i] == localHash[i]; ++i) {
                    }
                    if (i != clientHash.length) {
                        throw new SMBSrvException(-1073741715, 5, 1);
                    }
                }
                try {
                    AlfrescoClientInfo alfClient = (AlfrescoClientInfo)client;
                    this.getAuthenticationComponent().setCurrentUser(this.mapUserNameToPerson(userName));
                    alfClient.setAuthenticationTicket(this.getAuthenticationService().getCurrentTicket());
                }
                catch (AuthenticationException e) {
                    throw new SMBSrvException(-1073741715, 1, 5);
                }
            }
            logger.warn((Object)("User does not exist, " + userName));
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        logger.warn((Object)"Authentication component does not support MD4 password hashes");
        throw new SMBSrvException(-1073741715, 5, 1);
        client.setUserName(userName.toLowerCase());
        client.setGuest(false);
        sess.setLoggedOn(true);
    }

    private final void doHashedPasswordLogon(SMBSrvSession sess, SMBSrvPacket reqPkt) throws SMBSrvException {
        VirtualCircuit vc;
        int uid;
        if (!reqPkt.checkPacketIsValid(13, 0)) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        int maxBufSize = reqPkt.getParameter(2);
        int maxMpx = reqPkt.getParameter(3);
        int vcNum = reqPkt.getParameter(4);
        int ascPwdLen = reqPkt.getParameter(7);
        int uniPwdLen = reqPkt.getParameter(8);
        int capabs = reqPkt.getParameterLong(11);
        byte[] buf = reqPkt.getBuffer();
        boolean isUni = reqPkt.isUnicode();
        byte[] ascPwd = reqPkt.unpackBytes(ascPwdLen);
        byte[] uniPwd = reqPkt.unpackBytes(uniPwdLen);
        String user = reqPkt.unpackString(isUni);
        if (user == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        String domain = "";
        if (reqPkt.hasMoreData() && (domain = reqPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        String clientOS = "";
        if (reqPkt.hasMoreData() && (clientOS = reqPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        if (logger.isDebugEnabled() && sess.hasDebug(32)) {
            logger.debug((Object)("NT Session setup from user=" + user + ", password=" + (uniPwd != null ? HexDump.hexString((byte[])uniPwd) : "none") + ", ANSIpwd=" + (ascPwd != null ? HexDump.hexString((byte[])ascPwd) : "none") + ", domain=" + domain + ", os=" + clientOS + ", VC=" + vcNum + ", maxBuf=" + maxBufSize + ", maxMpx=" + maxMpx + ", authCtx=" + sess.getAuthenticationContext()));
            logger.debug((Object)("  MID=" + reqPkt.getMultiplexId() + ", UID=" + reqPkt.getUserId() + ", PID=" + reqPkt.getProcessId()));
        }
        sess.setClientMaximumBufferSize(maxBufSize);
        sess.setClientMaximumMultiplex(maxMpx);
        sess.setClientCapabilities(capabs);
        AlfrescoClientInfo client = new AlfrescoClientInfo(user, uniPwd);
        client.setANSIPassword(ascPwd);
        client.setDomain(domain);
        client.setOperatingSystem(clientOS);
        if (sess.hasRemoteAddress()) {
            client.setClientAddress(sess.getRemoteAddress().getHostAddress());
        }
        if (user.length() == 0 && domain.length() == 0 && uniPwdLen == 0) {
            client.setLogonType(2);
        }
        boolean isGuest = false;
        if (uniPwd != null) {
            if (uniPwd.length == 24) {
                this.doNTLMv1Logon(sess, client);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Logged on using Hashed/NTLMv1");
                }
            } else if (uniPwd.length > 0) {
                this.doNTLMv2Logon(sess, client);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Logged on using Hashed/NTLMv2");
                }
            }
        }
        if (client.isGuest()) {
            isGuest = true;
            if (logger.isDebugEnabled() && sess.hasDebug(32)) {
                logger.debug((Object)("User " + user + ", logged on as guest"));
            }
        }
        if ((uid = sess.addVirtualCircuit(vc = new VirtualCircuit(vcNum, (ClientInfo)client))) == -1) {
            if (logger.isDebugEnabled() && sess.hasDebug(32)) {
                logger.debug((Object)("Failed to allocate UID for virtual circuit, " + vc));
            }
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        if (logger.isDebugEnabled() && sess.hasDebug(32)) {
            logger.debug((Object)("Allocated UID=" + uid + " for VC=" + vc));
        }
        client.setGuest(isGuest);
        sess.setLoggedOn(true);
        reqPkt.setParameterCount(3);
        reqPkt.setParameter(0, 0);
        reqPkt.setParameter(1, 0);
        reqPkt.setParameter(2, isGuest ? 1 : 0);
        reqPkt.setByteCount(0);
        reqPkt.setTreeId(0);
        reqPkt.setUserId(uid);
        int flags = reqPkt.getFlags();
        reqPkt.setFlags(flags &= 0xFFFFFFF7);
        int flags2 = 1;
        if (isUni) {
            flags2 += 32768;
        }
        reqPkt.setFlags2(flags2);
        int pos = reqPkt.getByteOffset();
        buf = reqPkt.getBuffer();
        if (isUni) {
            pos = DataPacker.wordAlign((int)pos);
        }
        pos = DataPacker.putString((String)"Java", (byte[])buf, (int)pos, (boolean)true, (boolean)isUni);
        pos = DataPacker.putString((String)("Alfresco CIFS Server " + sess.getServer().isVersion()), (byte[])buf, (int)pos, (boolean)true, (boolean)isUni);
        pos = DataPacker.putString((String)this.getCIFSConfig().getDomainName(), (byte[])buf, (int)pos, (boolean)true, (boolean)isUni);
        reqPkt.setByteCount(pos - reqPkt.getByteOffset());
    }
}

