/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.avm;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import javax.transaction.UserTransaction;
import org.alfresco.filesys.alfresco.AlfrescoDiskDriver;
import org.alfresco.filesys.avm.AVMContext;
import org.alfresco.filesys.avm.AVMNetworkFile;
import org.alfresco.filesys.avm.AVMPath;
import org.alfresco.filesys.avm.AVMSearchContext;
import org.alfresco.filesys.avm.AVMSingleFileSearchContext;
import org.alfresco.filesys.avm.DummyFolderPseudoFile;
import org.alfresco.filesys.avm.PseudoFileListSearchContext;
import org.alfresco.filesys.avm.StorePseudoFile;
import org.alfresco.filesys.avm.StoreType;
import org.alfresco.filesys.avm.VersionPseudoFile;
import org.alfresco.filesys.avm.WebProjectStorePseudoFile;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.filesys.DirectoryNotEmptyException;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.FileExistsException;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.FileName;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.PathNotFoundException;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFile;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFileList;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFolderNetworkFile;
import org.alfresco.jlan.util.StringList;
import org.alfresco.jlan.util.WildCard;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.CreateStoreTxnListener;
import org.alfresco.repo.avm.CreateVersionTxnListener;
import org.alfresco.repo.avm.PurgeStoreTxnListener;
import org.alfresco.repo.avm.PurgeVersionTxnListener;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.avm.AVMBadArgumentException;
import org.alfresco.service.cmr.avm.AVMExistsException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avm.AVMWrongTypeException;
import org.alfresco.service.cmr.avm.VersionDescriptor;
import org.alfresco.service.cmr.avm.locking.AVMLockingException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMDiskDriver
extends AlfrescoDiskDriver
implements DiskInterface {
    private static final Log logger = LogFactory.getLog(AVMDiskDriver.class);
    private static final String KEY_STORE = "storePath";
    private static final String KEY_VERSION = "version";
    private static final String KEY_CREATE = "createStore";
    public static final char AVM_SEPERATOR = '/';
    public static final String AVM_SEPERATOR_STR = "/";
    public static final String RoleContentManager = "ContentManager";
    public static final String RoleWebProject = "WebProject";
    public static final String RoleNotWebAuthor = "NotWebAuthor";
    private static final String ROLE_CONTENT_MANAGER = "ContentManager";
    public static final int FileUnknown = -1;
    public static final int FileNotExist = 0;
    public static final int FileExists = 1;
    public static final int DirectoryExists = 2;
    public static final int CustomFileStatus = 3;
    private AVMService m_avmService;
    private MimetypeService m_mimetypeService;
    private AuthenticationComponent m_authComponent;
    private AuthenticationService m_authService;
    private NodeService m_nodeService;
    private CreateStoreTxnListener m_createStoreListener;
    private PurgeStoreTxnListener m_purgeStoreListener;
    private CreateVersionTxnListener m_createVerListener;
    private PurgeVersionTxnListener m_purgeVerListener;
    private String m_webProjectStore;

    public final AVMService getAvmService() {
        return this.m_avmService;
    }

    public final AuthenticationService getAuthenticationService() {
        return this.m_authService;
    }

    public void setAvmService(AVMService avmService) {
        this.m_avmService = avmService;
    }

    public void setAuthenticationComponent(AuthenticationComponent authComponent) {
        this.m_authComponent = authComponent;
    }

    public void setAuthenticationService(AuthenticationService authService) {
        this.m_authService = authService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.m_mimetypeService = mimetypeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.m_nodeService = nodeService;
    }

    public void setCreateStoreListener(CreateStoreTxnListener createStoreListener) {
        this.m_createStoreListener = createStoreListener;
    }

    public void setPurgeStoreListener(PurgeStoreTxnListener purgeStoreListener) {
        this.m_purgeStoreListener = purgeStoreListener;
    }

    public void setCreateVersionListener(CreateVersionTxnListener createVersionListener) {
        this.m_createVerListener = createVersionListener;
    }

    public void setPurgeVersionListener(PurgeVersionTxnListener purgeVersionListener) {
        this.m_purgeVerListener = purgeVersionListener;
    }

    public void setWebProjectStore(String webStore) {
        this.m_webProjectStore = webStore;
    }

    public DeviceContext createContext(String shareName, ConfigElement cfg) throws DeviceContextException {
        AVMContext context;
        block19: {
            context = null;
            try {
                ConfigElement virtElem = cfg.getChild("virtualView");
                if (virtElem != null) {
                    int showOptions = 12;
                    String showAttr = virtElem.getAttribute("stores");
                    if (showAttr != null) {
                        StringTokenizer tokens = new StringTokenizer(showAttr, ",");
                        StringList optList = new StringList();
                        while (tokens.hasMoreTokens()) {
                            optList.addString(tokens.nextToken().trim().toLowerCase());
                        }
                        showOptions = 0;
                        if (optList.containsString("normal")) {
                            ++showOptions;
                        }
                        if (optList.containsString("site")) {
                            showOptions += 2;
                        }
                        if (optList.containsString("author")) {
                            showOptions += 8;
                        }
                        if (optList.containsString("preview")) {
                            showOptions += 16;
                        }
                        if (optList.containsString("staging")) {
                            showOptions += 4;
                        }
                    } else if (cfg.getChild("showAllSandboxes") != null) {
                        showOptions = 31;
                    }
                    context = new AVMContext(shareName, showOptions, this);
                    if (cfg.getChild("adminWriteable") != null) {
                        context.setAllowAdminStagingWrites(true);
                    }
                    break block19;
                }
                ConfigElement storeElement = cfg.getChild(KEY_STORE);
                if (storeElement == null || storeElement.getValue() == null || storeElement.getValue().length() == 0) {
                    throw new DeviceContextException("Device missing init value: storePath");
                }
                String storePath = storeElement.getValue();
                int version = -1;
                ConfigElement versionElem = cfg.getChild(KEY_VERSION);
                if (versionElem != null) {
                    if (versionElem.getValue() == null || versionElem.getValue().length() == 0) {
                        throw new DeviceContextException("Store version not specified");
                    }
                    try {
                        version = Integer.parseInt(versionElem.getValue());
                    }
                    catch (NumberFormatException ex) {
                        throw new DeviceContextException("Invalid store version specified, " + versionElem.getValue());
                    }
                    if (version < 0 && version != -1) {
                        throw new DeviceContextException("Invalid store version id specified, " + version);
                    }
                }
                context = new AVMContext(shareName, storePath, version);
                ConfigElement createStore = cfg.getChild(KEY_CREATE);
                context.setCreateStore(createStore != null);
                context.enableStateCache(true);
            }
            catch (Exception ex) {
                logger.error((Object)"Error during create context", (Throwable)ex);
                throw new DeviceContextException("Driver setup error, " + ex.getMessage());
            }
        }
        this.registerContext((DeviceContext)context);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerContext(DeviceContext ctx) throws DeviceContextException {
        super.registerContext(ctx);
        AVMContext context = (AVMContext)ctx;
        try {
            AuthenticationUtil.pushAuthentication();
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
            UserTransaction tx = this.getTransactionService().getUserTransaction(false);
            try {
                if (tx != null) {
                    tx.begin();
                }
                if (context.isVirtualizationView()) {
                    context.enableStateCache(true);
                    this.m_createStoreListener.addCallback(context);
                    this.m_purgeStoreListener.addCallback(context);
                    this.m_createVerListener.addCallback(context);
                    this.m_purgeVerListener.addCallback(context);
                    this.findPseudoState(new AVMPath(""), context);
                } else {
                    String storePath = context.getStorePath();
                    int version = context.isVersion();
                    AVMNodeDescriptor rootNode = this.m_avmService.lookup(version, storePath);
                    if (rootNode == null) {
                        if (!context.getCreateStore() || version != -1) {
                            throw new DeviceContextException("Invalid store path/version, " + storePath + " (" + version + ")");
                        }
                        String storeName = null;
                        String path = null;
                        int pos = storePath.indexOf(":/");
                        if (pos != -1) {
                            storeName = storePath.substring(0, pos);
                            if (storePath.length() > pos) {
                                path = storePath.substring(pos + 2);
                            }
                        } else {
                            storeName = storePath;
                        }
                        AVMStoreDescriptor storeDesc = null;
                        try {
                            storeDesc = this.m_avmService.getStore(storeName);
                        }
                        catch (AVMNotFoundException ex) {
                            // empty catch block
                        }
                        if (storeDesc == null) {
                            this.m_avmService.createStore(storeName);
                        }
                        if (path != null) {
                            StringTokenizer tokens = new StringTokenizer(path, AVM_SEPERATOR_STR);
                            StringList paths = new StringList();
                            while (tokens.hasMoreTokens()) {
                                paths.addString(tokens.nextToken());
                            }
                            AVMPath curPath = new AVMPath(storeName, version, "\\");
                            AVMNodeDescriptor curDesc = this.m_avmService.lookup(curPath.getVersion(), curPath.getAVMPath());
                            for (int i = 0; i < paths.numberOfStrings(); ++i) {
                                AVMNodeDescriptor nextDesc = null;
                                try {
                                    nextDesc = this.m_avmService.lookup(curDesc, paths.getStringAt(i));
                                }
                                catch (AVMNotFoundException ex) {
                                    // empty catch block
                                }
                                if (nextDesc == null) {
                                    this.m_avmService.createDirectory(curPath.getAVMPath(), paths.getStringAt(i));
                                    nextDesc = this.m_avmService.lookup(curDesc, paths.getStringAt(i));
                                } else if (nextDesc.isFile()) {
                                    throw new DeviceContextException("Path element error, not a folder, " + paths.getStringAt(i));
                                }
                                curPath.parsePath(storeName, version, curPath.getRelativePath() + paths.getStringAt(i) + "\\");
                                curDesc = nextDesc;
                            }
                        }
                        if ((rootNode = this.m_avmService.lookup(version, storePath)) == null) {
                            throw new DeviceContextException("Failed to create new store " + storePath);
                        }
                    }
                    context.enableStateCache(true);
                }
                tx.commit();
                tx = null;
            }
            catch (Exception ex) {
                logger.error((Object)"Error during create context", (Throwable)ex);
                throw new DeviceContextException("Driver setup error, " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                if (tx != null) {
                    try {
                        tx.rollback();
                    }
                    catch (Exception ex) {
                        logger.warn((Object)"Failed to rollback transaction", (Throwable)ex);
                    }
                }
            }
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final StringList getAVMStoreNames() {
        String currentUser = this.m_authComponent.getCurrentUserName();
        try {
            this.m_authComponent.setCurrentUser(this.m_authComponent.getSystemUserName());
            UserTransaction tx = this.getTransactionService().getUserTransaction(false);
            StringList storeNames = new StringList();
            try {
                List<AVMStoreDescriptor> storeList;
                if (tx != null) {
                    tx.begin();
                }
                if ((storeList = this.m_avmService.getStores()) != null) {
                    for (AVMStoreDescriptor storeDesc : storeList) {
                        storeNames.addString(storeDesc.getName());
                    }
                }
                tx.commit();
                tx = null;
            }
            catch (Exception ex) {
                logger.error((Object)"Error getting store names", (Throwable)ex);
            }
            finally {
                if (tx != null) {
                    try {
                        tx.rollback();
                    }
                    catch (Exception ex) {
                        logger.warn((Object)"Failed to rollback transaction", (Throwable)ex);
                    }
                }
            }
            StringList stringList = storeNames;
            return stringList;
        }
        finally {
            this.m_authComponent.setCurrentUser(currentUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<QName, PropertyValue> getAVMStoreProperties(String storeName) {
        String currentUser = this.m_authComponent.getCurrentUserName();
        try {
            this.m_authComponent.setCurrentUser(this.m_authComponent.getSystemUserName());
            UserTransaction tx = this.getTransactionService().getUserTransaction(false);
            Map<QName, PropertyValue> properties = null;
            try {
                if (tx != null) {
                    tx.begin();
                }
                properties = this.m_avmService.getStoreProperties(storeName);
                tx.commit();
                tx = null;
            }
            catch (Exception ex) {
                logger.error((Object)"Error getting store properties", (Throwable)ex);
            }
            finally {
                if (tx != null) {
                    try {
                        tx.rollback();
                    }
                    catch (Exception ex) {
                        logger.warn((Object)"Failed to rollback transaction", (Throwable)ex);
                    }
                }
            }
            Map<QName, PropertyValue> map = properties;
            return map;
        }
        finally {
            this.m_authComponent.setCurrentUser(currentUser);
        }
    }

    protected final AVMPath buildStorePath(AVMContext ctx, String path, SrvSession sess) throws org.alfresco.jlan.server.filesys.AccessDeniedException {
        AVMPath avmPath = null;
        if (ctx.isVirtualizationView()) {
            avmPath = new AVMPath(path);
            this.checkPathAccess(avmPath, ctx, sess);
        } else {
            avmPath = new AVMPath(ctx.getStorePath(), ctx.isVersion(), path);
        }
        return avmPath;
    }

    public void closeFile(final SrvSession sess, final TreeConnection tree, final NetworkFile file) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Close file " + file.getFullName()));
        }
        this.doInWriteTransaction(sess, new AlfrescoDiskDriver.CallableIO<Void>(){

            @Override
            public Void call() throws IOException {
                file.closeFile();
                if (file.hasDeleteOnClose()) {
                    if (file.isDirectory()) {
                        AVMDiskDriver.this.deleteDirectory(sess, tree, file.getFullName());
                    } else {
                        AVMDiskDriver.this.deleteFile(sess, tree, file.getFullName());
                    }
                }
                return null;
            }
        });
    }

    public void createDirectory(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        AVMContext ctx = (AVMContext)tree.getContext();
        if (ctx.isVersion() != -1) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Cannot create " + params.getPath() + ", filesys not writable");
        }
        final String[] paths = FileName.splitPath((String)params.getPath());
        final AVMPath storePath = this.buildStorePath(ctx, paths[0], sess);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Create directory params=" + params + ", storePath=" + storePath + ", name=" + paths[1]));
        }
        if (ctx.isVirtualizationView()) {
            if (storePath.isReadOnlyPseudoPath()) {
                throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Cannot create folder in store/version layer, " + params.getPath());
            }
            if (storePath.isReadOnlyAccess()) {
                throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Cannot create folder " + params.getPath() + ", read-only path");
            }
        }
        try {
            this.doInWriteTransaction(sess, new AlfrescoDiskDriver.CallableIO<Void>(){

                @Override
                public Void call() throws IOException {
                    AVMDiskDriver.this.m_avmService.createDirectory(storePath.getAVMPath(), paths[1]);
                    return null;
                }
            });
        }
        catch (AVMExistsException ex) {
            throw new FileExistsException(params.getPath());
        }
        catch (AVMNotFoundException ex) {
            throw new FileNotFoundException(params.getPath());
        }
        catch (AVMWrongTypeException ex) {
            throw new FileNotFoundException(params.getPath());
        }
        catch (AVMBadArgumentException ex) {
            throw new FileNotFoundException(params.getPath());
        }
        catch (AVMLockingException ex) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException(params.getPath());
        }
        catch (AccessDeniedException ex) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException(params.getPath());
        }
    }

    public NetworkFile createFile(final SrvSession sess, TreeConnection tree, final FileOpenParams params) throws IOException {
        final AVMContext ctx = (AVMContext)tree.getContext();
        final String[] paths = FileName.splitPath((String)params.getPath());
        final AVMPath storePath = this.buildStorePath(ctx, paths[0], sess);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Create file params=" + params + ", storePath=" + storePath + ", name=" + paths[1]));
        }
        if (ctx.isVirtualizationView()) {
            if (storePath.isReadOnlyPseudoPath()) {
                throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Cannot create file in store/version layer, " + params.getPath());
            }
            if (storePath.isReadOnlyAccess()) {
                throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Cannot create file " + params.getPath() + ", read-only path");
            }
        } else if (storePath.getVersion() != -1) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Cannot create " + params.getPath() + ", filesys not writable");
        }
        try {
            return this.doInWriteTransaction(sess, new AlfrescoDiskDriver.CallableIO<NetworkFile>(){

                @Override
                public NetworkFile call() throws IOException {
                    AVMDiskDriver.this.m_avmService.createFile(storePath.getAVMPath(), paths[1]).close();
                    AVMPath fileStorePath = AVMDiskDriver.this.buildStorePath(ctx, params.getPath(), sess);
                    AVMNodeDescriptor nodeDesc = AVMDiskDriver.this.m_avmService.lookup(fileStorePath.getVersion(), fileStorePath.getAVMPath());
                    if (nodeDesc != null) {
                        AVMNetworkFile netFile = new AVMNetworkFile(nodeDesc, fileStorePath.getAVMPath(), fileStorePath.getVersion(), AVMDiskDriver.this.m_nodeService, AVMDiskDriver.this.m_avmService);
                        netFile.setGrantedAccess(2);
                        netFile.setFullName(params.getPath());
                        netFile.setFileId(fileStorePath.generateFileId());
                        netFile.setMimeType(AVMDiskDriver.this.m_mimetypeService.guessMimetype(paths[1]));
                        return netFile;
                    }
                    return null;
                }
            });
        }
        catch (AVMExistsException ex) {
            throw new FileExistsException(params.getPath());
        }
        catch (AVMNotFoundException ex) {
            throw new FileNotFoundException(params.getPath());
        }
        catch (AVMWrongTypeException ex) {
            throw new FileNotFoundException(params.getPath());
        }
        catch (AVMBadArgumentException ex) {
            throw new FileNotFoundException(params.getPath());
        }
        catch (AVMLockingException ex) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException(params.getPath());
        }
        catch (AccessDeniedException ex) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException(params.getPath());
        }
    }

    public void deleteDirectory(SrvSession sess, TreeConnection tree, final String dir) throws IOException {
        AVMContext ctx = (AVMContext)tree.getContext();
        String[] paths = FileName.splitPath((String)dir);
        AVMPath parentPath = this.buildStorePath(ctx, paths[0], sess);
        final AVMPath dirPath = this.buildStorePath(ctx, dir, sess);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Delete directory, path=" + dir + ", dirPath=" + dirPath));
        }
        if (ctx.isVirtualizationView()) {
            if (parentPath.isPseudoPath()) {
                throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Cannot delete folder in store/version layer, " + dir);
            }
            if (parentPath.isReadOnlyAccess()) {
                throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Cannot delete folder " + dir + ", read-only path");
            }
        }
        try {
            this.doInWriteTransaction(sess, new AlfrescoDiskDriver.CallableIO<Void>(){

                @Override
                public Void call() throws IOException {
                    AVMNodeDescriptor nodeDesc = AVMDiskDriver.this.m_avmService.lookup(dirPath.getVersion(), dirPath.getAVMPath());
                    if (nodeDesc != null) {
                        if (nodeDesc.isDirectory()) {
                            SortedMap<String, AVMNodeDescriptor> fileList = AVMDiskDriver.this.m_avmService.getDirectoryListing(nodeDesc);
                            if (fileList != null && fileList.size() > 0) {
                                throw new DirectoryNotEmptyException(dir);
                            }
                            AVMDiskDriver.this.m_avmService.removeNode(dirPath.getAVMPath());
                        } else {
                            throw new IOException("Delete directory path is not a directory, " + dir);
                        }
                    }
                    return null;
                }
            });
        }
        catch (AVMNotFoundException ex) {
            throw new IOException("Directory not found, " + dir);
        }
        catch (AVMWrongTypeException ex) {
            throw new IOException("Invalid path, " + dir);
        }
        catch (AccessDeniedException ex) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Access denied, " + dir);
        }
    }

    public void deleteFile(SrvSession sess, TreeConnection tree, final String name) throws IOException {
        AVMContext ctx = (AVMContext)tree.getContext();
        String[] paths = FileName.splitPath((String)name);
        AVMPath parentPath = this.buildStorePath(ctx, paths[0], sess);
        final AVMPath filePath = this.buildStorePath(ctx, name, sess);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Delete file, path=" + name + ", filePath=" + filePath));
        }
        if (ctx.isVirtualizationView()) {
            if (parentPath.isPseudoPath()) {
                throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Cannot delete file in store/version layer, " + name);
            }
            if (parentPath.isReadOnlyAccess()) {
                throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Cannot delete file " + name + ", read-only path");
            }
        }
        try {
            this.doInWriteTransaction(sess, new AlfrescoDiskDriver.CallableIO<Void>(){

                @Override
                public Void call() throws IOException {
                    AVMNodeDescriptor nodeDesc = AVMDiskDriver.this.m_avmService.lookup(filePath.getVersion(), filePath.getAVMPath());
                    if (nodeDesc != null) {
                        if (nodeDesc.isFile()) {
                            AVMDiskDriver.this.m_avmService.removeNode(filePath.getAVMPath());
                        } else {
                            throw new IOException("Delete file path is not a file, " + name);
                        }
                    }
                    return null;
                }
            });
        }
        catch (AVMNotFoundException ex) {
            throw new IOException("File not found, " + name);
        }
        catch (AVMWrongTypeException ex) {
            throw new IOException("Invalid path, " + name);
        }
        catch (AVMLockingException ex) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException("File locked, " + name);
        }
        catch (AccessDeniedException ex) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Access denied, " + name);
        }
    }

    public int fileExists(SrvSession sess, TreeConnection tree, String name) {
        AVMContext ctx = (AVMContext)tree.getContext();
        AVMPath storePath = null;
        try {
            storePath = this.buildStorePath(ctx, name, sess);
        }
        catch (org.alfresco.jlan.server.filesys.AccessDeniedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("File exists check, path=" + name + " Access denied"));
            }
            return 0;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("File exists check, path=" + name + ", storePath=" + storePath));
        }
        int status = 0;
        if (!storePath.isValid()) {
            return status;
        }
        if (ctx.isVirtualizationView() && storePath.isReadOnlyPseudoPath()) {
            FileState fstate = this.findPseudoState(storePath, ctx);
            if (fstate != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("  Found pseudo file " + fstate));
                }
                status = fstate.isDirectory() ? 2 : 1;
            } else {
                status = 0;
            }
            return status;
        }
        this.beginReadTransaction(sess);
        AVMNodeDescriptor nodeDesc = this.m_avmService.lookup(storePath.getVersion(), storePath.getAVMPath());
        if (nodeDesc != null) {
            status = nodeDesc.isDirectory() ? 2 : 1;
        }
        return status;
    }

    public void flushFile(SrvSession sess, TreeConnection tree, NetworkFile file) throws IOException {
        file.flushFile();
    }

    public FileInfo getFileInformation(SrvSession sess, TreeConnection tree, String name) throws IOException {
        AVMContext ctx = (AVMContext)tree.getContext();
        AVMPath storePath = null;
        try {
            storePath = this.buildStorePath(ctx, name, sess);
        }
        catch (Exception ex) {
            throw new FileNotFoundException(name);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Get file information, path=" + name + ", storePath=" + storePath));
        }
        if (!storePath.isValid()) {
            throw new FileNotFoundException(name);
        }
        if (ctx.isVirtualizationView() && storePath.isReadOnlyPseudoPath()) {
            if (storePath.isRootPath()) {
                return new FileInfo(name, 0L, 16);
            }
            PseudoFile psFile = this.findPseudoFolder(storePath, ctx);
            if (psFile != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("  Found pseudo file " + psFile));
                }
                return psFile.getFileInfo();
            }
            throw new FileNotFoundException(name);
        }
        this.beginReadTransaction(sess);
        FileInfo info = null;
        try {
            AVMNodeDescriptor nodeDesc = this.m_avmService.lookup(storePath.getVersion(), storePath.getAVMPath());
            if (nodeDesc != null) {
                info = new FileInfo();
                info.setFileName(nodeDesc.getName());
                if (nodeDesc.isFile()) {
                    info.setFileSize(nodeDesc.getLength());
                    info.setAllocationSize(nodeDesc.getLength() + 512L & 0xFFFFFFFFFFFFFE00L);
                } else {
                    info.setFileSize(0L);
                }
                info.setAccessDateTime(nodeDesc.getAccessDate());
                info.setCreationDateTime(nodeDesc.getCreateDate());
                info.setModifyDateTime(nodeDesc.getModDate());
                info.setChangeDateTime(nodeDesc.getModDate());
                int attr = 0;
                if (nodeDesc.isDirectory()) {
                    attr += 16;
                }
                if (nodeDesc.getName().startsWith(".") || nodeDesc.getName().equalsIgnoreCase("Desktop.ini") || nodeDesc.getName().equalsIgnoreCase("Thumbs.db")) {
                    attr += 2;
                }
                if (ctx.isVersion() != -1 || storePath.isReadOnlyAccess()) {
                    ++attr;
                }
                if (attr == 0) {
                    attr = 128;
                }
                info.setFileAttributes(attr);
                info.setFileId(storePath.generateFileId());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("  File info=" + info));
                }
            }
        }
        catch (AVMNotFoundException ex) {
            throw new FileNotFoundException(name);
        }
        catch (AVMWrongTypeException ex) {
            throw new PathNotFoundException(name);
        }
        return info;
    }

    public boolean isReadOnly(SrvSession sess, DeviceContext ctx) throws IOException {
        AVMContext avmCtx = (AVMContext)ctx;
        return avmCtx.isVersion() == -1;
    }

    public NetworkFile openFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        AVMContext ctx = (AVMContext)tree.getContext();
        AVMPath storePath = this.buildStorePath(ctx, params.getPath(), sess);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Open file params=" + params + ", storePath=" + storePath));
        }
        if (ctx.isVirtualizationView() && storePath.isReadOnlyPseudoPath()) {
            if (storePath.isRootPath()) {
                return new PseudoFolderNetworkFile("\\");
            }
            PseudoFile psFile = this.findPseudoFolder(storePath, ctx);
            if (psFile != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("  Found pseudo file " + psFile));
                }
                return psFile.getFile(params.getPath());
            }
            return null;
        }
        this.beginReadTransaction(sess);
        AVMNetworkFile netFile = null;
        try {
            AVMNodeDescriptor nodeDesc = this.m_avmService.lookup(storePath.getVersion(), storePath.getAVMPath());
            if (nodeDesc != null) {
                if (storePath.getVersion() != -1 && (params.isReadWriteAccess() || params.isWriteOnlyAccess())) {
                    throw new org.alfresco.jlan.server.filesys.AccessDeniedException("File " + params.getPath() + " is read-only");
                }
                netFile = new AVMNetworkFile(nodeDesc, storePath.getAVMPath(), storePath.getVersion(), this.m_nodeService, this.m_avmService);
                if (params.isReadOnlyAccess() || storePath.getVersion() != -1) {
                    netFile.setGrantedAccess(0);
                } else {
                    netFile.setGrantedAccess(2);
                }
            } else {
                throw new FileNotFoundException(params.getPath());
            }
            netFile.setFullName(params.getPath());
            netFile.setFileId(storePath.generateFileId());
            netFile.setMimeType(this.m_mimetypeService.guessMimetype(params.getPath()));
        }
        catch (AVMNotFoundException ex) {
            throw new FileNotFoundException(params.getPath());
        }
        catch (AVMWrongTypeException ex) {
            throw new FileNotFoundException(params.getPath());
        }
        catch (AccessDeniedException ex) {
            throw new FileNotFoundException(params.getPath());
        }
        return netFile;
    }

    public int readFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buf, int bufPos, int siz, long filePos) throws IOException {
        int rdlen;
        if (file.isDirectory()) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException();
        }
        AVMNetworkFile avmFile = (AVMNetworkFile)file;
        if (!avmFile.hasContentChannel()) {
            this.beginReadTransaction(sess);
        }
        if ((rdlen = file.readFile(buf, siz, bufPos, filePos)) == -1) {
            rdlen = 0;
        }
        return rdlen;
    }

    public void renameFile(SrvSession sess, TreeConnection tree, String oldName, String newName) throws IOException {
        AVMContext ctx = (AVMContext)tree.getContext();
        final String[] oldPaths = FileName.splitPath((String)oldName);
        final String[] newPaths = FileName.splitPath((String)newName);
        final AVMPath oldAVMPath = this.buildStorePath(ctx, oldPaths[0], sess);
        final AVMPath newAVMPath = this.buildStorePath(ctx, newPaths[0], sess);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rename from path=" + oldPaths[0] + ", name=" + oldPaths[1]));
            logger.debug((Object)("        new path=" + newPaths[0] + ", name=" + newPaths[1]));
        }
        if (ctx.isVirtualizationView()) {
            if (oldAVMPath.isReadOnlyPseudoPath()) {
                throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Cannot rename folder in store/version layer, " + oldName);
            }
            if (newAVMPath.isReadOnlyPseudoPath()) {
                throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Cannot rename folder to store/version layer, " + newName);
            }
            if (oldAVMPath.isReadOnlyAccess()) {
                throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Cannot rename read-only folder, " + oldName);
            }
            if (newAVMPath.isReadOnlyAccess()) {
                throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Cannot rename folder to read-only folder, " + newName);
            }
        }
        try {
            this.doInWriteTransaction(sess, new AlfrescoDiskDriver.CallableIO<Void>(){

                @Override
                public Void call() throws IOException {
                    AVMDiskDriver.this.m_avmService.rename(oldAVMPath.getAVMPath(), oldPaths[1], newAVMPath.getAVMPath(), newPaths[1]);
                    return null;
                }
            });
        }
        catch (AVMNotFoundException ex) {
            throw new IOException("Source not found, " + oldName);
        }
        catch (AVMWrongTypeException ex) {
            throw new IOException("Invalid path, " + oldName);
        }
        catch (AVMExistsException ex) {
            throw new FileExistsException("Destination exists, " + newName);
        }
        catch (AccessDeniedException ex) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Access denied, " + oldName);
        }
    }

    public long seekFile(SrvSession sess, TreeConnection tree, NetworkFile file, long pos, int typ) throws IOException {
        if (file.isDirectory()) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException();
        }
        AVMNetworkFile avmFile = (AVMNetworkFile)file;
        if (!avmFile.hasContentChannel()) {
            this.beginReadTransaction(sess);
        }
        return file.seekFile(pos, typ);
    }

    public void setFileInformation(SrvSession sess, TreeConnection tree, String name, FileInfo info) throws IOException {
        if (info.hasSetFlag(1024) && info.hasDeleteOnClose()) {
            AVMContext avmCtx = (AVMContext)tree.getContext();
            AVMPath storePath = this.buildStorePath(avmCtx, name, sess);
            if (avmCtx.isVersion() != -1 || storePath.isReadOnlyAccess()) {
                throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Store not writable, cannot set delete on close");
            }
        }
    }

    public SearchContext startSearch(SrvSession sess, TreeConnection tree, String searchPath, int attrib) throws FileNotFoundException {
        AVMContext avmCtx = (AVMContext)tree.getContext();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Start search path=" + searchPath));
        }
        String[] paths = FileName.splitPath((String)searchPath);
        AVMPath storePath = null;
        try {
            storePath = this.buildStorePath(avmCtx, paths[0], sess);
        }
        catch (org.alfresco.jlan.server.filesys.AccessDeniedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Start search access denied");
            }
            throw new FileNotFoundException("Access denied");
        }
        if (avmCtx.isVirtualizationView()) {
            if (storePath.isReadOnlyPseudoPath()) {
                FileState fstate = this.findPseudoState(storePath, avmCtx);
                if (fstate != null) {
                    PseudoFileList searchList = null;
                    searchList = storePath.isLevel() == AVMPath.LevelId.Root ? this.filterPseudoFolders(avmCtx, sess, storePath, fstate) : fstate.getPseudoFileList();
                    if (searchList == null) {
                        searchList = new PseudoFileList();
                    }
                    if (WildCard.containsWildcards((String)searchPath)) {
                        WildCard wildCardFilter = new WildCard(paths[1], false);
                        return new PseudoFileListSearchContext(searchList, attrib, wildCardFilter, storePath.isReadOnlyAccess());
                    }
                    PseudoFile pseudoFile = searchList.findFile(paths[1], false);
                    if (pseudoFile != null) {
                        PseudoFileList singleList = new PseudoFileList();
                        singleList.addFile(pseudoFile);
                        return new PseudoFileListSearchContext(singleList, attrib, null, storePath.isReadOnlyAccess());
                    }
                }
                throw new FileNotFoundException(searchPath);
            }
            if (storePath.isLevel() == AVMPath.LevelId.HeadMetaData || storePath.isLevel() == AVMPath.LevelId.VersionMetaData) {
                PseudoFileList metaFiles = new PseudoFileList();
                return new PseudoFileListSearchContext(metaFiles, attrib, null, storePath.isReadOnlyAccess());
            }
        }
        this.beginReadTransaction(sess);
        SearchContext context = null;
        if (WildCard.containsWildcards((String)searchPath)) {
            AVMNodeDescriptor[] fileList = this.m_avmService.getDirectoryListingArray(storePath.getVersion(), storePath.getAVMPath(), false);
            if (fileList != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("  Wildcard search returned " + fileList.length + " files"));
                }
                WildCard wildCardFilter = new WildCard(paths[1], false);
                context = new AVMSearchContext(fileList, attrib, wildCardFilter, storePath.getRelativePath(), storePath.isReadOnlyAccess());
            }
        } else {
            try {
                storePath = this.buildStorePath(avmCtx, searchPath, sess);
            }
            catch (org.alfresco.jlan.server.filesys.AccessDeniedException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Start search access denied");
                }
                throw new FileNotFoundException("Access denied");
            }
            AVMNodeDescriptor nodeDesc = this.m_avmService.lookup(storePath.getVersion(), storePath.getAVMPath());
            if (nodeDesc != null) {
                context = new AVMSingleFileSearchContext(nodeDesc, storePath.getRelativePath(), storePath.isReadOnlyAccess());
            }
        }
        return context;
    }

    public void truncateFile(SrvSession sess, TreeConnection tree, final NetworkFile file, final long siz) throws IOException {
        if (file.getGrantedAccess() == 0) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException();
        }
        AVMNetworkFile avmFile = (AVMNetworkFile)file;
        if (!avmFile.hasContentChannel() || !avmFile.isWritable()) {
            this.doInWriteTransaction(sess, new AlfrescoDiskDriver.CallableIO<Void>(){

                @Override
                public Void call() throws IOException {
                    file.truncateFile(siz);
                    file.flushFile();
                    return null;
                }
            });
        } else {
            file.truncateFile(siz);
            file.flushFile();
        }
    }

    public int writeFile(SrvSession sess, TreeConnection tree, final NetworkFile file, final byte[] buf, final int bufoff, final int siz, final long fileoff) throws IOException {
        if (file.isDirectory() || file.getGrantedAccess() == 0) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException();
        }
        AVMNetworkFile avmFile = (AVMNetworkFile)file;
        if (!avmFile.hasContentChannel() || !avmFile.isWritable()) {
            this.doInWriteTransaction(sess, new AlfrescoDiskDriver.CallableIO<Void>(){

                @Override
                public Void call() throws IOException {
                    file.writeFile(buf, siz, bufoff, fileoff);
                    return null;
                }
            });
        } else {
            file.writeFile(buf, siz, bufoff, fileoff);
        }
        return siz;
    }

    public void treeClosed(SrvSession sess, TreeConnection tree) {
    }

    public void treeOpened(SrvSession sess, TreeConnection tree) {
    }

    private final PseudoFile findPseudoFolder(AVMPath avmPath, AVMContext avmCtx) {
        return this.findPseudoFolder(avmPath, avmCtx, true);
    }

    private final PseudoFile findPseudoFolder(AVMPath avmPath, AVMContext avmCtx, boolean generateStates) {
        if (avmPath.isRootPath()) {
            return null;
        }
        FileState fstate = null;
        StringBuilder str = null;
        PseudoFile psFile = null;
        switch (avmPath.isLevel()) {
            case StoreRoot: {
                fstate = avmCtx.getStateCache().findFileState("\\");
                if (fstate == null || !fstate.hasPseudoFiles()) break;
                psFile = fstate.getPseudoFileList().findFile(avmPath.getStoreName(), false);
                break;
            }
            case VersionRoot: 
            case Head: {
                str = new StringBuilder();
                str.append('\\');
                str.append(avmPath.getStoreName());
                AVMPath storePath = new AVMPath(str.toString());
                fstate = this.findPseudoState(storePath, avmCtx);
                if (fstate == null) break;
                if (avmPath.isLevel() == AVMPath.LevelId.Head) {
                    psFile = fstate.getPseudoFileList().findFile("HEAD", true);
                    break;
                }
                psFile = fstate.getPseudoFileList().findFile("VERSION", true);
                break;
            }
            case Version: {
                str = new StringBuilder();
                str.append('\\');
                str.append(avmPath.getStoreName());
                str.append('\\');
                str.append("VERSION");
                AVMPath verrootPath = new AVMPath(str.toString());
                fstate = this.findPseudoState(verrootPath, avmCtx);
                if (fstate == null) break;
                str.setLength(0);
                str.append("v");
                str.append(avmPath.getVersion());
                psFile = fstate.getPseudoFileList().findFile(str.toString(), true);
                break;
            }
            case HeadData: 
            case HeadMetaData: {
                str = new StringBuilder();
                str.append('\\');
                str.append(avmPath.getStoreName());
                str.append('\\');
                str.append("HEAD");
                AVMPath headPath = new AVMPath(str.toString());
                fstate = this.findPseudoState(headPath, avmCtx);
                if (fstate == null) break;
                if (avmPath.isLevel() == AVMPath.LevelId.HeadData) {
                    psFile = fstate.getPseudoFileList().findFile("DATA", true);
                    break;
                }
                psFile = fstate.getPseudoFileList().findFile("METADATA", true);
                break;
            }
            case VersionData: 
            case VersionMetaData: {
                str = new StringBuilder();
                str.append('\\');
                str.append(avmPath.getStoreName());
                str.append('\\');
                str.append("v");
                str.append(avmPath.getVersion());
                AVMPath verPath = new AVMPath(str.toString());
                fstate = this.findPseudoState(verPath, avmCtx);
                if (fstate == null) break;
                psFile = avmPath.isLevel() == AVMPath.LevelId.VersionData ? fstate.getPseudoFileList().findFile("DATA", true) : fstate.getPseudoFileList().findFile("METADATA", true);
            }
        }
        if (psFile == null && generateStates) {
            this.generatePseudoFolders(avmPath, avmCtx);
            psFile = this.findPseudoFolder(avmPath, avmCtx, false);
        }
        return psFile;
    }

    protected final FileState findPseudoState(AVMPath avmPath, AVMContext avmCtx) {
        if (!avmPath.isPseudoPath()) {
            return null;
        }
        if (avmCtx.hasNewStoresQueued()) {
            StringList storeNames = avmCtx.getNewStoresQueue();
            while (storeNames.numberOfStrings() > 0) {
                String curStoreName = storeNames.removeStringAt(0);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding new store " + curStoreName));
                }
                this.addNewStore(avmCtx, curStoreName);
            }
        }
        FileState fstate = null;
        StringBuilder str = null;
        String relPath = null;
        switch (avmPath.isLevel()) {
            case Root: {
                PseudoFileList folderList;
                fstate = avmCtx.getStateCache().findFileState("\\");
                if (fstate != null) break;
                fstate = avmCtx.getStateCache().findFileState("\\", true);
                fstate.setExpiryTime(-1L);
                fstate.setFileStatus(2);
                List<AVMStoreDescriptor> storeList = this.m_avmService.getStores();
                if (storeList != null && storeList.size() > 0) {
                    for (AVMStoreDescriptor storeDesc : storeList) {
                        String storeName = storeDesc.getName();
                        Map<QName, PropertyValue> props = this.m_avmService.getStoreProperties(storeName);
                        if (props.containsKey(SandboxConstants.PROP_SANDBOX_STAGING_MAIN)) {
                            PropertyValue prop = props.get(SandboxConstants.PROP_WEB_PROJECT_NODE_REF);
                            if (prop == null) continue;
                            NodeRef webNodeRef = new NodeRef(prop.getStringValue());
                            if (this.m_nodeService.exists(webNodeRef)) {
                                WebProjectStorePseudoFile webProjFolder = new WebProjectStorePseudoFile(storeDesc, "\\" + storeName, webNodeRef);
                                fstate.addPseudoFile((PseudoFile)webProjFolder);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Found web project " + webProjFolder.getFileName()));
                                }
                                List mgrAssocs = this.m_nodeService.getChildAssocs(webNodeRef, (QNamePattern)WCMAppModel.ASSOC_WEBUSER, RegexQNamePattern.MATCH_ALL);
                                for (ChildAssociationRef mgrRef : mgrAssocs) {
                                    NodeRef childRef = mgrRef.getChildRef();
                                    if (!this.m_nodeService.getProperty(childRef, WCMAppModel.PROP_WEBUSERROLE).equals("ContentManager")) continue;
                                    String userName = (String)((Object)this.m_nodeService.getProperty(childRef, WCMAppModel.PROP_WEBUSERNAME));
                                    webProjFolder.addUserRole(userName, 2);
                                    if (!logger.isDebugEnabled()) continue;
                                    logger.debug((Object)("  Added content manager " + userName));
                                }
                                continue;
                            }
                            logger.warn((Object)("AVM Store '" + storeName + "' with webProjectNodeRef that does not exist: " + webNodeRef));
                            continue;
                        }
                        int storeType = 0;
                        String webProjName = null;
                        String userName = null;
                        if (props.containsKey(SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN)) {
                            storeType = 2;
                            webProjName = props.get(SandboxConstants.PROP_WEBSITE_NAME).getStringValue();
                            userName = storeName.substring(webProjName.length() + 2);
                        } else if (props.containsKey(SandboxConstants.PROP_SANDBOX_AUTHOR_PREVIEW)) {
                            storeType = 3;
                            String projPlusUser = storeName.substring(0, storeName.length() - "--preview".length());
                            int pos = projPlusUser.lastIndexOf("--");
                            if (pos != -1) {
                                webProjName = projPlusUser.substring(0, pos);
                                userName = projPlusUser.substring(pos + 2);
                            }
                        } else if (props.containsKey(SandboxConstants.PROP_SANDBOX_WORKFLOW_PREVIEW)) {
                            storeType = 4;
                        } else if (props.containsKey(SandboxConstants.PROP_SANDBOX_STAGING_PREVIEW)) {
                            storeType = 4;
                            webProjName = storeName.substring(0, storeName.length() - "--preview".length());
                        } else if (props.containsKey(QName.createQName(null, (String)".sitestore"))) {
                            storeType = 1;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Store " + storeDesc.getName() + ", type=" + StoreType.asString(storeType) + ", webproj=" + webProjName + ", username=" + userName));
                        }
                        if (!avmCtx.showStoreType(storeType)) continue;
                        StorePseudoFile storeFolder = new StorePseudoFile(storeDesc, "\\" + storeName, storeType);
                        if (storeType == 2 || storeType == 3 || storeType == 5 || storeType == 4) {
                            storeFolder.setWebProject(webProjName);
                            storeFolder.setUserName(userName);
                        }
                        fstate.addPseudoFile((PseudoFile)storeFolder);
                    }
                }
                if ((folderList = fstate.getPseudoFileList()) == null || folderList.numberOfFiles() <= 0) break;
                for (int i = 0; i < folderList.numberOfFiles(); ++i) {
                    StorePseudoFile curFile;
                    if (!(folderList.getFileAt(i) instanceof StorePseudoFile) || !(curFile = (StorePseudoFile)folderList.getFileAt(i)).hasWebProject()) continue;
                    WebProjectStorePseudoFile webProj = (WebProjectStorePseudoFile)folderList.findFile(curFile.getWebProject(), true);
                    if (webProj == null) {
                        logger.warn((Object)("Missing web project for: " + curFile.getFileName() + " (" + curFile.getWebProject() + ")"));
                        continue;
                    }
                    String userName = curFile.getFileName().substring(webProj.getFileName().length() + 2);
                    if (webProj.getUserRole(userName) != 0) continue;
                    webProj.addUserRole(userName, 1);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Added publisher " + userName + " to " + webProj.getFileName()));
                }
                break;
            }
            case StoreRoot: {
                str = new StringBuilder();
                str.append('\\');
                str.append(avmPath.getStoreName());
                relPath = str.toString();
                fstate = avmCtx.getStateCache().findFileState(relPath);
                if (fstate != null) break;
                fstate = avmCtx.getStateCache().findFileState(str.toString(), true);
                fstate.setFileStatus(2);
                str.append('\\');
                str.append("HEAD");
                fstate.addPseudoFile((PseudoFile)new VersionPseudoFile("HEAD", str.toString()));
                str.setLength(relPath.length() + 1);
                str.append("VERSION");
                fstate.addPseudoFile((PseudoFile)new DummyFolderPseudoFile("VERSION", str.toString()));
                break;
            }
            case Head: {
                str = new StringBuilder();
                str.append('\\');
                str.append(avmPath.getStoreName());
                str.append('\\');
                str.append("HEAD");
                relPath = str.toString();
                fstate = avmCtx.getStateCache().findFileState(relPath);
                if (fstate != null) break;
                fstate = avmCtx.getStateCache().findFileState(str.toString(), true);
                fstate.setFileStatus(2);
                str.append('\\');
                str.append("DATA");
                fstate.addPseudoFile((PseudoFile)new DummyFolderPseudoFile("DATA", str.toString()));
                str.setLength(relPath.length() + 1);
                str.append("METADATA");
                fstate.addPseudoFile((PseudoFile)new DummyFolderPseudoFile("METADATA", str.toString()));
                break;
            }
            case VersionRoot: {
                try {
                    str = new StringBuilder();
                    str.append('\\');
                    str.append(avmPath.getStoreName());
                    str.append('\\');
                    str.append("VERSION");
                    relPath = str.toString();
                    fstate = avmCtx.getStateCache().findFileState(relPath, true);
                    fstate.setFileStatus(2);
                    if (fstate.hasPseudoFiles()) break;
                    StringBuilder verStr = new StringBuilder("v");
                    verStr.append("-1");
                    str.append('\\');
                    str.append(verStr.toString());
                    fstate.addPseudoFile((PseudoFile)new VersionPseudoFile(verStr.toString(), str.toString()));
                    List<VersionDescriptor> verList = this.m_avmService.getStoreVersions(avmPath.getStoreName());
                    if (verList.size() <= 0) break;
                    for (VersionDescriptor verDesc : verList) {
                        String verName = null;
                        verStr.setLength("v".length());
                        verStr.append(verDesc.getVersionID());
                        verName = verStr.toString();
                        str.setLength(relPath.length() + 1);
                        str.append(verName);
                        fstate.addPseudoFile((PseudoFile)new VersionPseudoFile(verName, verDesc, str.toString()));
                    }
                    break;
                }
                catch (AVMNotFoundException ex) {
                    break;
                }
            }
            case Version: {
                str = new StringBuilder();
                str.append('\\');
                str.append(avmPath.getStoreName());
                str.append('\\');
                str.append("v");
                str.append(avmPath.getVersion());
                relPath = str.toString();
                fstate = avmCtx.getStateCache().findFileState(relPath);
                if (fstate != null) break;
                fstate = avmCtx.getStateCache().findFileState(str.toString(), true);
                fstate.setFileStatus(2);
                str.append('\\');
                str.append("DATA");
                fstate.addPseudoFile((PseudoFile)new DummyFolderPseudoFile("DATA", str.toString()));
                str.setLength(relPath.length() + 1);
                str.append("METADATA");
                fstate.addPseudoFile((PseudoFile)new DummyFolderPseudoFile("METADATA", str.toString()));
            }
        }
        return fstate;
    }

    private final void generatePseudoFolders(AVMPath avmPath, AVMContext avmCtx) {
        AVMPath createPath = new AVMPath();
        StringBuilder pathStr = new StringBuilder();
        pathStr.append('\\');
        createPath.parsePath(pathStr.toString());
        FileState rootState = this.findPseudoState(createPath, avmCtx);
        if (avmPath.getStoreName() != null && rootState.hasPseudoFiles() && rootState.getPseudoFileList().findFile(avmPath.getStoreName(), false) != null) {
            pathStr.append(avmPath.getStoreName());
            pathStr.append('\\');
            createPath.parsePath(pathStr.toString());
            this.findPseudoState(createPath, avmCtx);
            createPath.parsePath(pathStr.toString() + "HEAD");
            this.findPseudoState(createPath, avmCtx);
            createPath.parsePath(pathStr.toString() + "VERSION");
            this.findPseudoState(createPath, avmCtx);
            if (avmPath.isLevel().ordinal() >= AVMPath.LevelId.Version.ordinal()) {
                pathStr.append("VERSION");
                pathStr.append('\\');
                pathStr.append("v");
                pathStr.append(avmPath.getVersion());
                createPath.parsePath(pathStr.toString());
                this.findPseudoState(createPath, avmCtx);
            }
        }
    }

    private final void checkPathAccess(AVMPath avmPath, AVMContext avmCtx, SrvSession sess) throws org.alfresco.jlan.server.filesys.AccessDeniedException {
        if (!avmCtx.isVirtualizationView()) {
            return;
        }
        ClientInfo cInfo = sess.getClientInformation();
        if (cInfo == null || cInfo.getUserName() == null || cInfo.getUserName().length() == 0) {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException();
        }
        if (avmPath.isLevel() == AVMPath.LevelId.Root || avmPath.isLevel() == AVMPath.LevelId.HeadData || avmPath.isLevel() == AVMPath.LevelId.StoreRootPath) {
            avmPath.setReadOnlyAccess(true);
            return;
        }
        FileState rootState = avmCtx.getStateCache().findFileState("\\");
        if (rootState == null) {
            rootState = this.findPseudoState(new AVMPath("\\"), avmCtx);
        }
        if (rootState != null && rootState.hasPseudoFiles()) {
            PseudoFile pseudoFolder = rootState.getPseudoFileList().findFile(avmPath.getStoreName(), false);
            if (pseudoFolder != null) {
                String curUserName = this.m_authComponent.getCurrentUserName();
                if (pseudoFolder instanceof WebProjectStorePseudoFile) {
                    WebProjectStorePseudoFile webFolder = (WebProjectStorePseudoFile)pseudoFolder;
                    int role = webFolder.getUserRole(curUserName);
                    if (role == 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("User " + curUserName + " has no access to web project, " + webFolder.getFileName()));
                        }
                        throw new org.alfresco.jlan.server.filesys.AccessDeniedException("User " + curUserName + " has no access to web project, " + webFolder.getFileName());
                    }
                    if (avmCtx.allowAdminStagingWrites() && cInfo.isAdministrator()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("User " + curUserName + " granted write access to web project, " + webFolder.getFileName()));
                        }
                        avmPath.setReadOnlyAccess(false);
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("User " + curUserName + " granted read-only access to web project, " + webFolder.getFileName()));
                        }
                        avmPath.setReadOnlyAccess(true);
                    }
                } else if (pseudoFolder instanceof StorePseudoFile) {
                    StorePseudoFile storeFolder = (StorePseudoFile)pseudoFolder;
                    if (storeFolder.isStoreType() == 0) {
                        return;
                    }
                    if (storeFolder.hasWebProject()) {
                        WebProjectStorePseudoFile webFolder = (WebProjectStorePseudoFile)rootState.getPseudoFileList().findFile(storeFolder.getWebProject(), false);
                        int role = webFolder.getUserRole(curUserName);
                        if (role == 0) {
                            throw new org.alfresco.jlan.server.filesys.AccessDeniedException("User " + curUserName + " has no access to web project, " + webFolder.getFileName() + AVM_SEPERATOR_STR + storeFolder.getFileName());
                        }
                        if (role == 1 && !storeFolder.getUserName().equalsIgnoreCase(curUserName)) {
                            throw new org.alfresco.jlan.server.filesys.AccessDeniedException("User " + curUserName + " has no access to web project, " + webFolder.getFileName() + AVM_SEPERATOR_STR + storeFolder.getFileName());
                        }
                    }
                }
            }
        } else {
            throw new org.alfresco.jlan.server.filesys.AccessDeniedException("Store does not exist, " + avmPath.getStoreName());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Check access " + avmPath));
        }
    }

    private final PseudoFileList filterPseudoFolders(AVMContext avmCtx, SrvSession sess, AVMPath avmPath, FileState fstate) {
        if (!fstate.hasPseudoFiles()) {
            return null;
        }
        ClientInfo cInfo = sess.getClientInformation();
        if (cInfo == null || cInfo.getUserName() == null || cInfo.getUserName().length() == 0) {
            return null;
        }
        PseudoFileList fullList = fstate.getPseudoFileList();
        if (cInfo.isAdministrator()) {
            return fullList;
        }
        PseudoFileList filterList = new PseudoFileList();
        String userName = this.m_authComponent.getCurrentUserName();
        for (int i = 0; i < fullList.numberOfFiles(); ++i) {
            StorePseudoFile storeFolder;
            PseudoFile pseudoFolder = fullList.getFileAt(i);
            if (pseudoFolder instanceof WebProjectStorePseudoFile) {
                WebProjectStorePseudoFile webFolder = (WebProjectStorePseudoFile)pseudoFolder;
                if (!avmCtx.showStagingStores() || webFolder.getUserRole(userName) == 0) continue;
                filterList.addFile(pseudoFolder);
                continue;
            }
            if (!(pseudoFolder instanceof StorePseudoFile) || !avmCtx.showStoreType((storeFolder = (StorePseudoFile)pseudoFolder).isStoreType())) continue;
            if (storeFolder.hasWebProject()) {
                WebProjectStorePseudoFile webFolder = (WebProjectStorePseudoFile)fullList.findFile(storeFolder.getWebProject(), false);
                if (webFolder != null) {
                    int role = webFolder.getUserRole(userName);
                    if (role == 2 && avmCtx.showStoreType(storeFolder.isStoreType())) {
                        filterList.addFile((PseudoFile)storeFolder);
                        continue;
                    }
                    if (role != 1 || !avmCtx.showStoreType(storeFolder.isStoreType()) || !storeFolder.getUserName().equalsIgnoreCase(userName)) continue;
                    filterList.addFile((PseudoFile)storeFolder);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Cannot find associated web folder for store " + storeFolder.getFileName()));
                continue;
            }
            if (!avmCtx.showNormalStores() && !avmCtx.showSiteStores()) continue;
            filterList.addFile((PseudoFile)storeFolder);
        }
        return filterList;
    }

    protected void addNewStore(AVMContext avmCtx, String storeName) {
        FileState fstate = avmCtx.getStateCache().findFileState("\\", true);
        if (fstate == null) {
            return;
        }
        AVMStoreDescriptor storeDesc = this.m_avmService.getStore(storeName);
        if (storeDesc == null) {
            return;
        }
        Map<QName, PropertyValue> props = this.m_avmService.getStoreProperties(storeName);
        if (props.containsKey(SandboxConstants.PROP_SANDBOX_STAGING_MAIN)) {
            PropertyValue prop = props.get(SandboxConstants.PROP_WEB_PROJECT_NODE_REF);
            if (prop != null) {
                NodeRef webNodeRef = new NodeRef(prop.getStringValue());
                if (this.m_nodeService.exists(webNodeRef)) {
                    WebProjectStorePseudoFile webProjFolder = new WebProjectStorePseudoFile(storeDesc, "\\" + storeName, webNodeRef);
                    fstate.addPseudoFile((PseudoFile)webProjFolder);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(" Found web project " + webProjFolder.getFileName()));
                    }
                    List mgrAssocs = this.m_nodeService.getChildAssocs(webNodeRef, (QNamePattern)WCMAppModel.ASSOC_WEBUSER, RegexQNamePattern.MATCH_ALL);
                    for (ChildAssociationRef mgrRef : mgrAssocs) {
                        NodeRef childRef = mgrRef.getChildRef();
                        if (!this.m_nodeService.getProperty(childRef, WCMAppModel.PROP_WEBUSERROLE).equals("ContentManager")) continue;
                        String userName = (String)((Object)this.m_nodeService.getProperty(childRef, WCMAppModel.PROP_WEBUSERNAME));
                        webProjFolder.addUserRole(userName, 2);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("  Added content manager " + userName));
                    }
                } else {
                    logger.warn((Object)("AVM Store '" + storeName + "' with webProjectNodeRef that does not exist: " + webNodeRef));
                }
            }
        } else {
            int storeType = 0;
            String webProjName = null;
            String userName = null;
            if (props.containsKey(SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN)) {
                storeType = 2;
                webProjName = props.get(SandboxConstants.PROP_WEBSITE_NAME).getStringValue();
                userName = storeName.substring(webProjName.length() + 2);
            } else if (props.containsKey(SandboxConstants.PROP_SANDBOX_AUTHOR_PREVIEW)) {
                storeType = 3;
                String projPlusUser = storeName.substring(0, storeName.length() - "--preview".length());
                int pos = projPlusUser.lastIndexOf("--");
                if (pos != -1) {
                    webProjName = projPlusUser.substring(0, pos);
                    userName = projPlusUser.substring(pos + 2);
                }
            } else if (props.containsKey(SandboxConstants.PROP_SANDBOX_WORKFLOW_PREVIEW)) {
                storeType = 4;
            } else if (props.containsKey(SandboxConstants.PROP_SANDBOX_STAGING_PREVIEW)) {
                storeType = 4;
                webProjName = storeName.substring(0, storeName.length() - "--preview".length());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" Store " + storeDesc.getName() + ", type=" + StoreType.asString(storeType) + ", webproj=" + webProjName + ", username=" + userName));
            }
            if (avmCtx.showStoreType(storeType)) {
                StorePseudoFile storeFolder = new StorePseudoFile(storeDesc, "\\" + storeName, storeType);
                if (storeType != 0) {
                    WebProjectStorePseudoFile webProj;
                    PseudoFileList folderList;
                    storeFolder.setWebProject(webProjName);
                    storeFolder.setUserName(userName);
                    if (storeFolder.hasWebProject() && (folderList = fstate.getPseudoFileList()) != null && (webProj = (WebProjectStorePseudoFile)folderList.findFile(storeFolder.getWebProject(), true)) != null && webProj.getUserRole(userName = storeFolder.getFileName().substring(webProj.getFileName().length() + 2)) == 0) {
                        webProj.addUserRole(userName, 1);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(" Added publisher " + userName + " to " + webProj.getFileName()));
                        }
                    }
                }
                fstate.addPseudoFile((PseudoFile)storeFolder);
            }
        }
    }
}

