/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.action.ParameterizedItemImpl;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionStatus;
import org.alfresco.service.cmr.repository.NodeRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionImpl
extends ParameterizedItemImpl
implements Action {
    private static final long serialVersionUID = 3258135760426186548L;
    private NodeRef nodeRef;
    private String title;
    private String description;
    private boolean executeAsynchronously = false;
    private Action compensatingAction;
    private Date createdDate;
    private String creator;
    private Date modifiedDate;
    private String modifier;
    private String actionDefinitionName;
    private String runAsUserName;
    private Set<String> actionChain;
    private List<ActionCondition> actionConditions = new ArrayList<ActionCondition>();
    private int executionInstance = -1;
    private Date executionStartDate;
    private Date executionEndDate;
    private ActionStatus executionStatus = ActionStatus.New;
    private String executionFailureMessage;

    public ActionImpl(NodeRef nodeRef, String id, String actionDefinitionName) {
        this(nodeRef, id, actionDefinitionName, null);
    }

    public ActionImpl(NodeRef nodeRef, String id, String actionDefinitionName, Map<String, Serializable> parameterValues) {
        super(id, parameterValues);
        this.nodeRef = nodeRef;
        this.actionDefinitionName = actionDefinitionName;
    }

    public ActionImpl(Action action, String actionDefinitionName) {
        super(action.getId(), action.getParameterValues());
        this.actionDefinitionName = actionDefinitionName;
        this.actionConditions = action.getActionConditions();
        this.compensatingAction = action.getCompensatingAction();
        this.createdDate = action.getCreatedDate();
        this.creator = action.getCreator();
        this.description = action.getDescription();
        this.executeAsynchronously = action.getExecuteAsychronously();
        this.modifiedDate = action.getModifiedDate();
        this.modifier = action.getModifier();
        this.nodeRef = action.getNodeRef();
        this.title = action.getTitle();
        this.executionStartDate = action.getExecutionStartDate();
        this.executionEndDate = action.getExecutionEndDate();
        this.executionStatus = action.getExecutionStatus();
        this.executionFailureMessage = action.getExecutionFailureMessage();
        if (action instanceof ActionImpl) {
            ActionImpl actionImpl = (ActionImpl)action;
            this.executionInstance = actionImpl.getExecutionInstance();
            this.runAsUserName = actionImpl.getRunAsUser();
            this.actionChain = actionImpl.actionChain;
        }
    }

    public ActionImpl(Action action) {
        this(action, action.getActionDefinitionName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Action").append("[ id=").append(this.getId()).append(", node=").append(this.nodeRef).append(" ]");
        return sb.toString();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean getExecuteAsychronously() {
        return this.executeAsynchronously;
    }

    @Override
    public void setExecuteAsynchronously(boolean executeAsynchronously) {
        this.executeAsynchronously = executeAsynchronously;
    }

    @Override
    public Action getCompensatingAction() {
        return this.compensatingAction;
    }

    @Override
    public void setCompensatingAction(Action action) {
        this.compensatingAction = action;
    }

    @Override
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    @Override
    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    @Override
    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    @Override
    public String getActionDefinitionName() {
        return this.actionDefinitionName;
    }

    @Override
    public boolean hasActionConditions() {
        return !this.actionConditions.isEmpty();
    }

    @Override
    public int indexOfActionCondition(ActionCondition actionCondition) {
        return this.actionConditions.indexOf(actionCondition);
    }

    @Override
    public List<ActionCondition> getActionConditions() {
        return this.actionConditions;
    }

    @Override
    public ActionCondition getActionCondition(int index) {
        return this.actionConditions.get(index);
    }

    @Override
    public void addActionCondition(ActionCondition actionCondition) {
        this.actionConditions.add(actionCondition);
    }

    @Override
    public void addActionCondition(int index, ActionCondition actionCondition) {
        this.actionConditions.add(index, actionCondition);
    }

    @Override
    public void setActionCondition(int index, ActionCondition actionCondition) {
        this.actionConditions.set(index, actionCondition);
    }

    @Override
    public void removeActionCondition(ActionCondition actionCondition) {
        this.actionConditions.remove(actionCondition);
    }

    @Override
    public void removeAllActionConditions() {
        this.actionConditions.clear();
    }

    public void setActionChain(Set<String> actionChain) {
        this.actionChain = actionChain;
    }

    public Set<String> getActionChain() {
        return this.actionChain;
    }

    public String getRunAsUser() {
        return this.runAsUserName;
    }

    public void setRunAsUser(String runAsUserName) {
        this.runAsUserName = runAsUserName;
    }

    @Override
    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public void setNodeRef(NodeRef nodeRef) {
        this.nodeRef = nodeRef;
    }

    @Override
    public void addParameterValues(Map<String, Serializable> values) {
        this.getParameterValues().putAll(values);
    }

    public int getExecutionInstance() {
        return this.executionInstance;
    }

    public void setExecutionInstance(int instance) {
        this.executionInstance = instance;
    }

    @Override
    public Date getExecutionStartDate() {
        return this.executionStartDate;
    }

    public void setExecutionStartDate(Date startDate) {
        this.executionStartDate = startDate;
    }

    @Override
    public Date getExecutionEndDate() {
        return this.executionEndDate;
    }

    public void setExecutionEndDate(Date endDate) {
        this.executionEndDate = endDate;
    }

    @Override
    public ActionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public void setExecutionStatus(ActionStatus status) {
        this.executionStatus = status;
    }

    @Override
    public String getExecutionFailureMessage() {
        return this.executionFailureMessage;
    }

    public void setExecutionFailureMessage(String message) {
        this.executionFailureMessage = message;
    }
}

