/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.evaluator;

import java.io.Serializable;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.evaluator.ComparePropertyValueEvaluator;
import org.alfresco.repo.action.evaluator.compare.ComparePropertyValueOperation;
import org.alfresco.repo.action.evaluator.compare.ContentPropertyName;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionServiceException;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareMimeTypeEvaluator
extends ComparePropertyValueEvaluator {
    public static final String NAME = "compare-mime-type";
    private static final String ERRID_NOT_A_CONTENT_TYPE = "compare_mime_type_evaluator.not_a_content_type";
    private static final String ERRID_NO_PROPERTY_DEFINTION_FOUND = "compare_mime_type_evaluator.no_property_definition_found";

    @Override
    public boolean evaluateImpl(ActionCondition actionCondition, NodeRef actionedUponNodeRef) {
        QName propertyQName = (QName)actionCondition.getParameterValue("property");
        if (propertyQName == null) {
            actionCondition.setParameterValue("property", (Serializable)ContentModel.PROP_CONTENT);
        } else {
            QName propertyTypeQName = null;
            PropertyDefinition propertyDefintion = this.dictionaryService.getProperty(propertyQName);
            if (propertyDefintion != null) {
                propertyTypeQName = propertyDefintion.getDataType().getName();
                if (!DataTypeDefinition.CONTENT.equals((Object)propertyTypeQName)) {
                    throw new ActionServiceException(ERRID_NOT_A_CONTENT_TYPE);
                }
            } else {
                throw new ActionServiceException(ERRID_NO_PROPERTY_DEFINTION_FOUND);
            }
        }
        actionCondition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.EQUALS.toString()));
        actionCondition.setParameterValue("content-property", (Serializable)((Object)ContentPropertyName.MIME_TYPE.toString()));
        return super.evaluateImpl(actionCondition, actionedUponNodeRef);
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl("property", DataTypeDefinition.QNAME, false, this.getParamDisplayLabel("property")));
        paramList.add(new ParameterDefinitionImpl("value", DataTypeDefinition.ANY, true, this.getParamDisplayLabel("value"), false, "ac-mimetypes"));
    }
}

