/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.scheduled;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.repo.action.executer.ActionExecuter;
import org.alfresco.repo.action.scheduled.AbstractTemplateActionDefinition;
import org.alfresco.repo.action.scheduled.TemplateActionModelFactory;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTemplateActionDefinition
extends AbstractTemplateActionDefinition
implements ApplicationContextAware {
    private String actionName;
    private Map<String, String> parameterTemplates;
    private TemplateActionModelFactory templateActionModelFactory;
    private DictionaryService dictionaryService;
    private ApplicationContext applicationContext;

    public TemplateActionModelFactory getTemplateActionModelFactory() {
        return this.templateActionModelFactory;
    }

    public void setTemplateActionModelFactory(TemplateActionModelFactory templateActionModelFactory) {
        this.templateActionModelFactory = templateActionModelFactory;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setParameterTemplates(Map<String, String> parameterTemplates) {
        this.parameterTemplates = parameterTemplates;
    }

    public Map<String, String> getParameterTemplates() {
        return this.parameterTemplates;
    }

    @Override
    public Action getAction(NodeRef nodeRef) {
        ActionExecuter actionExecutor = (ActionExecuter)this.applicationContext.getBean(this.getActionName());
        ActionDefinition actionDefinition = actionExecutor.getActionDefinition();
        Action action = this.actionService.createAction(this.getActionName());
        for (String paramName : this.parameterTemplates.keySet()) {
            String template = this.parameterTemplates.get(paramName);
            String stringValue = this.templateService.processTemplateString(this.getTemplateActionModelFactory().getTemplateEngine(), template, this.getTemplateActionModelFactory().getModel(nodeRef));
            DataTypeDefinition dataTypeDef = actionDefinition.getParameterDefintion(paramName) != null ? this.dictionaryService.getDataType(actionDefinition.getParameterDefintion(paramName).getType()) : this.dictionaryService.getProperty(QName.createQName((String)paramName)).getDataType();
            Object value = DefaultTypeConverter.INSTANCE.convert(dataTypeDef, (Object)stringValue);
            if (!(value instanceof Serializable)) continue;
            action.setParameterValue(paramName, (Serializable)value);
        }
        if (this.getCompensatingTemplateCompositeActionDefinition() != null) {
            action.setCompensatingAction(this.getCompensatingTemplateCompositeActionDefinition().getAction(nodeRef));
        }
        return action;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

