/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.AVMStore;
import org.alfresco.repo.avm.BasicAttributes;
import org.alfresco.repo.avm.BasicAttributesImpl;
import org.alfresco.repo.avm.util.RawServices;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.domain.avm.AVMHistoryLinkEntity;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.security.permissions.ACLCopyMode;
import org.alfresco.service.cmr.avm.AVMReadOnlyException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AVMNodeImpl
implements AVMNode {
    private static Log logger = LogFactory.getLog(AVMNodeImpl.class);
    protected static final boolean DEBUG = logger.isDebugEnabled();
    private long fID;
    private int fVersionID;
    private BasicAttributes fBasicAttributes;
    private long fVers;
    private boolean fIsRoot;
    private Acl fACL;
    private AVMStore fStoreNew;
    private String fGUID;
    private Set<QName> fAspects;
    private Map<QName, PropertyValue> fProperties;

    protected AVMNodeImpl() {
    }

    protected AVMNodeImpl(AVMStore store) {
        this();
        this.setVersionID(-1);
        this.setIsRoot(false);
        long time = System.currentTimeMillis();
        String user = RawServices.Instance().getAuthenticationContext().getCurrentUserName();
        if (user == null) {
            user = RawServices.Instance().getAuthenticationContext().getSystemUserName();
        }
        this.setBasicAttributes(new BasicAttributesImpl(user, user, user, time, time, time));
        this.setStoreNew(store);
        this.setGuid(GUID.generate());
    }

    @Override
    public void setAncestor(AVMNode ancestor) {
        if (ancestor == null) {
            return;
        }
        AVMDAOs.Instance().newAVMNodeLinksDAO.createHistoryLink(ancestor.getId(), this.getId());
    }

    @Override
    public void changeAncestor(AVMNode ancestor) {
        AVMHistoryLinkEntity hlEntity = AVMDAOs.Instance().newAVMNodeLinksDAO.getHistoryLinkByDescendent(this.getId());
        if (hlEntity != null) {
            AVMDAOs.Instance().newAVMNodeLinksDAO.deleteHistoryLink(hlEntity.getAncestorNodeId(), hlEntity.getDescendentNodeId());
        }
        this.setAncestor(ancestor);
    }

    @Override
    public AVMNode getAncestor() {
        return AVMDAOs.Instance().fAVMNodeDAO.getAncestor(this);
    }

    @Override
    public void setMergedFrom(AVMNode mergedFrom) {
        if (mergedFrom == null) {
            return;
        }
        AVMDAOs.Instance().newAVMNodeLinksDAO.createMergeLink(mergedFrom.getId(), this.getId());
    }

    @Override
    public AVMNode getMergedFrom() {
        return AVMDAOs.Instance().fAVMNodeDAO.getMergedFrom(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AVMNode)) {
            return false;
        }
        return this.getId() == ((AVMNode)obj).getId();
    }

    public int hashCode() {
        return (int)this.getId();
    }

    public void setId(long id) {
        this.fID = id;
    }

    @Override
    public long getId() {
        return this.fID;
    }

    @Override
    public void setVersionID(int versionID) {
        this.fVersionID = versionID;
    }

    @Override
    public int getVersionID() {
        return this.fVersionID;
    }

    public void setBasicAttributes(BasicAttributes attrs) {
        this.fBasicAttributes = attrs;
    }

    @Override
    public BasicAttributes getBasicAttributes() {
        return this.fBasicAttributes;
    }

    @Override
    public boolean getIsNew() {
        return this.getStoreNew() != null;
    }

    public void setVers(long vers) {
        this.fVers = vers;
    }

    public long getVers() {
        return this.fVers;
    }

    @Override
    public boolean getIsRoot() {
        return this.fIsRoot;
    }

    @Override
    public void setIsRoot(boolean isRoot) {
        this.fIsRoot = isRoot;
    }

    @Override
    public void updateModTime() {
        String user;
        if (DEBUG) {
            this.checkReadOnly();
        }
        if ((user = RawServices.Instance().getAuthenticationContext().getCurrentUserName()) == null) {
            user = RawServices.Instance().getAuthenticationContext().getSystemUserName();
        }
        this.getBasicAttributes().setModDate(System.currentTimeMillis());
        this.getBasicAttributes().setLastModifier(user);
    }

    protected void copyProperties(AVMNode other) {
        HashMap<QName, PropertyValue> props = new HashMap<QName, PropertyValue>();
        for (Map.Entry<QName, PropertyValue> entry : other.getProperties().entrySet()) {
            props.put(entry.getKey(), entry.getValue());
        }
        this.setProperties(props);
    }

    protected void copyAspects(AVMNode other) {
        HashSet<QName> aspects = new HashSet<QName>(other.getAspects());
        this.setAspects(aspects);
    }

    protected void copyCreationAndOwnerBasicAttributes(AVMNode other) {
        this.getBasicAttributes().setCreateDate(other.getBasicAttributes().getCreateDate());
        this.getBasicAttributes().setCreator(other.getBasicAttributes().getCreator());
        this.getBasicAttributes().setOwner(other.getBasicAttributes().getOwner());
    }

    @Override
    public void copyACLs(AVMNode other, ACLCopyMode mode) {
        Acl otherAcl = other.getAcl();
        Long otherAclId = otherAcl == null ? null : otherAcl.getId();
        this.copyACLs(otherAclId, otherAclId, mode);
    }

    @Override
    public void copyACLs(Acl otherAcl, Acl parentAcl, ACLCopyMode mode) {
        Long otherAclId = otherAcl == null ? null : otherAcl.getId();
        Long parentAclId = parentAcl == null ? null : parentAcl.getId();
        this.copyACLs(otherAclId, parentAclId, mode);
    }

    protected void copyACLs(AVMNode other, Long parentAcl, ACLCopyMode mode) {
        Acl otherAcl = other.getAcl();
        this.copyACLs(otherAcl == null ? null : otherAcl.getId(), parentAcl, mode);
    }

    protected void copyACLs(Long otherAcl, Long parentAcl, ACLCopyMode mode) {
        if (otherAcl != null) {
            Acl aclCopy = AVMDAOs.Instance().fAclDAO.getAclCopy(otherAcl, parentAcl, mode);
            this.setAcl(aclCopy);
        } else {
            this.setAcl(null);
        }
    }

    @Override
    public void copyMetaDataFrom(AVMNode other, Long parentAcl) {
        this.copyAspects(other);
        this.copyACLs(other, parentAcl, ACLCopyMode.COPY);
        this.copyProperties(other);
        this.copyCreationAndOwnerBasicAttributes(other);
    }

    @Override
    public void setProperty(QName qname, PropertyValue value) {
        if (DEBUG) {
            this.checkReadOnly();
        }
        this.getProperties().put(qname, value);
        AVMDAOs.Instance().fAVMNodeDAO.createOrUpdateProperty(this.getId(), qname, value);
    }

    @Override
    public void addProperties(Map<QName, PropertyValue> properties) {
        for (Map.Entry<QName, PropertyValue> entry : properties.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setProperties(Map<QName, PropertyValue> properties) {
        this.fProperties = properties;
        for (Map.Entry<QName, PropertyValue> entry : properties.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public PropertyValue getProperty(QName qname) {
        return this.getProperties().get(qname);
    }

    @Override
    public Map<QName, PropertyValue> getProperties() {
        if (this.fProperties == null) {
            this.fProperties = AVMDAOs.Instance().fAVMNodeDAO.getProperties(this.getId());
        }
        return this.fProperties;
    }

    @Override
    public void deleteProperty(QName qname) {
        if (DEBUG) {
            this.checkReadOnly();
        }
        this.getProperties().remove(qname);
        AVMDAOs.Instance().fAVMNodeDAO.deleteProperty(this.getId(), qname);
    }

    @Override
    public void deleteProperties() {
        this.getProperties().clear();
        AVMDAOs.Instance().fAVMNodeDAO.deleteProperties(this.getId());
    }

    @Override
    public void setAcl(Acl acl) {
        this.fACL = acl;
    }

    @Override
    public Acl getAcl() {
        return this.fACL;
    }

    @Override
    public void setStoreNew(AVMStore store) {
        this.fStoreNew = store;
    }

    @Override
    public AVMStore getStoreNew() {
        return this.fStoreNew;
    }

    protected void checkReadOnly() {
        if (this.getStoreNew() == null) {
            throw new AVMReadOnlyException("Write Operation on R/O Node.");
        }
    }

    @Override
    public String getGuid() {
        return this.fGUID;
    }

    @Override
    public void setGuid(String guid) {
        this.fGUID = guid;
    }

    @Override
    public Set<QName> getAspects() {
        if (this.fAspects == null) {
            this.fAspects = AVMDAOs.Instance().fAVMNodeDAO.getAspects(this.getId());
        }
        return this.fAspects;
    }

    public void setAspects(Set<QName> aspects) {
        this.fAspects = aspects;
        if (aspects != null && aspects.size() > 0) {
            for (QName aspectQName : aspects) {
                AVMDAOs.Instance().fAVMNodeDAO.createAspect(this.getId(), aspectQName);
            }
        }
    }

    @Override
    public void addAspect(QName aspectQName) {
        this.fAspects = null;
        AVMDAOs.Instance().fAVMNodeDAO.createAspect(this.getId(), aspectQName);
    }

    @Override
    public void removeAspect(QName aspectQName) {
        this.fAspects = null;
        AVMDAOs.Instance().fAVMNodeDAO.deleteAspect(this.getId(), aspectQName);
    }

    public String toString() {
        return this.toString(null);
    }
}

