/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.AVMNodeImpl;
import org.alfresco.repo.avm.AVMStore;
import org.alfresco.repo.avm.BasicAttributes;
import org.alfresco.repo.avm.DeletedNode;
import org.alfresco.repo.avm.DirectoryNode;
import org.alfresco.repo.avm.Lookup;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.security.permissions.ACLCopyMode;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;

public class DeletedNodeImpl
extends AVMNodeImpl
implements DeletedNode {
    private static final long serialVersionUID = 7283526790174482993L;
    private int fDeletedType;

    public DeletedNodeImpl() {
    }

    public DeletedNodeImpl(AVMStore store, Acl acl) {
        super(store);
        this.setAcl(acl);
    }

    public DeletedNodeImpl(DeletedNode other, AVMStore store, Long parentAcl, ACLCopyMode mode) {
        super(store);
        this.setDeletedType(other.getDeletedType());
        this.copyACLs(other, parentAcl, mode);
        this.copyCreationAndOwnerBasicAttributes(other);
        AVMDAOs.Instance().fAVMNodeDAO.save(this);
        this.copyProperties(other);
        this.copyAspects(other);
    }

    public void setDeletedType(int type) {
        this.fDeletedType = type;
    }

    public int getDeletedType() {
        return this.fDeletedType;
    }

    public AVMNode copy(Lookup lPath) {
        DirectoryNode dir = lPath.getCurrentNodeDirectory();
        Long parentAclId = null;
        if (dir != null && dir.getAcl() != null) {
            parentAclId = dir.getAcl().getId();
        }
        DeletedNodeImpl newMe = new DeletedNodeImpl(this, lPath.getAVMStore(), parentAclId, ACLCopyMode.COPY);
        newMe.setAncestor(this);
        return newMe;
    }

    public AVMNodeDescriptor getDescriptor(Lookup lPath, String name) {
        BasicAttributes attrs = this.getBasicAttributes();
        String path = lPath.getRepresentedPath();
        path = path.endsWith("/") ? path + name : path + "/" + name;
        return new AVMNodeDescriptor(path, name, 4, attrs.getCreator(), attrs.getOwner(), attrs.getLastModifier(), attrs.getCreateDate(), attrs.getModDate(), attrs.getAccessDate(), this.getId(), this.getGuid(), this.getVersionID(), null, -1, false, -1L, false, -1L, this.getDeletedType());
    }

    public AVMNodeDescriptor getDescriptor(Lookup lPath) {
        BasicAttributes attrs = this.getBasicAttributes();
        String path = lPath.getRepresentedPath();
        return new AVMNodeDescriptor(path, path.substring(path.lastIndexOf("/") + 1), 4, attrs.getCreator(), attrs.getOwner(), attrs.getLastModifier(), attrs.getCreateDate(), attrs.getModDate(), attrs.getAccessDate(), this.getId(), this.getGuid(), this.getVersionID(), null, -1, false, -1L, false, -1L, this.getDeletedType());
    }

    public AVMNodeDescriptor getDescriptor(String parentPath, String name, String parentIndirection, int parentIndirectionVersion) {
        BasicAttributes attrs = this.getBasicAttributes();
        String path = parentPath.endsWith("/") ? parentPath + name : parentPath + "/" + name;
        return new AVMNodeDescriptor(path, name, 4, attrs.getCreator(), attrs.getOwner(), attrs.getLastModifier(), attrs.getCreateDate(), attrs.getModDate(), attrs.getAccessDate(), this.getId(), this.getGuid(), this.getVersionID(), null, -1, false, -1L, false, -1L, this.getDeletedType());
    }

    public int getType() {
        return 4;
    }

    public String toString(Lookup lPath) {
        return "[DN:" + this.getId() + "]";
    }
}

