/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.Collections;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.ExplictTransformationDetails;
import org.alfresco.service.cmr.repository.ContentAccessor;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.TransformationOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentTransformerHelper {
    private MimetypeService mimetypeService;
    private List<ExplictTransformationDetails> explicitTransformations;

    public ContentTransformerHelper() {
        this.setExplicitTransformations(Collections.<ExplictTransformationDetails>emptyList());
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    protected MimetypeService getMimetypeService() {
        return this.mimetypeService;
    }

    public void setExplicitTransformations(List<ExplictTransformationDetails> explicitTransformations) {
        this.explicitTransformations = explicitTransformations;
    }

    protected String getMimetype(ContentAccessor content) {
        String mimetype = content.getMimetype();
        if (mimetype == null) {
            throw new AlfrescoRuntimeException("Mimetype is mandatory for transformation: " + content);
        }
        return mimetype;
    }

    public boolean isExplicitTransformation(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        boolean result = false;
        for (ExplictTransformationDetails explicitTransformation : this.explicitTransformations) {
            if (!sourceMimetype.equals(explicitTransformation.getSourceMimetype()) || !targetMimetype.equals(explicitTransformation.getTargetMimetype())) continue;
            result = true;
            break;
        }
        return result;
    }
}

