/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.MailContentTransformer;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;

public class MailContentTransformerTest
extends AbstractContentTransformerTest {
    private ContentTransformer transformer;

    public void setUp() throws Exception {
        super.setUp();
        this.transformer = new MailContentTransformer();
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testIsTransformable() throws Exception {
        MailContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", "application/vnd.ms-outlook", new TransformationOptions()));
        MailContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-outlook", "text/plain", new TransformationOptions()));
    }

    public void testMsgToText() throws Exception {
        File msgSourceFile = MailContentTransformerTest.loadQuickTestFile("msg");
        File txtTargetFile = TempFileProvider.createTempFile((String)(this.getName() + "-target-1"), (String)".txt");
        FileContentReader reader = new FileContentReader(msgSourceFile);
        reader.setMimetype("application/vnd.ms-outlook");
        FileContentWriter writer = new FileContentWriter(txtTargetFile);
        writer.setMimetype("text/plain");
        this.transformer.transform(reader, writer);
        FileContentReader reader2 = new FileContentReader(txtTargetFile);
        reader2.setMimetype("text/plain");
        MailContentTransformerTest.assertTrue((boolean)reader2.getContentString().contains(QUICK_CONTENT));
    }

    public void testUnicodeMsgToText() throws Exception {
        File msgSourceFile = MailContentTransformerTest.loadQuickTestFile("unicode.msg");
        File txtTargetFile = TempFileProvider.createTempFile((String)(this.getName() + "-target-2"), (String)".txt");
        FileContentReader reader = new FileContentReader(msgSourceFile);
        reader.setMimetype("application/vnd.ms-outlook");
        FileContentWriter writer = new FileContentWriter(txtTargetFile);
        writer.setMimetype("text/plain");
        this.transformer.transform(reader, writer);
        FileContentReader reader2 = new FileContentReader(txtTargetFile);
        reader2.setMimetype("text/plain");
        MailContentTransformerTest.assertTrue((boolean)reader2.getContentString().contains(QUICK_CONTENT));
    }
}

