/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain;

import java.io.Serializable;
import java.util.Locale;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class PropertyValueTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();

    public void testMLText() {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        TransactionService txnService = serviceRegistry.getTransactionService();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> doTestCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                MLText mlText = new MLText(Locale.FRENCH, "bonjour");
                PropertyValue propertyValue = new PropertyValue(DataTypeDefinition.MLTEXT, (Serializable)mlText);
                Assert.assertEquals((String)"MLText not persisted as a string", (String)"bonjour", (String)propertyValue.getStringValue());
                try {
                    mlText = new MLText(Locale.GERMAN, "hallo");
                    mlText.addValue(Locale.ITALIAN, "ciao");
                    propertyValue = new PropertyValue(DataTypeDefinition.MLTEXT, (Serializable)mlText);
                    Assert.fail();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                mlText = new MLText(Locale.FRENCH, "");
                propertyValue = new PropertyValue(DataTypeDefinition.MLTEXT, (Serializable)mlText);
                Assert.assertEquals((String)"MLText not persisted as an empty string", (String)"", (String)propertyValue.getStringValue());
                mlText = new MLText(Locale.GERMAN, null);
                propertyValue = new PropertyValue(DataTypeDefinition.MLTEXT, (Serializable)mlText);
                Assert.assertNull((String)"MLText not persisted as a null string", (Object)propertyValue.getStringValue());
                return null;
            }
        };
        txnService.getRetryingTransactionHelper().doInTransaction(doTestCallback, false);
    }
}

