/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditablePropertiesEntity {
    private static Set<QName> auditablePropertyQNames = new HashSet<QName>(13);
    private String auditCreator;
    private String auditCreated;
    private String auditModifier;
    private String auditModified;
    private String auditAccessed;
    private long auditModifiedTime = -1L;

    public static Set<QName> getAuditablePropertyQNames() {
        return auditablePropertyQNames;
    }

    public static boolean isAuditableProperty(QName qname) {
        return auditablePropertyQNames.contains(qname);
    }

    public static boolean hasAuditableAspect(QName typeQName, DictionaryService dictionaryService) {
        TypeDefinition typeDef = dictionaryService.getType(typeQName);
        if (typeDef == null) {
            return false;
        }
        return typeDef.getDefaultAspectNames().contains(ContentModel.ASPECT_AUDITABLE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("AuditablePropertiesEntity").append("[ auditCreator=").append(this.auditCreator).append(", auditCreated=").append(this.auditCreated).append(", auditModifier=").append(this.auditModifier).append(", auditModified=").append(this.auditModified).append("]");
        return sb.toString();
    }

    public Serializable getAuditableProperty(QName qname) {
        if (qname.equals((Object)ContentModel.PROP_CREATOR)) {
            return this.auditCreator;
        }
        if (qname.equals((Object)ContentModel.PROP_CREATED)) {
            return (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditCreated);
        }
        if (qname.equals((Object)ContentModel.PROP_MODIFIER)) {
            return this.auditModifier == null ? this.auditCreator : this.auditModifier;
        }
        if (qname.equals((Object)ContentModel.PROP_MODIFIED)) {
            String dateStr = this.auditModified == null ? this.auditCreated : this.auditModified;
            return (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)dateStr);
        }
        if (qname.equals((Object)ContentModel.PROP_ACCESSED)) {
            return (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditAccessed);
        }
        return null;
    }

    private boolean setAuditableProperty(QName qname, Serializable value) {
        if (qname.equals((Object)ContentModel.PROP_CREATOR)) {
            this.auditCreator = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
            return true;
        }
        if (qname.equals((Object)ContentModel.PROP_MODIFIER)) {
            this.auditModifier = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
            return true;
        }
        if (qname.equals((Object)ContentModel.PROP_CREATED)) {
            this.auditCreated = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
            return true;
        }
        if (qname.equals((Object)ContentModel.PROP_MODIFIED)) {
            this.auditModified = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
            return true;
        }
        if (qname.equals((Object)ContentModel.PROP_ACCESSED)) {
            this.auditAccessed = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
            return true;
        }
        return false;
    }

    public Map<QName, Serializable> getAuditableProperties() {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(7);
        properties.put(ContentModel.PROP_CREATOR, (Serializable)((Object)this.auditCreator));
        properties.put(ContentModel.PROP_CREATED, (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditCreated));
        if (this.auditModifier != null) {
            properties.put(ContentModel.PROP_MODIFIER, (Serializable)((Object)this.auditModifier));
        } else {
            properties.put(ContentModel.PROP_MODIFIER, (Serializable)((Object)this.auditCreator));
        }
        if (this.auditModified != null) {
            properties.put(ContentModel.PROP_MODIFIED, (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditModified));
        } else {
            properties.put(ContentModel.PROP_MODIFIED, (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditCreated));
        }
        if (this.auditAccessed != null) {
            properties.put(ContentModel.PROP_ACCESSED, (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditAccessed));
        }
        return properties;
    }

    public boolean setAuditValues(String user, Date date, boolean force, long modifiedDateToleranceMs) {
        long lastModTime;
        if (user == null && (user = AuthenticationUtil.getFullyAuthenticatedUser()) == null) {
            user = "unknown";
        }
        if (date == null) {
            date = new Date();
        }
        String dateStr = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date);
        long dateTime = date.getTime();
        boolean changed = false;
        if (force || this.auditCreator == null) {
            this.auditCreator = user;
            changed = true;
        }
        if (force || this.auditCreated == null) {
            this.auditCreated = dateStr;
            changed = true;
        }
        if (this.auditModifier == null || !this.auditModifier.equals(user)) {
            this.auditModifier = user;
            changed = true;
        }
        if ((lastModTime = this.getAuditModifiedTime()) < 0L || lastModTime + modifiedDateToleranceMs < dateTime) {
            this.auditModifiedTime = dateTime;
            this.auditModified = dateStr;
            changed = true;
        }
        return changed;
    }

    public boolean setAuditValues(String user, Date date, Map<QName, Serializable> properties) {
        boolean changed = false;
        if (properties.containsKey(ContentModel.PROP_CREATOR)) {
            this.auditCreator = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_CREATOR));
            changed = true;
        }
        if (properties.containsKey(ContentModel.PROP_MODIFIER)) {
            this.auditModifier = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_MODIFIER));
            changed = true;
        }
        if (properties.containsKey(ContentModel.PROP_CREATED)) {
            this.auditCreated = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_CREATED));
            changed = true;
        }
        if (properties.containsKey(ContentModel.PROP_MODIFIED)) {
            Date auditModifiedDate = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)properties.get(ContentModel.PROP_MODIFIED));
            this.auditModifiedTime = auditModifiedDate.getTime();
            this.auditModified = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)auditModifiedDate);
            changed = true;
        }
        if (properties.containsKey(ContentModel.PROP_ACCESSED)) {
            this.auditAccessed = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_ACCESSED));
            changed = true;
        }
        if (changed) {
            if (user == null && (user = AuthenticationUtil.getFullyAuthenticatedUser()) == null) {
                user = "unknown";
            }
            if (date == null) {
                date = new Date();
            }
            String dateStr = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date);
            long dateTime = date.getTime();
            if (this.auditCreator == null) {
                this.auditCreator = user;
            }
            if (this.auditModifier == null) {
                this.auditModifier = user;
            }
            if (this.auditCreated == null) {
                this.auditCreated = dateStr;
            }
            if (this.auditModified == null) {
                this.auditModifiedTime = dateTime;
                this.auditModified = dateStr;
            }
        }
        return changed;
    }

    public String getAuditCreator() {
        return this.auditCreator;
    }

    public void setAuditCreator(String auditCreator) {
        this.auditCreator = auditCreator;
    }

    public String getAuditCreated() {
        return this.auditCreated;
    }

    public void setAuditCreated(String auditCreated) {
        this.auditCreated = auditCreated;
    }

    public String getAuditModifier() {
        return this.auditModifier;
    }

    public void setAuditModifier(String auditModifier) {
        this.auditModifier = auditModifier;
    }

    public String getAuditModified() {
        return this.auditModified;
    }

    private long getAuditModifiedTime() {
        if (this.auditModifiedTime < 0L && this.auditModified != null) {
            this.auditModifiedTime = ((Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditModified)).getTime();
        }
        return this.auditModifiedTime;
    }

    public void setAuditModified(String auditModified) {
        this.auditModified = auditModified;
    }

    public String getAuditAccessed() {
        return this.auditAccessed;
    }

    public void setAuditAccessed(String auditAccessed) {
        this.auditAccessed = auditAccessed;
    }

    static {
        auditablePropertyQNames.add(ContentModel.PROP_CREATOR);
        auditablePropertyQNames.add(ContentModel.PROP_CREATED);
        auditablePropertyQNames.add(ContentModel.PROP_MODIFIER);
        auditablePropertyQNames.add(ContentModel.PROP_MODIFIED);
        auditablePropertyQNames.add(ContentModel.PROP_ACCESSED);
    }
}

