/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.googledocs;

import com.google.gdata.client.GoogleAuthTokenFactory;
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.docs.DocsService;
import com.google.gdata.data.Content;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.MediaContent;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.acl.AclEntry;
import com.google.gdata.data.acl.AclFeed;
import com.google.gdata.data.acl.AclRole;
import com.google.gdata.data.acl.AclScope;
import com.google.gdata.data.docs.DocumentEntry;
import com.google.gdata.data.docs.DocumentListEntry;
import com.google.gdata.data.docs.FolderEntry;
import com.google.gdata.data.docs.PdfEntry;
import com.google.gdata.data.docs.PresentationEntry;
import com.google.gdata.data.docs.SpreadsheetEntry;
import com.google.gdata.data.media.IMediaContent;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.data.media.MediaStreamSource;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.googledocs.GoogleDocsModel;
import org.alfresco.repo.googledocs.GoogleDocsPermissionContext;
import org.alfresco.repo.googledocs.GoogleDocsService;
import org.alfresco.repo.googledocs.GoogleDocsServiceInitException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleDocsServiceImpl
extends TransactionListenerAdapter
implements GoogleDocsService,
GoogleDocsModel {
    private static Log logger = LogFactory.getLog(GoogleDocsServiceImpl.class);
    public static final String TYPE_DOCUMENT = "document";
    public static final String TYPE_SPREADSHEET = "spreadsheet";
    public static final String TYPE_PRESENTATION = "presentation";
    public static final String TYPE_PDF = "pdf";
    private static final String KEY_MARKED_CREATE = "google_doc_service.marked_resources";
    private static final String KEY_MARKED_DELETE = "google_doc_service.marked_delete";
    private DocsService googleDocumentService;
    private GoogleService spreadsheetsService;
    private NodeService nodeService;
    private ContentService contentService;
    private PersonService personService;
    private MimetypeService mimetypeService;
    private PermissionService permissionService;
    private OwnableService ownableService;
    private AuthorityService authorityService;
    private DictionaryService dictionaryService;
    private String url = "http://docs.google.com/feeds/default/private/full";
    private String downloadUrl = "https://docs.google.com/feeds/download";
    private boolean initialised = false;
    private String username;
    private String password;
    private Map<String, String> permissionMap;

    public void setGoogleDocumentService(DocsService googleDocumentService) {
        this.googleDocumentService = googleDocumentService;
    }

    public void setSpreadsheetsService(GoogleService spreadsheetsService) {
        this.spreadsheetsService = spreadsheetsService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPermissionMap(Map<String, String> permissionMap) {
        this.permissionMap = permissionMap;
    }

    @Override
    public void initialise() throws GoogleDocsServiceInitException {
        if (!this.initialised) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trying to initialise google docs service for user " + this.username));
            }
            if (this.username == null || this.username.length() == 0 || this.password == null) {
                throw new GoogleDocsServiceInitException("No Goolge Docs credentials found. Please set the Google Docs authentication configuration.");
            }
            try {
                this.googleDocumentService.setUserCredentials(this.username, this.password);
                this.spreadsheetsService.setUserCredentials(this.username, this.password);
                this.googleDocumentService.setChunkedMediaUpload(-1);
            }
            catch (AuthenticationException e) {
                throw new GoogleDocsServiceInitException("Unable to connect to Google Docs.  Please check the Google Docs authentication configuration.", e);
            }
            this.initialised = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully initialised google docs service for user " + this.username));
            }
        }
    }

    @Override
    public void createGoogleDoc(NodeRef nodeRef, GoogleDocsPermissionContext permissionContext) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        try {
            this.initialise();
        }
        catch (GoogleDocsServiceInitException e) {
            throw new AlfrescoRuntimeException("Unable to create google doc, because service could not be initialised.", (Throwable)e);
        }
        String name = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
        String mimetype = null;
        InputStream is = null;
        ContentReader contentReader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        if (contentReader == null) {
            mimetype = this.mimetypeService.guessMimetype(name);
        } else {
            mimetype = contentReader.getMimetype();
            if (contentReader.getSize() != 0L) {
                is = contentReader.getContentInputStream();
            }
        }
        DocumentListEntry parentFolder = this.getParentFolder(nodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating google document (" + name + "," + mimetype + ")"));
        }
        DocumentListEntry document = this.createGoogleDocument(name, mimetype, parentFolder, is);
        this.setGoogleResourcePermissions(nodeRef, document, permissionContext);
        this.setResourceDetails(nodeRef, document);
    }

    @Override
    public void deleteGoogleResource(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        try {
            this.initialise();
        }
        catch (GoogleDocsServiceInitException e) {
            throw new AlfrescoRuntimeException("Unable to create google doc, because service could not be initialised.", (Throwable)e);
        }
        if (this.nodeService.hasAspect(nodeRef, ASPECT_GOOGLERESOURCE)) {
            DocumentListEntry entry = this.getDocumentListEntry(nodeRef);
            if (entry != null) {
                this.markResource(KEY_MARKED_DELETE, entry.getResourceId());
            }
            this.nodeService.removeAspect(nodeRef, ASPECT_GOOGLERESOURCE);
        }
    }

    private void setGoogleResourcePermissions(NodeRef nodeRef, DocumentListEntry resource, GoogleDocsPermissionContext permissionContext) {
        String owner = this.ownableService.getOwner(nodeRef);
        this.setGoogleResourcePermission(resource, AuthorityType.USER, owner, "owner");
        if (!GoogleDocsPermissionContext.PRIVATE.equals((Object)permissionContext)) {
            Set accessPermissions = this.permissionService.getAllSetPermissions(nodeRef);
            for (AccessPermission accessPermission : accessPermissions) {
                String authorityName = accessPermission.getAuthority();
                AuthorityType authorityType = accessPermission.getAuthorityType();
                String permission = accessPermission.getPermission();
                if (!this.permissionMap.containsKey(permission)) continue;
                String aclRole = this.permissionMap.get(permission);
                if (GoogleDocsPermissionContext.SHARE_READ.equals((Object)permissionContext) && ("reader".equals(aclRole) || "writer".equals(aclRole))) {
                    this.setGoogleResourcePermission(resource, authorityType, authorityName, "reader");
                    continue;
                }
                if (GoogleDocsPermissionContext.SHARE_WRITE.equals((Object)permissionContext) && "writer".equals(aclRole)) {
                    this.setGoogleResourcePermission(resource, authorityType, authorityName, "writer");
                    continue;
                }
                if (!GoogleDocsPermissionContext.SHARE_READWRITE.equals((Object)permissionContext) || !"reader".equals(aclRole) && !"writer".equals(aclRole)) continue;
                this.setGoogleResourcePermission(resource, authorityType, authorityName, aclRole);
            }
        }
    }

    private void setGoogleResourcePermission(DocumentListEntry resource, AuthorityType authorityType, String authorityName, String role) {
        if (AuthorityType.USER.equals((Object)authorityType)) {
            String userEMail = this.getUserEMail(authorityName);
            if (userEMail != null && userEMail.length() != 0) {
                this.setGoogleResourcePermission(resource, userEMail, role);
            }
        } else if (AuthorityType.GROUP.equals((Object)authorityType)) {
            Set<String> childAuthorities = this.authorityService.getContainedAuthorities(AuthorityType.USER, authorityName, false);
            for (String childAuthority : childAuthorities) {
                this.setGoogleResourcePermission(resource, AuthorityType.USER, childAuthority, role);
            }
        }
    }

    private String getUserEMail(String userName) {
        String email = null;
        NodeRef personNodeRef = this.personService.getPerson(userName);
        if (personNodeRef != null && ((email = (String)((Object)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_GOOGLEUSERNAME))) == null || email.length() == 0)) {
            email = (String)((Object)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_EMAIL));
        }
        return email;
    }

    private DocumentListEntry getParentFolder(NodeRef nodeRef) {
        DocumentListEntry folder = null;
        NodeRef parentNodeRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
        if (parentNodeRef != null) {
            if (this.nodeService.hasAspect(parentNodeRef, ASPECT_GOOGLERESOURCE)) {
                String resourceType = (String)((Object)this.nodeService.getProperty(parentNodeRef, PROP_RESOURCE_TYPE));
                String resourceId = (String)((Object)this.nodeService.getProperty(parentNodeRef, PROP_RESOURCE_ID));
                folder = this.getDocumentListEntry(resourceType + ":" + resourceId);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found existing google folder + " + resourceId));
                }
            } else {
                DocumentListEntry parentFolder = this.getParentFolder(parentNodeRef);
                if (parentFolder != null) {
                    String name = null;
                    QName parentNodeType = this.nodeService.getType(parentNodeRef);
                    name = this.dictionaryService.isSubClass(parentNodeType, ContentModel.TYPE_STOREROOT) ? parentNodeRef.getStoreRef().getIdentifier() : (String)((Object)this.nodeService.getProperty(parentNodeRef, ContentModel.PROP_NAME));
                    folder = this.createGoogleFolder(name, parentFolder);
                    this.setResourceDetails(parentNodeRef, folder);
                    this.setGoogleResourcePermission(folder, AuthorityType.USER, this.username, "owner");
                    this.setGoogleResourcePermission(folder, AuthorityType.USER, this.username, "owner");
                }
            }
        }
        return folder;
    }

    private void setResourceDetails(final NodeRef nodeRef, final DocumentListEntry documentListEntry) {
        AuthenticationUtil.RunAsWork<Object> runAsWork = new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                HashMap<QName, String> props = new HashMap<QName, String>(1);
                props.put(GoogleDocsModel.PROP_RESOURCE_ID, documentListEntry.getDocId());
                props.put(GoogleDocsModel.PROP_RESOURCE_TYPE, documentListEntry.getType());
                props.put(GoogleDocsModel.PROP_URL, documentListEntry.getDocumentLink().getHref());
                GoogleDocsServiceImpl.this.nodeService.addAspect(nodeRef, GoogleDocsModel.ASPECT_GOOGLERESOURCE, props);
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)runAsWork, (String)AuthenticationUtil.getAdminUserName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InputStream getGoogleDocContent(NodeRef nodeRef) {
        InputStream result = null;
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        try {
            this.initialise();
        }
        catch (GoogleDocsServiceInitException e) {
            throw new AlfrescoRuntimeException("Unable to create google doc, because service could not be initialised.", (Throwable)e);
        }
        try {
            if (!this.nodeService.hasAspect(nodeRef, ASPECT_GOOGLERESOURCE)) throw new AlfrescoRuntimeException("Can not download google doc content since no corresponsing google resource could be found");
            String downloadUrl = null;
            DocumentListEntry document = this.getDocumentListEntry(nodeRef);
            if (document == null) throw new AlfrescoRuntimeException("Can not download google doc content since no corresponsing google resource could be found");
            String docType = document.getType();
            ContentData contentData = (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT);
            String fileExtension = this.mimetypeService.getExtension(contentData.getMimetype());
            if (fileExtension.equals("docx")) {
                fileExtension = "doc";
            }
            if (docType.equals(TYPE_DOCUMENT) || docType.equals(TYPE_PRESENTATION)) {
                downloadUrl = this.downloadUrl + "/" + docType + "s/Export?docId=" + document.getDocId() + "&exportFormat=" + fileExtension;
            } else if (docType.equals(TYPE_SPREADSHEET)) {
                downloadUrl = ((MediaContent)document.getContent()).getUri() + "&exportFormat=" + fileExtension;
                if (fileExtension.equals("csv") || fileExtension.equals("tsv")) {
                    downloadUrl = downloadUrl + "&gid=0";
                }
            } else {
                if (!docType.equals(TYPE_PDF)) throw new AlfrescoRuntimeException("Unsuported document type: " + docType);
                MediaContent mc = (MediaContent)document.getContent();
                downloadUrl = mc.getUri();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Download URL for " + docType + " is " + downloadUrl));
            }
            GoogleAuthTokenFactory.UserToken docsToken = null;
            if (docType.equals(TYPE_SPREADSHEET)) {
                docsToken = (GoogleAuthTokenFactory.UserToken)this.googleDocumentService.getAuthTokenFactory().getAuthToken();
                GoogleAuthTokenFactory.UserToken spreadsheetsToken = (GoogleAuthTokenFactory.UserToken)this.spreadsheetsService.getAuthTokenFactory().getAuthToken();
                this.googleDocumentService.setUserToken(spreadsheetsToken.getValue());
            }
            MediaContent mc = new MediaContent();
            mc.setUri(downloadUrl);
            MediaSource ms = this.googleDocumentService.getMedia((IMediaContent)mc);
            if (!docType.equals(TYPE_SPREADSHEET)) return ms.getInputStream();
            this.googleDocumentService.setUserToken(docsToken.getValue());
            return ms.getInputStream();
        }
        catch (ServiceException e) {
            throw new AlfrescoRuntimeException("Unable to get google document stream.", (Throwable)e);
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Unable to get google document stream.", (Throwable)e);
        }
    }

    private DocumentListEntry getDocumentListEntry(NodeRef docNodeRef) {
        DocumentListEntry result = null;
        String docType = (String)((Object)this.nodeService.getProperty(docNodeRef, PROP_RESOURCE_TYPE));
        String docId = (String)((Object)this.nodeService.getProperty(docNodeRef, PROP_RESOURCE_ID));
        if (docType != null && docId != null) {
            result = this.getDocumentListEntry(docType + ":" + docId);
        }
        return result;
    }

    private DocumentListEntry getDocumentListEntry(String docResourceId) {
        return this.getEntry(docResourceId, DocumentListEntry.class);
    }

    private <E extends IEntry> E getEntry(String resourceId, Class<E> entryClass) {
        IEntry result = null;
        try {
            URL docEntryURL = new URL(this.url + "/" + resourceId);
            result = this.googleDocumentService.getEntry(docEntryURL, entryClass);
        }
        catch (ServiceException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to get document list entry for resource " + resourceId + " because " + e.getMessage()));
            }
            result = null;
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to get document list entry for resource " + resourceId + " because " + e.getMessage()));
            }
            result = null;
        }
        return (E)result;
    }

    private DocumentListEntry createGoogleDocument(String name, String mimetype, DocumentListEntry parentFolder, InputStream is) {
        DocumentListEntry document = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating google document with name " + name));
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating media content object for mimetype " + mimetype));
            }
            MediaContent mediaContent = new MediaContent();
            mediaContent.setMimeType(new ContentType(mimetype));
            if (is != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)" ... input stream has been set");
                }
                mediaContent.setMediaSource((MediaSource)new MediaStreamSource(is, mimetype));
            }
            String parentFolderUrl = this.url;
            if (parentFolder != null) {
                parentFolderUrl = ((MediaContent)parentFolder.getContent()).getUri();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(" ... parent folder URL is " + parentFolderUrl));
                }
            }
            SpreadsheetEntry docEntry = null;
            if (DocumentListEntry.MediaType.XLS.getMimeType().equals(mimetype) || DocumentListEntry.MediaType.XLSX.getMimeType().equals(mimetype) || DocumentListEntry.MediaType.ODS.getMimeType().equals(mimetype)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Creating SpreadsheetEntry for mimetype " + mimetype));
                }
                docEntry = new SpreadsheetEntry();
            } else if (DocumentListEntry.MediaType.PPS.getMimeType().equals(mimetype) || DocumentListEntry.MediaType.PPT.getMimeType().equals(mimetype)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Creating PresentationEntry for mimetype " + mimetype));
                }
                docEntry = new PresentationEntry();
            } else if (DocumentListEntry.MediaType.PDF.getMimeType().equals(mimetype)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Creating PdfEntry for mimetype " + mimetype));
                }
                docEntry = new PdfEntry();
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Creating DocumentEntry for mimetype " + mimetype));
                }
                docEntry = new DocumentEntry();
            }
            docEntry.setContent((Content)mediaContent);
            docEntry.setTitle((TextConstruct)new PlainTextConstruct(name));
            document = (DocumentListEntry)this.googleDocumentService.insert(new URL(parentFolderUrl), (IEntry)docEntry);
            this.markResource(KEY_MARKED_CREATE, document.getResourceId());
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to create google document with name " + name + ", because " + e.getMessage()));
            }
            throw new AlfrescoRuntimeException("Unable to create google document", (Throwable)e);
        }
        catch (ServiceException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to create google document with name " + name + ", because " + e.getMessage()));
            }
            throw new AlfrescoRuntimeException("Unable to create google document", (Throwable)e);
        }
        return document;
    }

    private void updateGoogleDocContent(DocumentListEntry document, String mimeType, InputStream is) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updating content of document " + document.getResourceId()));
        }
        try {
            this.googleDocumentService.getRequestFactory().setHeader("If-Match", "*");
            document.setMediaSource((MediaSource)new MediaStreamSource(is, mimeType));
            document.updateMedia(false);
            this.googleDocumentService.getRequestFactory().setHeader("If-Match", null);
        }
        catch (ServiceException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to update the content of document " + document.getResourceId() + ", because " + e.getMessage()));
            }
            throw new AlfrescoRuntimeException("Unable to update documents content in google docs", (Throwable)e);
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to update the content of document " + document.getResourceId() + ", because " + e.getMessage()));
            }
            throw new AlfrescoRuntimeException("Unable to update documents content in google docs", (Throwable)e);
        }
    }

    private DocumentListEntry createGoogleFolder(String folderName, DocumentListEntry parentFolder) {
        DocumentListEntry folderEntry = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating folder " + folderName));
            }
            String parentFolderUrl = this.url;
            if (parentFolder != null) {
                parentFolderUrl = ((MediaContent)parentFolder.getContent()).getUri();
            }
            FolderEntry folder = new FolderEntry();
            folder.setTitle((TextConstruct)new PlainTextConstruct(folderName));
            folderEntry = (DocumentListEntry)this.googleDocumentService.insert(new URL(parentFolderUrl), (IEntry)folder);
            this.markResource(KEY_MARKED_CREATE, folderEntry.getResourceId());
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to create folder " + folderName + ", because " + e.getMessage()));
            }
            throw new AlfrescoRuntimeException("Unable to create Google Folder", (Throwable)e);
        }
        catch (ServiceException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to create folder " + folderName + ", because " + e.getMessage()));
            }
            throw new AlfrescoRuntimeException("Unable to create Google Folder", (Throwable)e);
        }
        return folderEntry;
    }

    private void setGoogleResourcePermission(DocumentListEntry resource, String email, String role) {
        ParameterCheck.mandatory((String)"resource", (Object)resource);
        ParameterCheck.mandatory((String)"email", (Object)email);
        ParameterCheck.mandatory((String)"role", (Object)role);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting the role " + role + " on the google resource " + resource.getResourceId() + " for email " + email + "."));
        }
        try {
            AclRole aclRole = new AclRole(role);
            AclScope scope = new AclScope(AclScope.Type.USER, email);
            URL aclFeedLinkURL = new URL(resource.getAclFeedLink().getHref());
            AclEntry aclEntry = null;
            AclFeed aclFeed = (AclFeed)this.googleDocumentService.getFeed(aclFeedLinkURL, AclFeed.class);
            if (aclFeed != null) {
                List aclEntries = aclFeed.getEntries();
                for (AclEntry tempAclEntry : aclEntries) {
                    AclScope tempScope = tempAclEntry.getScope();
                    if (!tempScope.equals((Object)scope)) continue;
                    aclEntry = tempAclEntry;
                    break;
                }
            }
            if (aclEntry == null) {
                aclEntry = new AclEntry();
                aclEntry.setRole(aclRole);
                aclEntry.setScope(scope);
                this.googleDocumentService.insert(aclFeedLinkURL, (IEntry)aclEntry);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to the role " + role + " on the google resource " + resource.getResourceId() + " for email " + email + "." + "  This user already has a role on this document."));
            }
        }
        catch (ServiceException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to the role " + role + " on the google resource " + resource.getResourceId() + " for email " + email + "." + "  Check that this is a valid google account."));
            }
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Unable to set premissions on google document", (Throwable)e);
        }
    }

    private void markResource(String key, String resourceId) {
        ArrayList<String> resources = (ArrayList<String>)AlfrescoTransactionSupport.getResource(key);
        if (resources == null) {
            resources = new ArrayList<String>();
            AlfrescoTransactionSupport.bindResource(key, resources);
            AlfrescoTransactionSupport.bindListener(this);
        }
        if (!resources.contains(resourceId)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Marking resource " + resourceId + " with key " + key));
            }
            resources.add(resourceId);
        }
    }

    @Override
    public void afterCommit() {
        List resources = (List)AlfrescoTransactionSupport.getResource(KEY_MARKED_DELETE);
        if (resources != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Transaction commited, deleting Google resources");
            }
            for (String resourceId : resources) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Deleting resource " + resourceId));
                }
                try {
                    DocumentListEntry entry = this.getDocumentListEntry(resourceId);
                    if (entry != null) {
                        this.googleDocumentService.delete(new URL(entry.getEditLink().getHref() + "?delete=true"), entry.getEtag());
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Unable to delete resource " + resourceId + " during commit."));
                }
                catch (Throwable e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Unable to delete resource " + resourceId + " during commit."), e);
                }
            }
        }
    }

    @Override
    public void afterRollback() {
        List resources = (List)AlfrescoTransactionSupport.getResource(KEY_MARKED_CREATE);
        if (resources != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Transaction rolled back, manually deleting created Google Resources");
            }
            for (String resourceId : resources) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Deleting created resource " + resourceId));
                }
                try {
                    DocumentListEntry entry = this.getDocumentListEntry(resourceId);
                    if (entry != null) {
                        this.googleDocumentService.delete(new URL(entry.getEditLink().getHref() + "?delete=true"), entry.getEtag());
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Unable to delete resource " + resourceId + " during rollback."));
                }
                catch (Throwable e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Unable to delete resource " + resourceId + " during rollback."), e);
                }
            }
        }
    }
}

