/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import com.icegreen.greenmail.foedus.util.MsgRangeFilter;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.FolderListener;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.MessageFlags;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ImapModel;
import org.alfresco.repo.imap.AbstractImapFolder;
import org.alfresco.repo.imap.AbstractMimeMessage;
import org.alfresco.repo.imap.AlfrescoImapConst;
import org.alfresco.repo.imap.ContentModelMessage;
import org.alfresco.repo.imap.ImapModelMessage;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.repo.imap.IncomingImapMessage;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.util.GUID;
import org.alfresco.util.Utf7;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlfrescoImapFolder
extends AbstractImapFolder {
    private static final long YEAR_2005 = 1101765600000L;
    private static Log logger = LogFactory.getLog(AlfrescoImapFolder.class);
    private FileInfo folderInfo;
    private NodeRef rootNodeRef;
    private String qualifiedMailboxName;
    private String folderName;
    private AlfrescoImapConst.ImapViewMode viewMode;
    private String mountPointName;
    private ImapService imapService;
    private boolean selectable;
    private Boolean readOnly;
    private boolean extractAttachmentsEnabled;
    private Map<Long, SimpleStoredMessage> messages = new TreeMap<Long, SimpleStoredMessage>();
    private Map<Long, Integer> msnCache = new HashMap<Long, Integer>();
    private Map<Long, CacheItem> messagesCache = Collections.synchronizedMap(new MaxSizeMap(10, 20));
    private static final int CACHE_SIZE = 20;
    private static final Flags PERMANENT_FLAGS = new Flags();

    public boolean isExtractAttachmentsEnabled() {
        return this.extractAttachmentsEnabled;
    }

    AlfrescoImapFolder(String qualifiedMailboxName, ServiceRegistry serviceRegistry) {
        this(qualifiedMailboxName, null, null, null, null, null, false, serviceRegistry);
    }

    public AlfrescoImapFolder(String qualifiedMailboxName, FileInfo folderInfo, String folderName, AlfrescoImapConst.ImapViewMode viewMode, NodeRef rootNodeRef, String mountPointName, boolean extractAttachmentsEnabled, ServiceRegistry serviceRegistry) {
        this(qualifiedMailboxName, folderInfo, folderName, viewMode, rootNodeRef, mountPointName, serviceRegistry, null, extractAttachmentsEnabled);
    }

    public AlfrescoImapFolder(String qualifiedMailboxName, FileInfo folderInfo, String folderName, AlfrescoImapConst.ImapViewMode viewMode, NodeRef rootNodeRef, String mountPointName, ServiceRegistry serviceRegistry, Boolean selectable, boolean extractAttachmentsEnabled) {
        super(serviceRegistry);
        this.qualifiedMailboxName = qualifiedMailboxName;
        this.folderInfo = folderInfo;
        this.rootNodeRef = rootNodeRef;
        this.folderName = folderName != null ? folderName : (folderInfo != null ? folderInfo.getName() : null);
        this.viewMode = viewMode != null ? viewMode : AlfrescoImapConst.ImapViewMode.ARCHIVE;
        this.mountPointName = mountPointName;
        this.extractAttachmentsEnabled = extractAttachmentsEnabled;
        if (serviceRegistry != null) {
            this.imapService = serviceRegistry.getImapService();
        }
        if (folderInfo != null) {
            if (selectable == null) {
                Boolean storedSelectable = !serviceRegistry.getNodeService().hasAspect(folderInfo.getNodeRef(), ImapModel.ASPECT_IMAP_FOLDER_NONSELECTABLE);
                if (storedSelectable == null) {
                    this.setSelectable(true);
                } else {
                    this.setSelectable(storedSelectable);
                }
            } else {
                this.setSelectable(selectable);
            }
            AccessStatus status = serviceRegistry.getPublicServiceAccessService().hasAccess(ServiceRegistry.NODE_SERVICE.getLocalName(), "createNode", folderInfo.getNodeRef(), null, null, null);
            this.readOnly = status == AccessStatus.DENIED ? Boolean.valueOf(true) : Boolean.valueOf(false);
        } else {
            this.setSelectable(true);
        }
    }

    @Override
    protected long appendMessageInternal(MimeMessage message, Flags flags, Date internalDate) throws FileExistsException, FileNotFoundException, IOException, MessagingException {
        AbstractMimeMessage internalMessage = this.createMimeMessageInFolder(this.folderInfo, message);
        long newMessageUid = (Long)internalMessage.getMessageInfo().getProperties().get(ContentModel.PROP_NODE_DBID);
        SimpleStoredMessage storedMessage = new SimpleStoredMessage((MimeMessage)internalMessage, new Date(), newMessageUid);
        this.messages.put(newMessageUid, storedMessage);
        this.msnCache.put(newMessageUid, this.messages.size());
        return newMessageUid;
    }

    @Override
    protected void copyMessageInternal(long uid, MailFolder toFolder) throws MessagingException, FileExistsException, FileNotFoundException, IOException {
        AlfrescoImapFolder toImapMailFolder = (AlfrescoImapFolder)toFolder;
        NodeRef destFolderNodeRef = toImapMailFolder.getFolderInfo().getNodeRef();
        SimpleStoredMessage message = this.messages.get(uid);
        FileInfo sourceMessageFileInfo = ((AbstractMimeMessage)message.getMimeMessage()).getMessageInfo();
        if (this.serviceRegistry.getNodeService().hasAspect(sourceMessageFileInfo.getNodeRef(), ImapModel.ASPECT_IMAP_CONTENT)) {
            ImapModelMessage newMessage = new ImapModelMessage(sourceMessageFileInfo, this.serviceRegistry, true);
            toImapMailFolder.appendMessageInternal(newMessage, message.getFlags(), new Date());
        } else {
            this.serviceRegistry.getFileFolderService().copy(sourceMessageFileInfo.getNodeRef(), destFolderNodeRef, null);
        }
    }

    @Override
    public void deleteAllMessagesInternal() throws FolderException {
        if (this.readOnly.booleanValue()) {
            throw new FolderException("Can't delete all - Permission denied");
        }
        for (SimpleStoredMessage mess : this.messages.values()) {
            AbstractMimeMessage message = (AbstractMimeMessage)mess.getMimeMessage();
            FileInfo fileInfo = message.getMessageInfo();
            this.imapService.setFlag(fileInfo, Flags.Flag.DELETED, true);
            this.messages.remove(mess.getUid());
            this.msnCache.remove(mess.getUid());
        }
    }

    @Override
    protected void expungeInternal() throws FolderException {
        if (this.readOnly.booleanValue()) {
            throw new FolderException("Can't expunge - Permission denied");
        }
        Collection<SimpleStoredMessage> listMess = this.messages.values();
        for (SimpleStoredMessage mess : listMess) {
            Flags flags = this.getFlags(mess);
            if (!flags.contains(Flags.Flag.DELETED)) continue;
            NodeRef nodeRef = ((AbstractMimeMessage)mess.getMimeMessage()).getMessageInfo().getNodeRef();
            this.serviceRegistry.getFileFolderService().delete(nodeRef);
        }
    }

    @Override
    protected int getFirstUnseenInternal() {
        return 0;
    }

    @Override
    protected String getFullNameInternal() throws FileNotFoundException {
        if (this.rootNodeRef == null) {
            return "";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[getFullNameInternal] entry");
        }
        StringBuilder fullName = new StringBuilder();
        List<FileInfo> pathList = this.serviceRegistry.getFileFolderService().getNamePath(this.rootNodeRef, this.folderInfo.getNodeRef());
        fullName.append("#mail").append('/').append(this.qualifiedMailboxName);
        boolean isFirst = true;
        for (FileInfo path : pathList) {
            fullName.append('/');
            if (isFirst) {
                fullName.append("\"");
                isFirst = false;
                if (this.mountPointName != null) {
                    fullName.append(this.mountPointName);
                    continue;
                }
                fullName.append(path.getName());
                continue;
            }
            fullName.append(path.getName());
        }
        fullName.append("\"");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("fullName: " + fullName));
        }
        return Utf7.encode(fullName.toString(), "X-MODIFIED-UTF-7");
    }

    @Override
    protected SimpleStoredMessage getMessageInternal(long uid) throws MessagingException {
        AbstractMimeMessage mes = (AbstractMimeMessage)this.messages.get(uid).getMimeMessage();
        FileInfo mesInfo = mes.getMessageInfo();
        Date modified = (Date)this.serviceRegistry.getNodeService().getProperty(mesInfo.getNodeRef(), ContentModel.PROP_MODIFIED);
        if (modified != null) {
            CacheItem cached = this.messagesCache.get(uid);
            if (cached != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("retrieved message from cache uid: " + uid));
                }
                if (cached.getModified().equals(modified)) {
                    return cached.getMessage();
                }
            }
            SimpleStoredMessage message = this.createImapMessage(mesInfo, uid, true);
            this.messagesCache.put(uid, new CacheItem(modified, message));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("caching message uid: " + uid + " cacheSize: " + this.messagesCache.size()));
            }
            return message;
        }
        SimpleStoredMessage message = this.createImapMessage(mesInfo, uid, true);
        return message;
    }

    @Override
    protected int getMessageCountInternal() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[getMessageCountInternal] entry");
        }
        if (this.messages.size() == 0 && this.folderInfo != null) {
            List<FileInfo> fileInfos = this.imapService.searchMails(this.folderInfo.getNodeRef(), this.viewMode);
            this.convertToMessages(fileInfos);
        }
        if (logger.isDebugEnabled() && this.folderInfo != null) {
            logger.debug((Object)(this.folderInfo.getName() + " - Messages count:" + this.messages.size()));
        }
        return this.messages.size();
    }

    @Override
    protected long[] getMessageUidsInternal() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[getMessageUidsInternal] entry");
        }
        if (this.messages == null || this.messages.size() == 0 && this.folderInfo != null) {
            List<FileInfo> fileInfos = this.imapService.searchMails(this.folderInfo.getNodeRef(), this.viewMode);
            this.convertToMessages(fileInfos);
        }
        int len = this.messages.size();
        long[] uids = new long[len];
        Set<Long> keys = this.messages.keySet();
        int i = 0;
        for (Long key : keys) {
            uids[i++] = key;
        }
        return uids;
    }

    @Override
    protected List<SimpleStoredMessage> getMessagesInternal() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[getMessagesInternal] entry");
        }
        List<FileInfo> fileInfos = this.imapService.searchMails(this.folderInfo.getNodeRef(), this.viewMode);
        return this.convertToMessages(fileInfos);
    }

    private List<SimpleStoredMessage> convertToMessages(List<FileInfo> fileInfos) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[convertToMessages] entry");
        }
        if (fileInfos == null || fileInfos.size() == 0) {
            logger.debug((Object)"[convertToMessages] - fileInfos is empty or null");
            return Collections.emptyList();
        }
        if (fileInfos.size() != this.messages.size()) {
            for (FileInfo fileInfo : fileInfos) {
                try {
                    Long key = this.getMessageUid(fileInfo);
                    SimpleStoredMessage message = this.createImapMessage(fileInfo, key, false);
                    this.messages.put(key, message);
                    this.msnCache.put(key, this.messages.size());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("[convertToMessages] Message added: " + fileInfo.getName()));
                }
                catch (MessagingException e) {
                    logger.warn((Object)("[convertToMessages] Invalid message! File name:" + fileInfo.getName()), (Throwable)e);
                }
            }
        }
        return new LinkedList<SimpleStoredMessage>(this.messages.values());
    }

    protected SimpleStoredMessage createImapMessage(FileInfo fileInfo, Long key, boolean generateBody) throws MessagingException {
        if (this.serviceRegistry.getNodeService().hasAspect(fileInfo.getNodeRef(), ImapModel.ASPECT_IMAP_CONTENT)) {
            return new SimpleStoredMessage((MimeMessage)new ImapModelMessage(fileInfo, this.serviceRegistry, generateBody), new Date(), key.longValue());
        }
        return new SimpleStoredMessage((MimeMessage)new ContentModelMessage(fileInfo, this.serviceRegistry, generateBody), new Date(), key.longValue());
    }

    @Override
    protected List<SimpleStoredMessage> getMessagesInternal(MsgRangeFilter msgRangeFilter) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[getMessagesInternal] entry");
        }
        if (this.messages == null || this.messages.size() == 0) {
            List<FileInfo> fileInfos = this.imapService.searchMails(this.folderInfo.getNodeRef(), this.viewMode);
            this.convertToMessages(fileInfos);
        }
        ArrayList<SimpleStoredMessage> ret = new ArrayList<SimpleStoredMessage>();
        for (int i = 0; i < this.messages.size(); ++i) {
            if (!msgRangeFilter.includes(i + 1)) continue;
            ret.add(this.messages.get(i));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[getMessagesInternal] exit");
        }
        return ret;
    }

    @Override
    protected int getMsnInternal(long uid) throws FolderException {
        Integer msn = this.msnCache.get(uid);
        if (msn != null) {
            return msn;
        }
        throw new FolderException("No such message.");
    }

    @Override
    protected String getNameInternal() {
        return this.folderName;
    }

    @Override
    protected List<SimpleStoredMessage> getNonDeletedMessagesInternal() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[getNonDeletedMessagesInternal] entry");
        }
        ArrayList<SimpleStoredMessage> result = new ArrayList<SimpleStoredMessage>();
        if (this.messages.size() == 0 && this.folderInfo != null) {
            List<FileInfo> fileInfos = this.imapService.searchMails(this.folderInfo.getNodeRef(), this.viewMode);
            this.convertToMessages(fileInfos);
        }
        Collection<SimpleStoredMessage> values = this.messages.values();
        for (SimpleStoredMessage message : values) {
            if (this.getFlags(message).contains(Flags.Flag.DELETED)) continue;
            result.add(message);
        }
        if (logger.isDebugEnabled() && this.folderInfo != null) {
            logger.debug((Object)(this.folderInfo.getName() + " - Non deleted messages count:" + result.size()));
        }
        return result;
    }

    @Override
    protected Flags getPermanentFlagsInternal() {
        return PERMANENT_FLAGS;
    }

    @Override
    protected int getRecentCountInternal(boolean reset) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[getRecentCountInternal] entry");
        }
        if (this.messages.size() == 0 && this.folderInfo != null) {
            List<FileInfo> fileInfos = this.imapService.searchMails(this.folderInfo.getNodeRef(), this.viewMode);
            this.convertToMessages(fileInfos);
        }
        int count = 0;
        Collection<SimpleStoredMessage> values = this.messages.values();
        for (SimpleStoredMessage message : values) {
            if (!this.getFlags(message).contains(Flags.Flag.RECENT)) continue;
            ++count;
            if (!reset) continue;
            this.imapService.setFlag(((AbstractMimeMessage)message.getMimeMessage()).getMessageInfo(), Flags.Flag.RECENT, false);
        }
        if (logger.isDebugEnabled() && this.folderInfo != null) {
            logger.debug((Object)(this.folderInfo.getName() + " - Recent count: " + count + " reset: " + reset));
        }
        return count;
    }

    @Override
    protected long getUidNextInternal() {
        return this.getUidValidity();
    }

    @Override
    protected long getUidValidityInternal() {
        long modifDate = ((Date)this.serviceRegistry.getNodeService().getProperty(this.folderInfo.getNodeRef(), ContentModel.PROP_MODIFIED)).getTime();
        return (modifDate - 1101765600000L) / 1000L;
    }

    @Override
    protected int getUnseenCountInternal() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[getUnseenCountInternal] entry");
        }
        if (this.messages.size() == 0 && this.folderInfo != null) {
            List<FileInfo> fileInfos = this.imapService.searchMails(this.folderInfo.getNodeRef(), this.viewMode);
            this.convertToMessages(fileInfos);
        }
        int count = 0;
        Collection<SimpleStoredMessage> values = this.messages.values();
        for (SimpleStoredMessage message : values) {
            if (this.getFlags(message).contains(Flags.Flag.SEEN)) continue;
            ++count;
        }
        if (logger.isDebugEnabled() && this.folderInfo != null) {
            logger.debug((Object)(this.folderInfo.getName() + " - Unseen count: " + count));
        }
        return count;
    }

    @Override
    protected void replaceFlagsInternal(Flags flags, long uid, FolderListener silentListener, boolean addUid) throws FolderException, MessagingException {
        int msn = this.getMsn(uid);
        SimpleStoredMessage message = this.messages.get(uid);
        FileInfo fileInfo = ((AbstractMimeMessage)message.getMimeMessage()).getMessageInfo();
        this.imapService.setFlags(fileInfo, MessageFlags.ALL_FLAGS, false);
        this.imapService.setFlags(fileInfo, flags, true);
        message = new SimpleStoredMessage(message.getMimeMessage(), message.getInternalDate(), uid);
        this.messages.put(uid, message);
        Long uidNotification = addUid ? Long.valueOf(uid) : null;
        this.notifyFlagUpdate(msn, message.getFlags(), uidNotification, silentListener);
    }

    @Override
    protected void setFlagsInternal(Flags flags, boolean value, long uid, FolderListener silentListener, boolean addUid) throws MessagingException, FolderException {
        int msn = this.getMsn(uid);
        SimpleStoredMessage message = this.messages.get(uid);
        this.imapService.setFlags(((AbstractMimeMessage)message.getMimeMessage()).getMessageInfo(), flags, value);
        message = new SimpleStoredMessage(message.getMimeMessage(), message.getInternalDate(), uid);
        this.messages.put(uid, message);
        Long uidNotification = null;
        if (addUid) {
            uidNotification = new Long(uid);
        }
        this.notifyFlagUpdate(msn, message.getFlags(), uidNotification, silentListener);
    }

    private long getMessageUid(FileInfo fileInfo) {
        if (this.serviceRegistry.getNodeService().getType(fileInfo.getNodeRef()).equals((Object)ContentModel.TYPE_FOLDER)) {
            long modifDate = ((Date)this.serviceRegistry.getNodeService().getProperty(fileInfo.getNodeRef(), ContentModel.PROP_MODIFIED)).getTime();
            return (modifDate - 1101765600000L) / 1000L;
        }
        return (Long)this.serviceRegistry.getNodeService().getProperty(fileInfo.getNodeRef(), ContentModel.PROP_NODE_DBID);
    }

    private Flags getFlags(SimpleStoredMessage mess) {
        return ((AbstractMimeMessage)mess.getMimeMessage()).getFlags();
    }

    public FileInfo getFolderInfo() {
        return this.folderInfo;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public void setViewMode(AlfrescoImapConst.ImapViewMode viewMode) {
        this.viewMode = viewMode;
    }

    public void setMountPointName(String mountPointName) {
        this.mountPointName = mountPointName;
    }

    public void setMountParent(NodeRef mountParent) {
        this.rootNodeRef = mountParent;
    }

    @Override
    protected boolean isSelectableInternal() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    @Override
    protected boolean isReadOnly() {
        return this.readOnly;
    }

    public AlfrescoImapConst.ImapViewMode getViewMode() {
        return this.viewMode;
    }

    private AbstractMimeMessage createMimeMessageInFolder(FileInfo folderFileInfo, MimeMessage message) throws FileExistsException, FileNotFoundException, IOException, MessagingException {
        String name = "Message_" + GUID.generate();
        FileFolderService fileFolderService = this.serviceRegistry.getFileFolderService();
        FileInfo messageFile = fileFolderService.create(folderFileInfo.getNodeRef(), name, ContentModel.TYPE_CONTENT);
        long newMessageUid = (Long)messageFile.getProperties().get(ContentModel.PROP_NODE_DBID);
        name = "Message_" + newMessageUid + ".eml";
        fileFolderService.rename(messageFile.getNodeRef(), name);
        if (this.extractAttachmentsEnabled) {
            this.extractAttachments(folderFileInfo, messageFile, message);
        }
        return new IncomingImapMessage(messageFile, this.serviceRegistry, message);
    }

    private void extractAttachments(FileInfo parentFolder, FileInfo messageFile, MimeMessage originalMessage) throws IOException, MessagingException {
        NodeService nodeService = this.serviceRegistry.getNodeService();
        FileFolderService fileFolderService = this.serviceRegistry.getFileFolderService();
        String messageName = (String)((Object)nodeService.getProperty(messageFile.getNodeRef(), ContentModel.PROP_NAME));
        String attachmentsFolderName = messageName + "-attachments";
        FileInfo attachmentsFolderFileInfo = null;
        Object content = originalMessage.getContent();
        if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            int n = multipart.getCount();
            for (int i = 0; i < n; ++i) {
                BodyPart part = multipart.getBodyPart(i);
                if (!"attachment".equalsIgnoreCase(part.getDisposition())) continue;
                if (attachmentsFolderFileInfo == null) {
                    attachmentsFolderFileInfo = fileFolderService.create(parentFolder.getNodeRef(), attachmentsFolderName, ContentModel.TYPE_FOLDER);
                    this.serviceRegistry.getNodeService().createAssociation(messageFile.getNodeRef(), attachmentsFolderFileInfo.getNodeRef(), ImapModel.ASSOC_IMAP_ATTACHMENTS_FOLDER);
                }
                this.createAttachment(messageFile, attachmentsFolderFileInfo, (Part)part);
            }
        }
    }

    private void createAttachment(FileInfo messageFile, FileInfo attachmentsFolderFileInfo, Part part) throws MessagingException, IOException {
        String fileName;
        block3: {
            fileName = part.getFileName();
            try {
                fileName = MimeUtility.decodeText((String)fileName);
            }
            catch (UnsupportedEncodingException e) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn((Object)("Cannot decode file name '" + fileName + "'"), (Throwable)e);
            }
        }
        ContentType contentType = new ContentType(part.getContentType());
        FileFolderService fileFolderService = this.serviceRegistry.getFileFolderService();
        List<FileInfo> result = fileFolderService.search(attachmentsFolderFileInfo.getNodeRef(), fileName, false);
        FileInfo attachmentFile = null;
        if (result.size() == 0) {
            FileInfo createdFile = fileFolderService.create(attachmentsFolderFileInfo.getNodeRef(), fileName, ContentModel.TYPE_CONTENT);
            this.serviceRegistry.getNodeService().createAssociation(messageFile.getNodeRef(), createdFile.getNodeRef(), ImapModel.ASSOC_IMAP_ATTACHMENT);
            result.add(createdFile);
        }
        attachmentFile = result.get(0);
        ContentWriter writer = fileFolderService.getWriter(attachmentFile.getNodeRef());
        writer.setMimetype(contentType.getBaseType());
        OutputStream os = writer.getContentOutputStream();
        FileCopyUtils.copy((InputStream)part.getInputStream(), (OutputStream)os);
    }

    static {
        PERMANENT_FLAGS.add(Flags.Flag.ANSWERED);
        PERMANENT_FLAGS.add(Flags.Flag.DELETED);
        PERMANENT_FLAGS.add(Flags.Flag.DRAFT);
        PERMANENT_FLAGS.add(Flags.Flag.FLAGGED);
        PERMANENT_FLAGS.add(Flags.Flag.SEEN);
    }

    class CacheItem {
        private Date modified;
        private SimpleStoredMessage message;

        public CacheItem(Date modified, SimpleStoredMessage message) {
            this.setMessage(message);
            this.setModified(modified);
        }

        public void setModified(Date modified) {
            this.modified = modified;
        }

        public Date getModified() {
            return this.modified;
        }

        public void setMessage(SimpleStoredMessage message) {
            this.message = message;
        }

        public SimpleStoredMessage getMessage() {
            return this.message;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MaxSizeMap<K, V>
    extends LinkedHashMap<K, V> {
        private int maxSize;

        public MaxSizeMap(int initialSize, int maxSize) {
            super(initialSize, 0.75f, true);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            boolean remove = super.size() > this.maxSize;
            return remove;
        }
    }
}

