/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.List;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.importer.FileImporter;
import org.alfresco.repo.importer.FileImporterImpl;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.TestWithUserUtils;
import org.springframework.context.ApplicationContext;

public class FileImporterTest
extends TestCase {
    static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private NodeService nodeService;
    private SearchService searchService;
    private DictionaryService dictionaryService;
    private ContentService contentService;
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PermissionService permissionService;
    private MimetypeService mimetypeService;
    private NamespaceService namespaceService;
    private TransactionService transactionService;
    private ServiceRegistry serviceRegistry;
    private NodeRef rootNodeRef;

    public FileImporterTest() {
    }

    public FileImporterTest(String arg0) {
        super(arg0);
    }

    public void setUp() {
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.nodeService = this.serviceRegistry.getNodeService();
        this.searchService = this.serviceRegistry.getSearchService();
        this.dictionaryService = this.serviceRegistry.getDictionaryService();
        this.contentService = this.serviceRegistry.getContentService();
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("authenticationService");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.permissionService = this.serviceRegistry.getPermissionService();
        this.mimetypeService = this.serviceRegistry.getMimetypeService();
        this.namespaceService = this.serviceRegistry.getNamespaceService();
        this.transactionService = this.serviceRegistry.getTransactionService();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
    }

    private FileImporter createFileImporter(boolean txnPerFile) {
        FileImporterImpl fileImporter = new FileImporterImpl();
        fileImporter.setAuthenticationService(this.authenticationService);
        fileImporter.setContentService(this.contentService);
        fileImporter.setMimetypeService(this.mimetypeService);
        fileImporter.setNodeService(this.nodeService);
        fileImporter.setDictionaryService(this.dictionaryService);
        fileImporter.setTransactionService(this.transactionService);
        fileImporter.setTxnPerFile(txnPerFile);
        return fileImporter;
    }

    public void testCreateFile() throws Exception {
        FileImporter fileImporter = this.createFileImporter(false);
        File file = AbstractContentTransformerTest.loadQuickTestFile("xml");
        fileImporter.loadFile(this.rootNodeRef, file);
    }

    public void testLoadRootNonRecursive1() {
        FileImporter fileImporter = this.createFileImporter(false);
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("quick");
        File rootFile = new File(url.getFile());
        int count = fileImporter.loadFile(this.rootNodeRef, rootFile);
        FileImporterTest.assertEquals((String)"Expected to load a single file", (int)1, (int)count);
    }

    public void testLoadRootNonRecursive2() {
        FileImporter fileImporter = this.createFileImporter(false);
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("quick");
        File root = new File(url.getFile());
        int count = fileImporter.loadFile(this.rootNodeRef, root, null, false);
        FileImporterTest.assertEquals((String)"Expected to load a single file", (int)1, (int)count);
    }

    public void testLoadXMLFiles() {
        FileImporter fileImporter = this.createFileImporter(false);
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("quick");
        XMLFileFilter filter = new XMLFileFilter();
        fileImporter.loadFile(this.rootNodeRef, new File(url.getFile()), filter, true);
    }

    public void testLoadSourceTestResources() {
        FileImporter fileImporter = this.createFileImporter(false);
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("quick");
        QuickFileFilter filter = new QuickFileFilter();
        fileImporter.loadFile(this.rootNodeRef, new File(url.getFile()), filter, true);
    }

    public static final void main(String[] args) throws Exception {
        String userPwd;
        int grandTotal = 0;
        int count = 0;
        File sourceFile = new File(args[2]);
        String baseName = args[3];
        int target = Integer.parseInt(args[4]);
        Boolean txnPerFile = args.length > 5 ? Boolean.parseBoolean(args[5]) : false;
        String userName = args.length > 6 ? args[6] : null;
        String string = userPwd = args.length > 7 ? args[7] : "";
        while (count < target) {
            ++count;
            FileImporterTest test = new FileImporterTest();
            test.setUp();
            test.authenticationComponent.setSystemUserAsCurrentUser();
            TransactionService transactionService = test.serviceRegistry.getTransactionService();
            UserTransaction tx = transactionService.getUserTransaction();
            tx.begin();
            try {
                NodeRef storeRoot;
                List importLocations;
                StoreRef spacesStore = new StoreRef(args[0]);
                if (!test.nodeService.exists(spacesStore)) {
                    test.nodeService.createStore(spacesStore.getProtocol(), spacesStore.getIdentifier());
                }
                if ((importLocations = test.searchService.selectNodes(storeRoot = test.nodeService.getRootNode(spacesStore), args[1], null, (NamespacePrefixResolver)test.namespaceService, false)).size() == 0) {
                    throw new AlfrescoRuntimeException("Root node not found, " + args[1] + " not found in store, " + storeRoot);
                }
                NodeRef importLocation = (NodeRef)importLocations.get(0);
                if (userName != null) {
                    test.permissionService.setPermission(importLocation, userName, "All", true);
                    TestWithUserUtils.authenticateUser(userName, userPwd, test.authenticationService, test.authenticationComponent);
                }
                tx.commit();
                if (!txnPerFile.booleanValue()) {
                    tx = transactionService.getUserTransaction();
                    tx.begin();
                }
                long start = System.nanoTime();
                FileImporter importer = test.createFileImporter(txnPerFile);
                int importCount = importer.loadNamedFile(importLocation, sourceFile, true, String.format("%s-%05d-%s", baseName, count, System.currentTimeMillis()));
                grandTotal += importCount;
                long end = System.nanoTime();
                long first = end - start;
                System.out.println("Created in: " + (double)(end - start) / 1000000.0 + "ms");
                start = System.nanoTime();
                if (!txnPerFile.booleanValue()) {
                    tx.commit();
                }
                end = System.nanoTime();
                long second = end - start;
                System.out.println("Committed in: " + (double)(end - start) / 1000000.0 + "ms");
                double total = (double)(first + second) / 1000000.0;
                System.out.println("Grand Total: " + grandTotal);
                System.out.println("Imported: " + importCount + " files or directories");
                System.out.println("Average: " + (double)importCount / (total / 1000.0) + " files per second");
            }
            catch (Throwable e) {
                tx.rollback();
                e.printStackTrace();
            }
        }
        System.exit(0);
    }

    private static class QuickFileFilter
    implements FileFilter {
        private QuickFileFilter() {
        }

        public boolean accept(File file) {
            return file.getName().startsWith("quick");
        }
    }

    private static class XMLFileFilter
    implements FileFilter {
        private XMLFileFilter() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith(".xml");
        }
    }
}

