/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation.site;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.invitation.site.InviteSender;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.jbpm.JBPMSpringActionHandler;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.jbpm.graph.exe.ExecutionContext;
import org.springframework.beans.factory.BeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendInviteAction
extends JBPMSpringActionHandler {
    private static final long serialVersionUID = 8133039174866049136L;
    private InviteSender inviteSender;
    private NamespaceService namespaceService;

    @Override
    protected void initialiseHandler(BeanFactory factory) {
        Repository repository = (Repository)factory.getBean("repositoryHelper");
        ServiceRegistry services = (ServiceRegistry)factory.getBean("ServiceRegistry");
        MessageService messageService = (MessageService)factory.getBean("messageService");
        this.inviteSender = new InviteSender(services, repository, messageService);
        this.namespaceService = services.getNamespaceService();
    }

    public void execute(ExecutionContext context) throws Exception {
        List<String> propertyNames = Arrays.asList("inwf_inviteeUserName", "inwf_resourceName", "inwf_inviterUserName", "inwf_inviteeUserName", "inwf_inviteeRole", "inwf_inviteeGenPassword", "inwf_resourceName", "inwf_inviteTicket", "inwf_serverPath", "inwf_acceptUrl", "inwf_rejectUrl", "wf_instanceId");
        Map<String, String> properties = this.makePropertiesFromContext(context, propertyNames);
        String packageName = WorkflowModel.ASSOC_PACKAGE.toPrefixString((NamespacePrefixResolver)this.namespaceService).replace(":", "_");
        ScriptNode packageNode = (ScriptNode)context.getVariable(packageName);
        String packageRef = packageNode.getNodeRef().toString();
        properties.put("wf_package", packageRef);
        String instanceName = WorkflowModel.PROP_WORKFLOW_INSTANCE_ID.toPrefixString((NamespacePrefixResolver)this.namespaceService).replace(":", "_");
        String instanceId = (String)context.getVariable(instanceName);
        properties.put("wf_instanceId", instanceId);
        this.inviteSender.sendMail(properties);
    }

    private Map<String, String> makePropertiesFromContext(ExecutionContext context, Collection<String> propertyNames) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (String name : propertyNames) {
            String value = (String)context.getVariable(name);
            props.put(name, value);
        }
        return props;
    }
}

