/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management;

import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SimpleApplicationEventMulticaster;

public class SafeApplicationEventMulticaster
extends SimpleApplicationEventMulticaster
implements ApplicationContextAware {
    private ApplicationContext context;
    private boolean isApplicationStarted;
    private List<ApplicationEvent> queuedEvents = new LinkedList<ApplicationEvent>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        this.setBeanFactory((BeanFactory)applicationContext);
    }

    public void multicastEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent && event.getSource() == this.context) {
            this.isApplicationStarted = true;
            for (ApplicationEvent queuedEvent : this.queuedEvents) {
                super.multicastEvent(queuedEvent);
            }
            this.queuedEvents.clear();
            super.multicastEvent(event);
        } else if (event instanceof ContextClosedEvent && event.getSource() == this.context) {
            this.isApplicationStarted = false;
            super.multicastEvent(event);
        } else if (this.isApplicationStarted) {
            super.multicastEvent(event);
        } else {
            this.queuedEvents.add(event);
        }
    }
}

