/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.node.cleanup.AbstractNodeCleanupWorker;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.apache.commons.lang.mutable.MutableLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeletedNodeCleanupWorker
extends AbstractNodeCleanupWorker {
    private long minPurgeAgeMs = 604800000L;
    private static final int TXN_PURGE_BATCH_SIZE = 50;

    @Override
    protected List<String> doCleanInternal() throws Throwable {
        if (this.minPurgeAgeMs < 0L) {
            return Collections.singletonList("Minimum purge age is negative; purge disabled");
        }
        List<String> purgedNodes = this.purgeOldDeletedNodes(this.minPurgeAgeMs);
        List<String> purgedTxns = this.purgeOldEmptyTransactions(this.minPurgeAgeMs);
        ArrayList<String> allResults = new ArrayList<String>(100);
        allResults.addAll(purgedNodes);
        allResults.addAll(purgedTxns);
        return allResults;
    }

    public void setMinPurgeAgeDays(int minPurgeAgeDays) {
        this.minPurgeAgeMs = (long)minPurgeAgeDays * 24L * 3600L * 1000L;
    }

    private List<String> purgeOldDeletedNodes(long minAge) {
        ArrayList<String> results = new ArrayList<String>(100);
        final long maxCommitTimeMs = System.currentTimeMillis() - minAge;
        RetryingTransactionHelper.RetryingTransactionCallback<Integer> purgeNodesCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

            @Override
            public Integer execute() throws Throwable {
                return DeletedNodeCleanupWorker.this.nodeDAO.purgeNodes(maxCommitTimeMs);
            }
        };
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        txnHelper.setMaxRetries(5);
        txnHelper.setRetryWaitIncrementMs(1000);
        Integer purgeCount = new Integer(0);
        try {
            purgeCount = txnHelper.doInTransaction(purgeNodesCallback, false, true);
            if (purgeCount > 0) {
                String msg = "Purged old nodes: \n   Max commit time: " + maxCommitTimeMs + "\n" + "   Purge count:     " + purgeCount;
                results.add(msg);
            }
        }
        catch (Throwable e) {
            String msg = "Failed to purge nodes.  If the purgable set is too large for the available DB resources \n  then the nodes can be purged manually as well. \n  Set log level to WARN for this class to get exception log: \n   Max commit time: " + maxCommitTimeMs + "\n" + "   Error:       " + e.getMessage();
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)msg, e);
            } else {
                this.logger.error((Object)msg);
            }
            results.add(msg);
        }
        return results;
    }

    private List<String> purgeOldEmptyTransactions(long minAge) {
        Integer purgeCount;
        if (minAge < 0L) {
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>(100);
        final MutableLong minTxnId = new MutableLong(0L);
        final long maxCommitTime = System.currentTimeMillis() - minAge;
        RetryingTransactionHelper.RetryingTransactionCallback<Integer> purgeTxnsCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

            @Override
            public Integer execute() throws Throwable {
                List<Long> txnIds = DeletedNodeCleanupWorker.this.nodeDAO.getTxnsUnused(minTxnId.longValue(), maxCommitTime, 50);
                for (Long txnId : txnIds) {
                    DeletedNodeCleanupWorker.this.nodeDAO.purgeTxn(txnId);
                    if (txnId <= minTxnId.longValue()) continue;
                    minTxnId.setValue(txnId.longValue());
                }
                return txnIds.size();
            }
        };
        do {
            this.refreshLock();
            RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
            txnHelper.setMaxRetries(5);
            txnHelper.setRetryWaitIncrementMs(1000);
            purgeCount = new Integer(0);
            try {
                purgeCount = txnHelper.doInTransaction(purgeTxnsCallback, false, true);
                if (purgeCount <= 0) continue;
                String msg = "Purged old txns: \n   Min txn ID:      " + minTxnId.longValue() + "\n" + "   Batch size:      " + 50 + "\n" + "   Max commit time: " + maxCommitTime + "\n" + "   Purge count:     " + purgeCount;
                results.add(msg);
            }
            catch (Throwable e) {
                String msg = "Failed to purge txns.  Set log level to WARN for this class to get exception log: \n   Min txn ID:      " + minTxnId.longValue() + "\n" + "   Batch size:      " + 50 + "\n" + "   Max commit time: " + maxCommitTime + "\n" + "   Error:       " + e.getMessage();
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)msg, e);
                } else {
                    this.logger.error((Object)msg);
                }
                results.add(msg);
                break;
            }
        } while (purgeCount != 0);
        return results;
    }
}

