/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.ownable.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwnableServiceImpl
implements OwnableService,
InitializingBean,
NodeServicePolicies.OnAddAspectPolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.OnRemoveAspectPolicy,
NodeServicePolicies.OnDeleteNodePolicy {
    private NodeService nodeService;
    private AuthenticationService authenticationService;
    private SimpleCache<NodeRef, String> nodeOwnerCache;
    private PolicyComponent policyComponent;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeOwnerCache(SimpleCache<NodeRef, String> ownerCache) {
        this.nodeOwnerCache = ownerCache;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.nodeService == null) {
            throw new IllegalArgumentException("Property 'nodeService' has not been set");
        }
        if (this.authenticationService == null) {
            throw new IllegalArgumentException("Property 'authenticationService' has not been set");
        }
        if (this.nodeOwnerCache == null) {
            throw new IllegalArgumentException("Property 'nodeOwnerCache' has not been set");
        }
        if (this.policyComponent == null) {
            throw new IllegalArgumentException("Property 'policyComponent' has not been set");
        }
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onAddAspect"), ContentModel.ASPECT_OWNABLE, (Behaviour)new JavaBehaviour(this, "onAddAspect"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), ContentModel.ASPECT_OWNABLE, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onRemoveAspect"), ContentModel.ASPECT_OWNABLE, (Behaviour)new JavaBehaviour(this, "onRemoveAspect"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onDeleteNode"), ContentModel.ASPECT_OWNABLE, (Behaviour)new JavaBehaviour(this, "onDeleteNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onAddAspect"), ContentModel.ASPECT_AUDITABLE, (Behaviour)new JavaBehaviour(this, "onAddAspect"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), ContentModel.ASPECT_AUDITABLE, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onRemoveAspect"), ContentModel.ASPECT_AUDITABLE, (Behaviour)new JavaBehaviour(this, "onRemoveAspect"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onDeleteNode"), ContentModel.ASPECT_AUDITABLE, (Behaviour)new JavaBehaviour(this, "onDeleteNode"));
    }

    @Override
    public String getOwner(NodeRef nodeRef) {
        String userName = (String)this.nodeOwnerCache.get((Serializable)nodeRef);
        if (userName == null) {
            if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_OWNABLE)) {
                userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_OWNER));
            } else if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_AUDITABLE)) {
                userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CREATOR));
            }
            this.nodeOwnerCache.put((Serializable)nodeRef, (Object)userName);
        }
        return userName;
    }

    @Override
    public void setOwner(NodeRef nodeRef, String userName) {
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_OWNABLE)) {
            HashMap<QName, String> properties = new HashMap<QName, String>(1, 1.0f);
            properties.put(ContentModel.PROP_OWNER, userName);
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_OWNABLE, properties);
        } else {
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_OWNER, (Serializable)((Object)userName));
        }
        this.nodeOwnerCache.put((Serializable)nodeRef, (Object)userName);
    }

    @Override
    public void takeOwnership(NodeRef nodeRef) {
        this.setOwner(nodeRef, this.authenticationService.getCurrentUserName());
    }

    @Override
    public boolean hasOwner(NodeRef nodeRef) {
        return this.getOwner(nodeRef) != null;
    }

    @Override
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        this.nodeOwnerCache.remove((Serializable)nodeRef);
    }

    @Override
    public void onRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        this.nodeOwnerCache.remove((Serializable)nodeRef);
    }

    @Override
    public void onDeleteNode(ChildAssociationRef childAssocRef, boolean isNodeArchived) {
        this.nodeOwnerCache.remove((Serializable)childAssocRef.getChildRef());
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        Serializable pa;
        Serializable pb = before.get(ContentModel.PROP_OWNER);
        if (!EqualsHelper.nullSafeEquals((Object)pb, (Object)(pa = after.get(ContentModel.PROP_OWNER)))) {
            this.nodeOwnerCache.remove((Serializable)nodeRef);
            return;
        }
        pb = before.get(ContentModel.PROP_CREATOR);
        if (!EqualsHelper.nullSafeEquals((Object)pb, (Object)(pa = after.get(ContentModel.PROP_CREATOR)))) {
            this.nodeOwnerCache.remove((Serializable)nodeRef);
            return;
        }
    }
}

