/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class BehaviourFilterImpl
implements BehaviourFilter {
    private static final String KEY_GLOBAL_FILTER = "BehaviourFilterImpl.gloalFilter";
    private static final String KEY_CLASS_FILTER = "BehaviourFilterImpl.classFilter";
    private static final String KEY_NODEREF_FILTER = "BehaviourFilterImpl.nodeRefFilter";
    private DictionaryService dictionaryService;
    private TenantService tenantService;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public boolean disableBehaviour(QName className) {
        List classFilters = TransactionalResourceHelper.getList(KEY_CLASS_FILTER);
        boolean alreadyDisabled = classFilters.contains(className);
        if (!alreadyDisabled) {
            classFilters.add(className);
        }
        return alreadyDisabled;
    }

    public boolean disableBehaviour(NodeRef nodeRef, QName className) {
        boolean alreadyDisabled;
        nodeRef = this.tenantService.getName(nodeRef);
        Map nodeRefFilters = TransactionalResourceHelper.getMap(KEY_NODEREF_FILTER);
        ArrayList<QName> classNames = (ArrayList<QName>)nodeRefFilters.get(nodeRef);
        if (classNames == null) {
            classNames = new ArrayList<QName>();
            nodeRefFilters.put(nodeRef, classNames);
        }
        if (!(alreadyDisabled = classNames.contains(className))) {
            classNames.add(className);
        }
        return alreadyDisabled;
    }

    public void enableBehaviour(QName className) {
        List classFilters = TransactionalResourceHelper.getList(KEY_CLASS_FILTER);
        classFilters.remove(className);
    }

    public void enableBehaviour(NodeRef nodeRef, QName className) {
        nodeRef = this.tenantService.getName(nodeRef);
        Map nodeRefFilters = TransactionalResourceHelper.getMap(KEY_NODEREF_FILTER);
        List classNames = (List)nodeRefFilters.get(nodeRef);
        if (classNames != null) {
            classNames.remove(className);
            if (classNames.size() == 0) {
                nodeRefFilters.remove(nodeRef);
            }
        }
    }

    public void enableBehaviours(NodeRef nodeRef) {
        nodeRef = this.tenantService.getName(nodeRef);
        Map nodeRefFilters = TransactionalResourceHelper.getMap(KEY_NODEREF_FILTER);
        nodeRefFilters.remove(nodeRef);
    }

    public void disableAllBehaviours() {
        TransactionalResourceHelper.setBoolean(KEY_GLOBAL_FILTER);
    }

    public void enableAllBehaviours() {
        TransactionalResourceHelper.resetBoolean(KEY_GLOBAL_FILTER);
        Map filters = TransactionalResourceHelper.getMap(KEY_NODEREF_FILTER);
        filters.clear();
    }

    public boolean isEnabled(NodeRef nodeRef, QName className) {
        if (TransactionalResourceHelper.testBoolean(KEY_GLOBAL_FILTER)) {
            return false;
        }
        if (!this.isEnabled(className)) {
            return false;
        }
        nodeRef = this.tenantService.getName(nodeRef);
        Map filters = TransactionalResourceHelper.getMap(KEY_NODEREF_FILTER);
        List nodeClassFilters = (List)filters.get(nodeRef);
        if (nodeClassFilters != null) {
            boolean filtered = nodeClassFilters.contains(className);
            if (filtered) {
                return false;
            }
            for (QName filterName : nodeClassFilters) {
                filtered = this.dictionaryService.isSubClass(className, filterName);
                if (!filtered) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isEnabled(QName className) {
        if (TransactionalResourceHelper.testBoolean(KEY_GLOBAL_FILTER)) {
            return false;
        }
        List<QName> classFilters = TransactionalResourceHelper.getList(KEY_CLASS_FILTER);
        boolean filtered = classFilters.contains(className);
        if (filtered) {
            return false;
        }
        for (QName classFilter : classFilters) {
            filtered = this.dictionaryService.isSubClass(className, classFilter);
            if (!filtered) continue;
            return false;
        }
        return true;
    }

    public boolean isActivated() {
        List classFilters = TransactionalResourceHelper.getList(KEY_CLASS_FILTER);
        Map nodeRefFilters = TransactionalResourceHelper.getMap(KEY_NODEREF_FILTER);
        boolean globalFlag = TransactionalResourceHelper.testBoolean(KEY_GLOBAL_FILTER);
        return !classFilters.isEmpty() || !nodeRefFilters.isEmpty() || globalFlag;
    }
}

