/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.IOException;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.OpenBitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterIndexReaderByStringId
extends FilterIndexReader {
    private static Log s_logger = LogFactory.getLog(FilterIndexReaderByStringId.class);
    OpenBitSet deletedDocuments;
    private String id;

    public FilterIndexReaderByStringId(String id, IndexReader reader, Set<String> deletions, boolean deleteNodesOnly) {
        super(reader);
        reader.incRef();
        this.id = id;
        this.deletedDocuments = new OpenBitSet((long)reader.maxDoc());
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Applying deletions FOR " + id + " (the index ito which these are applied is the previous one ...)"));
        }
        try {
            if (!deleteNodesOnly) {
                for (String stringRef : deletions) {
                    TermDocs td = reader.termDocs(new Term("ID", stringRef));
                    while (td.next()) {
                        this.deletedDocuments.set((long)td.doc());
                    }
                }
            } else {
                IndexSearcher searcher = new IndexSearcher(reader);
                for (String stringRef : deletions) {
                    TermQuery query = new TermQuery(new Term("ID", stringRef));
                    Hits hits = searcher.search((Query)query);
                    if (hits.length() <= 0) continue;
                    for (int i = 0; i < hits.length(); ++i) {
                        Document doc = hits.doc(i);
                        if (doc.getField("ISCONTAINER") != null) continue;
                        this.deletedDocuments.set((long)hits.id(i));
                    }
                }
            }
        }
        catch (IOException e) {
            s_logger.error((Object)("Error initialising " + id));
            throw new AlfrescoRuntimeException("Failed to construct filtering index reader", (Throwable)e);
        }
    }

    protected void doClose() throws IOException {
        this.in.decRef();
    }

    public int numDocs() {
        return super.numDocs() - (int)this.deletedDocuments.cardinality();
    }

    public TermDocs termDocs() throws IOException {
        return new FilterTermDocs(this.id, super.termDocs(), this.deletedDocuments);
    }

    public TermPositions termPositions() throws IOException {
        return new FilterTermPositions(this.id, super.termPositions(), this.deletedDocuments);
    }

    public static class FilterTermPositions
    extends FilterTermDocs
    implements TermPositions {
        TermPositions tp;

        public FilterTermPositions(String id, TermPositions in, OpenBitSet deletedDocuements) {
            super(id, (TermDocs)in, deletedDocuements);
            this.tp = in;
        }

        public int nextPosition() throws IOException {
            return this.tp.nextPosition();
        }

        public byte[] getPayload(byte[] data, int offset) throws IOException {
            return this.tp.getPayload(data, offset);
        }

        public int getPayloadLength() {
            return this.tp.getPayloadLength();
        }

        public boolean isPayloadAvailable() {
            return this.tp.isPayloadAvailable();
        }
    }

    public static class FilterTermDocs
    implements TermDocs {
        OpenBitSet deletedDocuments;
        protected TermDocs in;
        String id;

        public FilterTermDocs(String id, TermDocs in, OpenBitSet deletedDocuments) {
            this.in = in;
            this.deletedDocuments = deletedDocuments;
        }

        public void seek(Term term) throws IOException {
            this.in.seek(term);
        }

        public void seek(TermEnum termEnum) throws IOException {
            this.in.seek(termEnum);
        }

        public int doc() {
            return this.in.doc();
        }

        public int freq() {
            return this.in.freq();
        }

        public boolean next() throws IOException {
            try {
                while (this.in.next()) {
                    if (this.deletedDocuments.get(this.in.doc())) continue;
                    return true;
                }
                return false;
            }
            catch (IOException ioe) {
                s_logger.error((Object)("Error reading docs for " + this.id));
                throw ioe;
            }
        }

        public int read(int[] docs, int[] freqs) throws IOException {
            int[] innerDocs = new int[docs.length];
            int[] innerFreq = new int[docs.length];
            int count = this.in.read(innerDocs, innerFreq);
            if (count == 0) {
                return 0;
            }
            if (this.allDeleted(innerDocs, count)) {
                return this.read(docs, freqs);
            }
            int insertPosition = 0;
            for (int i = 0; i < count; ++i) {
                if (this.deletedDocuments.get(innerDocs[i])) continue;
                docs[insertPosition] = innerDocs[i];
                freqs[insertPosition] = innerFreq[i];
                ++insertPosition;
            }
            return insertPosition;
        }

        private boolean allDeleted(int[] docs, int fillSize) {
            for (int i = 0; i < fillSize; ++i) {
                if (this.deletedDocuments.get(docs[i])) continue;
                return false;
            }
            return true;
        }

        public boolean skipTo(int i) throws IOException {
            boolean result = this.in.skipTo(i);
            if (!result) {
                return false;
            }
            if (this.deletedDocuments.get(this.in.doc())) {
                return this.skipTo(i);
            }
            return true;
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

