/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Set;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationManager;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AbstractAuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.authentication.NTLMMode;
import org.alfresco.repo.security.authentication.ntlm.NLTMAuthenticator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationComponentImpl
extends AbstractAuthenticationComponent
implements NLTMAuthenticator {
    private MutableAuthenticationDao authenticationDao;
    AuthenticationManager authenticationManager;

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuthenticationDao(MutableAuthenticationDao authenticationDao) {
        this.authenticationDao = authenticationDao;
    }

    @Override
    protected void authenticateImpl(String userName, char[] password) throws AuthenticationException {
        try {
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userName, (Object)new String(password));
            this.authenticationManager.authenticate((Authentication)authentication);
            this.setCurrentUser(userName);
        }
        catch (net.sf.acegisecurity.AuthenticationException ae) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            out.println(ae.toString());
            ae.printStackTrace(out);
            out.close();
            throw new AuthenticationException(sw.toString());
        }
    }

    @Override
    protected UserDetails getUserDetails(String userName) {
        return this.authenticationDao.loadUserByUsername(userName);
    }

    @Override
    public String getMD4HashedPassword(String userName) {
        return this.authenticationDao.getMD4HashedPassword(userName);
    }

    @Override
    public Authentication authenticate(Authentication token) throws AuthenticationException {
        throw new AlfrescoRuntimeException("Authentication via token not supported");
    }

    @Override
    public NTLMMode getNTLMMode() {
        return NTLMMode.MD4_PROVIDER;
    }

    @Override
    protected boolean implementationAllowsGuestLogin() {
        return true;
    }

    @Override
    public Set<String> getDefaultAdministratorUserNames() {
        return Collections.singleton(AuthenticationUtil.getAdminUserName());
    }
}

