/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.content.MimetypeMap;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.magick.ImageResizeOptions;
import org.alfresco.repo.content.transform.magick.ImageTransformationOptions;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.repo.thumbnail.ThumbnailRegistry;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.thumbnail.ThumbnailException;
import org.alfresco.service.cmr.thumbnail.ThumbnailParentAssociationDetails;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.BaseAlfrescoSpringTest;

public class ThumbnailServiceImplTest
extends BaseAlfrescoSpringTest {
    private RenditionService renditionService;
    private ThumbnailService thumbnailService;
    private ScriptService scriptService;
    private MimetypeMap mimetypeMap;
    private NodeRef folder;

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.renditionService = (RenditionService)this.applicationContext.getBean("RenditionService");
        this.thumbnailService = (ThumbnailService)this.applicationContext.getBean("ThumbnailService");
        this.mimetypeMap = (MimetypeMap)this.applicationContext.getBean("mimetypeService");
        this.scriptService = (ScriptService)this.applicationContext.getBean("ScriptService");
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        folderProps.put(ContentModel.PROP_NAME, "testFolder");
        this.folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
    }

    private void checkTransformer() {
        ContentTransformer transformer = this.contentService.getImageTransformer();
        ThumbnailServiceImplTest.assertNotNull((String)"No transformer returned for 'getImageTransformer'", (Object)transformer);
        ImageTransformationOptions imageTransformationOptions = new ImageTransformationOptions();
        if (!transformer.isTransformable("image/jpeg", "image/jpeg", imageTransformationOptions)) {
            ThumbnailServiceImplTest.fail((String)"Image transformer is not working.  Please check your image conversion command setup.");
        }
    }

    public void testCreateRenditionThumbnailFromImage() throws Exception {
        QName qname = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"doclib");
        ThumbnailDefinition details = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition(qname.getLocalName());
        ThumbnailServiceImplTest.assertEquals((String)"doclib", (String)details.getName());
        ThumbnailServiceImplTest.assertEquals((String)"image/png", (String)details.getMimetype());
        ThumbnailServiceImplTest.assertEquals((String)"alfresco/thumbnail/thumbnail_placeholder_doclib.png", (String)details.getPlaceHolderResourcePath());
        this.checkTransformer();
        NodeRef jpgOrig = this.createOriginalContent(this.folder, "image/jpeg");
        NodeRef thumbnail0 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/jpeg", details.getTransformationOptions(), "doclib");
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail0);
        this.checkRenditioned(jpgOrig, "doclib");
        this.checkRendition("doclib", thumbnail0);
        this.outputThumbnailTempContentLocation(thumbnail0, "jpg", "doclib test");
    }

    public void testCreateRenditionThumbnailFromPdf() throws Exception {
        QName qname = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"doclib");
        ThumbnailDefinition details = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition(qname.getLocalName());
        ThumbnailServiceImplTest.assertEquals((String)"doclib", (String)details.getName());
        ThumbnailServiceImplTest.assertEquals((String)"image/png", (String)details.getMimetype());
        ThumbnailServiceImplTest.assertEquals((String)"alfresco/thumbnail/thumbnail_placeholder_doclib.png", (String)details.getPlaceHolderResourcePath());
        this.checkTransformer();
        NodeRef pdfOrig = this.createOriginalContent(this.folder, "application/pdf");
        NodeRef thumbnail0 = this.thumbnailService.createThumbnail(pdfOrig, ContentModel.PROP_CONTENT, "image/jpeg", details.getTransformationOptions(), "doclib");
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail0);
        this.checkRenditioned(pdfOrig, "doclib");
        this.checkRendition("doclib", thumbnail0);
        this.outputThumbnailTempContentLocation(thumbnail0, "jpg", "doclib test");
    }

    public void testCreateThumbnailFromImage() throws Exception {
        this.checkTransformer();
        NodeRef jpgOrig = this.createOriginalContent(this.folder, "image/jpeg");
        NodeRef gifOrig = this.createOriginalContent(this.folder, "image/gif");
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setWidth(64);
        imageResizeOptions.setHeight(64);
        imageResizeOptions.setResizeToThumbnail(true);
        ImageTransformationOptions imageTransformationOptions = new ImageTransformationOptions();
        imageTransformationOptions.setResizeOptions(imageResizeOptions);
        NodeRef thumbnail1 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/jpeg", imageTransformationOptions, "small");
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail1);
        this.checkRenditioned(jpgOrig, "small");
        this.checkRendition("small", thumbnail1);
        this.outputThumbnailTempContentLocation(thumbnail1, "jpg", "small - 64x64, marked as thumbnail");
        ImageResizeOptions imageResizeOptions2 = new ImageResizeOptions();
        imageResizeOptions2.setWidth(64);
        imageResizeOptions2.setHeight(64);
        imageResizeOptions2.setMaintainAspectRatio(false);
        ImageTransformationOptions imageTransformationOptions2 = new ImageTransformationOptions();
        imageTransformationOptions2.setResizeOptions(imageResizeOptions2);
        NodeRef thumbnail2 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/jpeg", imageTransformationOptions2, "small2");
        this.checkRenditioned(jpgOrig, "small2");
        this.checkRendition("small2", thumbnail2);
        this.outputThumbnailTempContentLocation(thumbnail2, "jpg", "small2 - 64x64, aspect not maintained");
        ImageResizeOptions imageResizeOptions3 = new ImageResizeOptions();
        imageResizeOptions3.setWidth(50);
        imageResizeOptions3.setHeight(50);
        imageResizeOptions3.setPercentResize(true);
        ImageTransformationOptions imageTransformationOptions3 = new ImageTransformationOptions();
        imageTransformationOptions3.setResizeOptions(imageResizeOptions3);
        NodeRef thumbnail3 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/jpeg", imageTransformationOptions3, "half");
        this.checkRenditioned(jpgOrig, "half");
        this.checkRendition("half", thumbnail3);
        this.outputThumbnailTempContentLocation(thumbnail3, "jpg", "half - 50%x50%");
        ImageResizeOptions imageResizeOptions4 = new ImageResizeOptions();
        imageResizeOptions4.setWidth(50);
        imageResizeOptions4.setHeight(50);
        imageResizeOptions4.setPercentResize(true);
        ImageTransformationOptions imageTransformationOptions4 = new ImageTransformationOptions();
        imageTransformationOptions4.setResizeOptions(imageResizeOptions4);
        NodeRef thumbnail4 = this.thumbnailService.createThumbnail(gifOrig, ContentModel.PROP_CONTENT, "image/jpeg", imageTransformationOptions4, "half2");
        this.checkRenditioned(gifOrig, "half2");
        this.checkRendition("half2", thumbnail4);
        this.outputThumbnailTempContentLocation(thumbnail4, "jpg", "half2 - 50%x50%, from gif");
    }

    public void testDuplicationNames() throws Exception {
        this.checkTransformer();
        NodeRef jpgOrig = this.createOriginalContent(this.folder, "image/jpeg");
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setWidth(64);
        imageResizeOptions.setHeight(64);
        imageResizeOptions.setResizeToThumbnail(true);
        ImageTransformationOptions imageTransformationOptions = new ImageTransformationOptions();
        imageTransformationOptions.setResizeOptions(imageResizeOptions);
        NodeRef thumbnail1 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/jpeg", imageTransformationOptions, "small");
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail1);
        this.checkRenditioned(jpgOrig, "small");
        this.checkRendition("small", thumbnail1);
        try {
            this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/jpeg", imageTransformationOptions, "small");
            ThumbnailServiceImplTest.fail((String)"A duplicate exception should have been raised");
        }
        catch (ThumbnailException exception) {
            // empty catch block
        }
    }

    public void testThumbnailUpdate() throws Exception {
        this.checkTransformer();
        NodeRef jpgOrig = this.createOriginalContent(this.folder, "image/jpeg");
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setWidth(64);
        imageResizeOptions.setHeight(64);
        imageResizeOptions.setResizeToThumbnail(true);
        ImageTransformationOptions imageTransformationOptions = new ImageTransformationOptions();
        imageTransformationOptions.setResizeOptions(imageResizeOptions);
        NodeRef thumbnail1 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/jpeg", imageTransformationOptions, "small");
        ThumbnailServiceImplTest.assertEquals((Object)ContentModel.TYPE_THUMBNAIL, (Object)this.nodeService.getType(thumbnail1));
        this.thumbnailService.updateThumbnail(thumbnail1, imageTransformationOptions);
        ThumbnailServiceImplTest.assertEquals((Object)ContentModel.TYPE_THUMBNAIL, (Object)this.nodeService.getType(thumbnail1));
    }

    public void testGetThumbnailByName() throws Exception {
        this.checkTransformer();
        NodeRef jpgOrig = this.createOriginalContent(this.folder, "image/jpeg");
        NodeRef result1 = this.thumbnailService.getThumbnailByName(jpgOrig, ContentModel.PROP_CONTENT, "small");
        ThumbnailServiceImplTest.assertNull((String)"The thumbnail 'small' should have been missing", (Object)result1);
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setWidth(64);
        imageResizeOptions.setHeight(64);
        imageResizeOptions.setResizeToThumbnail(true);
        ImageTransformationOptions imageTransformationOptions = new ImageTransformationOptions();
        imageTransformationOptions.setResizeOptions(imageResizeOptions);
        this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/jpeg", imageTransformationOptions, "small");
        NodeRef result2 = this.thumbnailService.getThumbnailByName(jpgOrig, ContentModel.PROP_CONTENT, "small");
        ThumbnailServiceImplTest.assertNotNull((Object)result2);
        this.checkRendition("small", result2);
        NodeRef result3 = this.thumbnailService.getThumbnailByName(jpgOrig, ContentModel.PROP_CONTENT, "anotherone");
        ThumbnailServiceImplTest.assertNull((String)"The thumbnail 'anotherone' should have been missing", (Object)result3);
    }

    private void checkRenditioned(NodeRef thumbnailed, String assocName) {
        ThumbnailServiceImplTest.assertTrue((String)"Renditioned aspect should have been applied", (boolean)this.nodeService.hasAspect(thumbnailed, RenditionModel.ASPECT_RENDITIONED));
        if (assocName != null) {
            List assocs = this.nodeService.getChildAssocs(thumbnailed, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)assocName));
            ThumbnailServiceImplTest.assertNotNull((Object)assocs);
            ThumbnailServiceImplTest.assertEquals((int)1, (int)assocs.size());
        }
    }

    private void checkRendition(String thumbnailName, NodeRef thumbnail) {
        ThumbnailServiceImplTest.assertTrue((String)"Thumbnail should have been a rendition", (boolean)this.renditionService.isRendition(thumbnail));
        if (thumbnailName != null) {
            ThumbnailServiceImplTest.assertEquals((Object)thumbnailName, (Object)this.nodeService.getProperty(thumbnail, ContentModel.PROP_NAME));
        }
        ThumbnailServiceImplTest.assertEquals((Object)ContentModel.PROP_CONTENT, (Object)this.nodeService.getProperty(thumbnail, ContentModel.PROP_CONTENT_PROPERTY_NAME));
        ThumbnailServiceImplTest.assertEquals((String)"The thumbnail node should be of type cm:thumbnail!", (Object)ContentModel.TYPE_THUMBNAIL, (Object)this.nodeService.getType(thumbnail));
        ThumbnailServiceImplTest.assertEquals((Object)thumbnailName, (Object)this.nodeService.getProperty(thumbnail, ContentModel.PROP_THUMBNAIL_NAME));
    }

    private void outputThumbnailTempContentLocation(NodeRef thumbnail, String ext, String message) throws IOException {
        File tempFile = File.createTempFile("thumbnailServiceImpTest", "." + ext);
        ContentReader reader = this.contentService.getReader(thumbnail, ContentModel.PROP_CONTENT);
        reader.getContent(tempFile);
        System.out.println(message + ": " + tempFile.getPath());
    }

    private NodeRef createOriginalContent(NodeRef parentFolder, String mimetype) throws IOException {
        String ext = this.mimetypeMap.getExtension(mimetype);
        File origFile = AbstractContentTransformerTest.loadQuickTestFile(ext);
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NAME, "origional." + ext);
        NodeRef node = this.nodeService.createNode(parentFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("original." + ext)), ContentModel.TYPE_CONTENT, props).getChildRef();
        ContentWriter writer = this.contentService.getWriter(node, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(mimetype);
        writer.setEncoding("UTF-8");
        writer.putContent(origFile);
        return node;
    }

    public void testAutoUpdate() throws Exception {
        this.checkTransformer();
        final NodeRef jpgOrig = this.createOriginalContent(this.folder, "image/jpeg");
        ThumbnailDefinition details = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition("medium");
        NodeRef thumbnail = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, details.getMimetype(), details.getTransformationOptions(), details.getName());
        this.setComplete();
        this.endTransaction();
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                String ext = ThumbnailServiceImplTest.this.mimetypeMap.getExtension("image/jpeg");
                File origFile = AbstractContentTransformerTest.loadQuickTestFile(ext);
                ContentWriter writer = ThumbnailServiceImplTest.this.contentService.getWriter(jpgOrig, ContentModel.PROP_CONTENT, true);
                writer.putContent(origFile);
                return null;
            }
        });
    }

    public void testHTMLToImageAndSWF() throws Exception {
        ContentReader reader;
        NodeRef thumb;
        NodeRef nodeRef = this.createOriginalContent(this.folder, "text/html");
        ThumbnailDefinition def = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition("medium");
        ContentTransformer transformer = this.contentService.getTransformer("text/html", def.getMimetype(), def.getTransformationOptions());
        if (transformer != null) {
            thumb = this.thumbnailService.createThumbnail(nodeRef, ContentModel.PROP_CONTENT, def.getMimetype(), def.getTransformationOptions(), def.getName());
            ThumbnailServiceImplTest.assertNotNull((Object)thumb);
            reader = this.contentService.getReader(thumb, ContentModel.PROP_CONTENT);
            ThumbnailServiceImplTest.assertNotNull((Object)reader);
            ThumbnailServiceImplTest.assertEquals((String)def.getMimetype(), (String)reader.getMimetype());
            ThumbnailServiceImplTest.assertTrue((reader.getSize() != 0L ? 1 : 0) != 0);
        }
        def = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition("webpreview");
        if (transformer != null) {
            thumb = this.thumbnailService.createThumbnail(nodeRef, ContentModel.PROP_CONTENT, def.getMimetype(), def.getTransformationOptions(), def.getName());
            ThumbnailServiceImplTest.assertNotNull((Object)thumb);
            reader = this.contentService.getReader(thumb, ContentModel.PROP_CONTENT);
            ThumbnailServiceImplTest.assertNotNull((Object)reader);
            ThumbnailServiceImplTest.assertEquals((String)def.getMimetype(), (String)reader.getMimetype());
            ThumbnailServiceImplTest.assertTrue((reader.getSize() != 0L ? 1 : 0) != 0);
        }
    }

    public void testThumbnailServiceCreateApi() throws Exception {
        HashMap<QName, String> folderProps = new HashMap<QName, String>();
        folderProps.put(ContentModel.PROP_NAME, "otherTestFolder");
        NodeRef otherFolder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"otherTestFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        this.checkTransformer();
        NodeRef jpgOrig = this.createOriginalContent(this.folder, "image/jpeg");
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setWidth(64);
        imageResizeOptions.setHeight(64);
        imageResizeOptions.setResizeToThumbnail(true);
        ImageTransformationOptions imageTransformationOptions = new ImageTransformationOptions();
        imageTransformationOptions.setResizeOptions(imageResizeOptions);
        NodeRef thumbnail1 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/jpeg", imageTransformationOptions, "smallJpeg");
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail1);
        this.checkRenditioned(jpgOrig, "smallJpeg");
        this.checkRendition("smallJpeg", thumbnail1);
        this.outputThumbnailTempContentLocation(thumbnail1, "jpg", "smallJpeg - 64x64, marked as thumbnail");
        thumbnail1 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/png", imageTransformationOptions, "smallPng");
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail1);
        this.checkRenditioned(jpgOrig, "smallPng");
        this.checkRendition("smallPng", thumbnail1);
        this.outputThumbnailTempContentLocation(thumbnail1, "png", "smallPng - 64x64, marked as thumbnail");
        ContentIOException x = null;
        try {
            imageTransformationOptions.setCommandOptions("-noSuchOption");
            thumbnail1 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/png", imageTransformationOptions, "smallCO");
        }
        catch (ContentIOException ciox) {
            x = ciox;
            ciox.printStackTrace();
        }
        ThumbnailServiceImplTest.assertNotNull((String)"Expected exception from ImageMagick due to invalid option", (Object)((Object)x));
        imageTransformationOptions.setCommandOptions("");
        ThumbnailParentAssociationDetails tpad = new ThumbnailParentAssociationDetails(otherFolder, QName.createQName((String)"http://www.alfresco.org/model/rendition/1.0", (String)"foo"), QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"bar"));
        thumbnail1 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/png", imageTransformationOptions, "targetDetails", tpad);
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail1);
        this.checkRenditioned(jpgOrig, "targetDetails");
        this.checkRendition("targetDetails", thumbnail1);
        this.outputThumbnailTempContentLocation(thumbnail1, "png", "targetDetails - 64x64, marked as thumbnail");
        thumbnail1 = this.thumbnailService.createThumbnail(jpgOrig, ContentModel.PROP_CONTENT, "image/png", imageTransformationOptions, null);
        ThumbnailServiceImplTest.assertNotNull((Object)thumbnail1);
        this.checkRenditioned(jpgOrig, null);
        this.checkRendition(null, thumbnail1);
        this.outputThumbnailTempContentLocation(thumbnail1, "png", "'null' - 64x64, marked as thumbnail");
    }

    public void testRegistry() {
        ThumbnailRegistry thumbnailRegistry = this.thumbnailService.getThumbnailRegistry();
        List<ThumbnailDefinition> defs = thumbnailRegistry.getThumbnailDefinitions("text/html");
        System.out.println("Definitions ...");
        for (ThumbnailDefinition def : defs) {
            System.out.println("Thumbnail Available: " + def.getName());
        }
    }

    public void testJSAPI() throws Exception {
        NodeRef jpgOrig = this.createOriginalContent(this.folder, "image/jpeg");
        NodeRef gifOrig = this.createOriginalContent(this.folder, "image/gif");
        NodeRef pdfOrig = this.createOriginalContent(this.folder, "application/pdf");
        NodeRef docOrig = this.createOriginalContent(this.folder, "application/msword");
        HashMap<String, Object> model = new HashMap<String, Object>(2);
        model.put("jpgOrig", jpgOrig);
        model.put("gifOrig", gifOrig);
        model.put("pdfOrig", pdfOrig);
        model.put("docOrig", docOrig);
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/thumbnail/script/test_thumbnailAPI.js");
        this.scriptService.executeScript(location, model);
    }
}

