/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import java.util.ArrayList;
import java.util.Map;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class AlfrescoTransactionSupportTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private ServiceRegistry serviceRegistry;
    TransactionService transactionService;

    public void setUp() throws Exception {
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.transactionService = this.serviceRegistry.getTransactionService();
    }

    public void testTransactionId() throws Exception {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction txn = transactionService.getUserTransaction();
        AlfrescoTransactionSupportTest.assertNull((String)"Thread shouldn't have a txn ID", (Object)AlfrescoTransactionSupport.getTransactionId());
        AlfrescoTransactionSupportTest.assertEquals((String)"No transaction start time expected", (long)-1L, (long)AlfrescoTransactionSupport.getTransactionStartTime());
        txn.begin();
        String txnId = AlfrescoTransactionSupport.getTransactionId();
        AlfrescoTransactionSupportTest.assertNotNull((String)"Expected thread to have a txn id", (Object)txnId);
        long txnStartTime = AlfrescoTransactionSupport.getTransactionStartTime();
        AlfrescoTransactionSupportTest.assertTrue((String)"Expected a transaction start time", (txnStartTime > 0L ? 1 : 0) != 0);
        String txnIdCheck = AlfrescoTransactionSupport.getTransactionId();
        AlfrescoTransactionSupportTest.assertEquals((String)"Transaction ID changed on same thread", (String)txnId, (String)txnIdCheck);
        long txnStartTimeCheck = AlfrescoTransactionSupport.getTransactionStartTime();
        AlfrescoTransactionSupportTest.assertEquals((String)"Transaction start time changed on same thread", (long)txnStartTime, (long)txnStartTimeCheck);
        UserTransaction txnInner = transactionService.getNonPropagatingUserTransaction();
        String txnIdInner = AlfrescoTransactionSupport.getTransactionId();
        AlfrescoTransactionSupportTest.assertEquals((String)"Inner transaction not started, so txn ID should not change", (String)txnId, (String)txnIdInner);
        long txnStartTimeInner = AlfrescoTransactionSupport.getTransactionStartTime();
        AlfrescoTransactionSupportTest.assertEquals((String)"Inner transaction not started, so txn start time should not change", (long)txnStartTime, (long)txnStartTimeInner);
        txnInner.begin();
        txnIdInner = AlfrescoTransactionSupport.getTransactionId();
        AlfrescoTransactionSupportTest.assertNotSame((String)"Inner txn ID must be different from outer txn ID", (Object)txnIdInner, (Object)txnId);
        txnStartTimeInner = AlfrescoTransactionSupport.getTransactionStartTime();
        AlfrescoTransactionSupportTest.assertTrue((String)"Inner transaction start time should be greater or equal (accuracy) to the outer's", (txnStartTime <= txnStartTimeInner ? 1 : 0) != 0);
        txnInner.rollback();
        txnIdCheck = AlfrescoTransactionSupport.getTransactionId();
        AlfrescoTransactionSupportTest.assertEquals((String)"Txn ID not popped inner txn completion", (String)txnId, (String)txnIdCheck);
        txn.rollback();
        AlfrescoTransactionSupportTest.assertNull((String)"Thread shouldn't have a txn ID after rollback", (Object)AlfrescoTransactionSupport.getTransactionId());
        txn = transactionService.getUserTransaction();
        txn.begin();
        txnIdCheck = AlfrescoTransactionSupport.getTransactionId();
        AlfrescoTransactionSupportTest.assertNotSame((String)"New transaction has same ID", (Object)txnId, (Object)txnIdCheck);
        txn.rollback();
        AlfrescoTransactionSupportTest.assertNull((String)"Thread shouldn't have a txn ID after rollback", (Object)AlfrescoTransactionSupport.getTransactionId());
    }

    public void testListener() throws Exception {
        final ArrayList strings = new ArrayList(1);
        TransactionListener listener = new TransactionListener(){

            public void flush() {
                strings.add("flush");
            }

            public void beforeCommit(boolean readOnly) {
                strings.add("beforeCommit");
            }

            public void beforeCompletion() {
                strings.add("beforeCompletion");
            }

            public void afterCommit() {
                strings.add("afterCommit");
            }

            public void afterRollback() {
                strings.add("afterRollback");
            }
        };
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        AlfrescoTransactionSupport.bindListener(listener);
        txn.commit();
        AlfrescoTransactionSupportTest.assertTrue((String)"beforeCommit not called on listener", (boolean)strings.contains("beforeCommit"));
        AlfrescoTransactionSupportTest.assertTrue((String)"beforeCompletion not called on listener", (boolean)strings.contains("beforeCompletion"));
        AlfrescoTransactionSupportTest.assertTrue((String)"afterCommit not called on listener", (boolean)strings.contains("afterCommit"));
    }

    public void testPreCommitListenerBinding() throws Exception {
        String beforeCommit = "beforeCommit";
        String afterCommitInner = "afterCommit - inner";
        String afterCommitOuter = "afterCommit = outer";
        final ArrayList<String> testList = new ArrayList<String>(1);
        testList.add("beforeCommit");
        testList.add("afterCommit - inner");
        testList.add("afterCommit = outer");
        final TransactionListenerAdapter listener = new TransactionListenerAdapter(){

            public int hashCode() {
                return 100;
            }

            public void beforeCommit(boolean readOnly) {
                testList.remove("beforeCommit");
                TransactionListenerAdapter postCommitListener = new TransactionListenerAdapter(){

                    public void afterCommit() {
                        testList.remove("afterCommit - inner");
                    }
                };
                AlfrescoTransactionSupport.bindListener(postCommitListener);
            }

            public void afterCommit() {
                testList.remove("afterCommit = outer");
            }
        };
        final TransactionListenerAdapter dummyListener = new TransactionListenerAdapter(){

            public int hashCode() {
                return 200;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Object> bindWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                AlfrescoTransactionSupport.bindListener(dummyListener);
                AlfrescoTransactionSupport.bindListener(listener);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(bindWork);
        AlfrescoTransactionSupportTest.assertTrue((String)("Expected callbacks not all processed: " + testList), (testList.size() == 0 ? 1 : 0) != 0);
    }

    public void testReadWriteStateRetrieval() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<AlfrescoTransactionSupport.TxnReadState> getReadStateWork = new RetryingTransactionHelper.RetryingTransactionCallback<AlfrescoTransactionSupport.TxnReadState>(){

            @Override
            public AlfrescoTransactionSupport.TxnReadState execute() throws Exception {
                return AlfrescoTransactionSupport.getTransactionReadState();
            }
        };
        AlfrescoTransactionSupport.TxnReadState checkTxnReadState = AlfrescoTransactionSupport.getTransactionReadState();
        AlfrescoTransactionSupportTest.assertEquals((String)"Expected 'no transaction'", (Object)((Object)AlfrescoTransactionSupport.TxnReadState.TXN_NONE), (Object)((Object)checkTxnReadState));
        checkTxnReadState = this.transactionService.getRetryingTransactionHelper().doInTransaction(getReadStateWork, true);
        AlfrescoTransactionSupportTest.assertEquals((String)"Expected 'read-only transaction'", (Object)((Object)AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY), (Object)((Object)checkTxnReadState));
        checkTxnReadState = this.transactionService.getRetryingTransactionHelper().doInTransaction(getReadStateWork, false);
        AlfrescoTransactionSupportTest.assertEquals((String)"Expected 'read-write transaction'", (Object)((Object)AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE), (Object)((Object)checkTxnReadState));
    }

    public void testResourceHelper() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> testWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                Map<String, String> map = TransactionalResourceHelper.getMap("abc");
                Assert.assertNotNull((String)"Map not created", map);
                map.put("1", "ONE");
                Map mapCheck = TransactionalResourceHelper.getMap("abc");
                Assert.assertTrue((String)"Same map not retrieved", (map == mapCheck ? 1 : 0) != 0);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(testWork);
    }
}

