/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer.manifest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.transfer.manifest.ManifestAccessControl;
import org.alfresco.repo.transfer.manifest.ManifestPermission;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestHeader;
import org.alfresco.repo.transfer.manifest.TransferManifestNode;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.repo.transfer.manifest.TransferManifestWriter;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.namespace.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.extensions.surf.util.Base64;
import org.springframework.extensions.surf.util.ISO8601DateFormat;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLTransferManifestWriter
implements TransferManifestWriter {
    private XMLWriter writer;
    final AttributesImpl EMPTY_ATTRIBUTES = new AttributesImpl();
    final String PREFIX = "xfer";

    @Override
    public void startTransferManifest(Writer writer) throws SAXException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setIndentSize(3);
        format.setEncoding("UTF-8");
        this.writer = new XMLWriter(writer, format);
        this.writer.startDocument();
        this.writer.startPrefixMapping("xfer", "http://www.alfresco.org/model/transfer/1.0");
        this.writer.startPrefixMapping("cm", "http://www.alfresco.org/model/content/1.0");
        this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "transferManifest", "xfer:transferManifest", (Attributes)this.EMPTY_ATTRIBUTES);
    }

    @Override
    public void endTransferManifest() throws SAXException {
        this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "transferManifest", "xfer:transferManifest");
        this.writer.endPrefixMapping("xfer");
        this.writer.endDocument();
    }

    @Override
    public void writeTransferManifestHeader(TransferManifestHeader header) throws SAXException {
        if (header.getCreatedDate() != null) {
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "transferManifestHeader", "xfer:transferManifestHeader", (Attributes)this.EMPTY_ATTRIBUTES);
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "createdDate", "xfer:createdDate", (Attributes)this.EMPTY_ATTRIBUTES);
            this.writeDate(header.getCreatedDate());
            this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "createdDate", "xfer:createdDate");
        }
        if (header.getNodeCount() > 0) {
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "nodeCount", "xfer:nodeCount", (Attributes)this.EMPTY_ATTRIBUTES);
            char[] nodeCountChars = Integer.toString(header.getNodeCount()).toCharArray();
            this.writer.characters(nodeCountChars, 0, nodeCountChars.length);
            this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "nodeCount", "xfer:nodeCount");
        }
        if (header.getRepositoryId() != null) {
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "repositoryId", "xfer:repositoryId", (Attributes)this.EMPTY_ATTRIBUTES);
            char[] repositoryId = header.getRepositoryId().toCharArray();
            this.writer.characters(repositoryId, 0, repositoryId.length);
            this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "repositoryId", "xfer:repositoryId");
        }
        if (header.isSync()) {
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "sync", "xfer:sync", (Attributes)this.EMPTY_ATTRIBUTES);
            this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "sync", "xfer:sync");
        }
        if (header.isReadOnly()) {
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "readOnly", "xfer:readOnly", (Attributes)this.EMPTY_ATTRIBUTES);
            this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "readOnly", "xfer:readOnly");
        }
        this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "transferManifestHeader", "xfer:transferManifestHeader");
    }

    public void writeTransferManifestNode(TransferManifestDeletedNode node) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("uri", "nodeRef", "nodeRef", "String", node.getNodeRef().toString());
        this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "node", "xfer:deletedNode", (Attributes)attributes);
        if (node.getPrimaryParentAssoc() != null) {
            this.writePrimaryParent(node.getPrimaryParentAssoc(), node.getParentPath());
        }
        this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "node", "xfer:deletedNode");
    }

    @Override
    public void writeTransferManifestNode(TransferManifestNode node) throws SAXException {
        if (node instanceof TransferManifestDeletedNode) {
            TransferManifestDeletedNode node2 = (TransferManifestDeletedNode)node;
            this.writeTransferManifestNode(node2);
        } else if (node instanceof TransferManifestNormalNode) {
            TransferManifestNormalNode node2 = (TransferManifestNormalNode)node;
            this.writeTransferManifestNode(node2);
        } else {
            throw new IllegalArgumentException("Unexpected type" + node.getClass().getName());
        }
    }

    public void writeTransferManifestNode(TransferManifestNormalNode node) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("uri", "nodeRef", "nodeRef", "String", node.getNodeRef().toString());
        attributes.addAttribute("uri", "nodeType", "nodeType", "String", this.formatQName(node.getType()));
        this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "node", "xfer:node", (Attributes)attributes);
        if (node.getPrimaryParentAssoc() != null) {
            this.writePrimaryParent(node.getPrimaryParentAssoc(), node.getParentPath());
        }
        this.writeAspects(node.getAspects());
        this.writeProperties(node.getProperties());
        this.writeParentAssocs(node.getParentAssocs());
        this.writeChildAssocs(node.getChildAssocs());
        this.writeTargetAssocs(node.getTargetAssocs());
        this.writeSourceAssocs(node.getSourceAssocs());
        this.writeAccessControl(node.getAccessControl());
        this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "node", "xfer:node");
    }

    private void writeProperties(Map<QName, Serializable> properties) throws SAXException {
        this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "properties", "xfer:properties", (Attributes)this.EMPTY_ATTRIBUTES);
        if (properties != null) {
            for (Map.Entry<QName, Serializable> entry : properties.entrySet()) {
                this.writeProperty(entry.getKey(), entry.getValue());
            }
        }
        this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "properties", "xfer:properties");
    }

    private void writeProperty(QName propertyName, Serializable value) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "name", "name", "String", this.formatQName(propertyName));
        this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "property", "xfer:property", (Attributes)attributes);
        if (value == null) {
            this.writeNullValue();
        } else if (value instanceof ContentData) {
            ContentData data = (ContentData)value;
            AttributesImpl dataAttributes = new AttributesImpl();
            dataAttributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "contentURL", "contentURL", "String", data.getContentUrl());
            dataAttributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "mimetype", "mimetype", "String", data.getMimetype());
            dataAttributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "size", "size", "String", Long.toString(data.getSize()));
            dataAttributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "encoding", "encoding", "String", data.getEncoding());
            dataAttributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "locale", "locale", "String", data.getLocale().toString());
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "content", "xfer:content", (Attributes)dataAttributes);
            this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "content", "xfer:content");
        } else if (value instanceof Collection) {
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "values", "xfer:values", (Attributes)this.EMPTY_ATTRIBUTES);
            int index = 0;
            for (Object valueInCollection : (Collection)((Object)value)) {
                this.writeValue((Serializable)valueInCollection);
                ++index;
            }
            this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "values", "xfer:values");
        } else if (value instanceof MLText) {
            MLText mltext = (MLText)value;
            for (Map.Entry entry : mltext.entrySet()) {
                this.writeMLValue((Locale)entry.getKey(), (Serializable)entry.getValue());
            }
        } else {
            this.writeValue(value);
        }
        this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "property", "xfer:property");
    }

    private void writeValue(Serializable value) throws SAXException {
        try {
            AttributesImpl valueAttributes = new AttributesImpl();
            valueAttributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "className", "className", "String", value.getClass().getName());
            String strValue = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "value", "xfer:value", (Attributes)valueAttributes);
            this.writer.characters(strValue.toCharArray(), 0, strValue.length());
            this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "value", "xfer:value");
        }
        catch (TypeConversionException e) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(value);
                oos.close();
                byte[] ba = bos.toByteArray();
                String s = new String(Base64.encodeBytes((byte[])ba));
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "className", "className", "String", value.getClass().getName());
                attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "encoding", "encoding", "String", "base64/ObjectOutputStream");
                this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "serializedValue", "xfer:serializedValue", (Attributes)attributes);
                this.writer.startCDATA();
                this.writer.characters(s.toCharArray(), 0, s.length());
                this.writer.endCDATA();
                this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "serializedValue", "xfer:serializedValue");
            }
            catch (IOException err) {
                throw new TransferException("Unable to write property value", err);
            }
        }
    }

    private void writeNullValue() throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "nullValue", "xfer:nullValue", (Attributes)attributes);
        this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "nullValue", "xfer:nullValue");
    }

    private void writeMLValue(Locale locale, Serializable value) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "locale", "locale", "String", locale.toString());
        this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "mlvalue", "xfer:mlvalue", (Attributes)attributes);
        String strValue = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
        this.writer.characters(strValue.toCharArray(), 0, strValue.length());
        this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "mlvalue", "xfer:mlvalue");
    }

    private void writeAspects(Set<QName> aspects) throws SAXException {
        this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "aspects", "xfer:aspects", (Attributes)this.EMPTY_ATTRIBUTES);
        if (aspects != null) {
            for (QName aspect : aspects) {
                this.writeAspect(aspect);
            }
        }
        this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "aspects", "xfer:aspects");
    }

    private void writeAspect(QName aspect) throws SAXException {
        this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "aspect", "xfer:aspect", (Attributes)this.EMPTY_ATTRIBUTES);
        String name = this.formatQName(aspect);
        this.writer.characters(name.toCharArray(), 0, name.length());
        this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "aspect", "xfer:aspect");
    }

    private void writeDate(Date date) throws SAXException {
        String dates = ISO8601DateFormat.format((Date)date);
        this.writer.characters(dates.toCharArray(), 0, dates.length());
    }

    private String formatQName(QName qname) {
        return qname.toString();
    }

    private void writePrimaryParent(ChildAssociationRef parentAssoc, Path parentPath) throws SAXException {
        this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "primaryParent", "xfer:primaryParent", (Attributes)this.EMPTY_ATTRIBUTES);
        this.writeParentAssoc(parentAssoc);
        this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "primaryPath", "xfer:primaryPath", (Attributes)this.EMPTY_ATTRIBUTES);
        if (parentPath != null) {
            String path = parentPath.toString();
            this.writer.characters(path.toCharArray(), 0, path.length());
        }
        this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "primaryPath", "xfer:primaryPath");
        this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "primaryParent", "xfer:primaryParent");
    }

    private void writeParentAssocs(List<ChildAssociationRef> refs) throws SAXException {
        if (refs != null) {
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "parentAssocs", "xfer:parentAssocs", (Attributes)this.EMPTY_ATTRIBUTES);
            for (ChildAssociationRef assoc : refs) {
                this.writeParentAssoc(assoc);
            }
            this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "parentAssocs", "xfer:parentAssocs");
        }
    }

    private void writeChildAssocs(List<ChildAssociationRef> refs) throws SAXException {
        if (refs != null) {
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "childAssocs", "xfer:childAssocs", (Attributes)this.EMPTY_ATTRIBUTES);
            for (ChildAssociationRef assoc : refs) {
                this.writeChildAssoc(assoc);
            }
            this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "childAssocs", "xfer:childAssocs");
        }
    }

    private void writeParentAssoc(ChildAssociationRef assoc) throws SAXException {
        if (assoc != null) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "from", "from", "String", assoc.getParentRef().toString());
            attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "type", "type", "String", this.formatQName(assoc.getTypeQName()));
            attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "type", "isPrimary", "Boolean", assoc.isPrimary() ? "true" : "false");
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "parentAssoc", "xfer:parentAssoc", (Attributes)attributes);
            String name = this.formatQName(assoc.getQName());
            this.writer.characters(name.toCharArray(), 0, name.length());
            assoc.isPrimary();
            this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "parentAssoc", "xfer:parentAssoc");
        }
    }

    private void writeChildAssoc(ChildAssociationRef assoc) throws SAXException {
        if (assoc != null) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "to", "to", "String", assoc.getChildRef().toString());
            attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "type", "type", "String", this.formatQName(assoc.getTypeQName()));
            attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "type", "isPrimary", "Boolean", assoc.isPrimary() ? "true" : "false");
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "childAssoc", "xfer:childAssoc", (Attributes)attributes);
            String name = this.formatQName(assoc.getQName());
            this.writer.characters(name.toCharArray(), 0, name.length());
            this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "childAssoc", "xfer:childAssoc");
        }
    }

    private void writeTargetAssocs(List<AssociationRef> refs) throws SAXException {
        if (refs != null) {
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "targetAssocs", "xfer:targetAssocs", (Attributes)this.EMPTY_ATTRIBUTES);
            for (AssociationRef assoc : refs) {
                this.writeAssoc(assoc);
            }
            this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "targetAssocs", "xfer:targetAssocs");
        }
    }

    private void writeSourceAssocs(List<AssociationRef> refs) throws SAXException {
        if (refs != null) {
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "sourceAssocs", "xfer:sourceAssocs", (Attributes)this.EMPTY_ATTRIBUTES);
            for (AssociationRef assoc : refs) {
                this.writeAssoc(assoc);
            }
            this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "sourceAssocs", "xfer:sourceAssocs");
        }
    }

    private void writeAssoc(AssociationRef ref) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "source", "source", "String", ref.getSourceRef().toString());
        attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "target", "target", "String", ref.getTargetRef().toString());
        attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "type", "type", "String", this.formatQName(ref.getTypeQName()));
        this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "assoc", "xfer:assoc", (Attributes)attributes);
        this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "assoc", "xfer:assoc");
    }

    private void writeAccessControl(ManifestAccessControl acl) throws SAXException {
        if (acl != null) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "isInherited", "isInherited", "boolean", acl.isInherited() ? "true" : "false");
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "acl", "xfer:acl", (Attributes)attributes);
            if (acl.getPermissions() != null) {
                for (ManifestPermission permission : acl.getPermissions()) {
                    this.writePermission(permission);
                }
            }
            this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "acl", "xfer:acl");
        }
    }

    private void writePermission(ManifestPermission permission) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "status", "status", "String", permission.getStatus());
        attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "authority", "authority", "String", permission.getAuthority());
        attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "permission", "permission", "String", permission.getPermission());
        this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "permission", "xfer:permission", (Attributes)attributes);
        this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "permission", "xfer:permission");
    }
}

