/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.view.ImporterException;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.io.ClassPathResource;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowDeployer
extends AbstractLifecycleBean {
    private static Log logger = LogFactory.getLog((String)"org.alfresco.repo.workflow");
    public static final String ENGINE_ID = "engineId";
    public static final String LOCATION = "location";
    public static final String MIMETYPE = "mimetype";
    public static final String REDEPLOY = "redeploy";
    private boolean allowWrite = true;
    private TransactionService transactionService;
    private WorkflowService workflowService;
    private AuthenticationContext authenticationContext;
    private DictionaryDAO dictionaryDAO;
    private List<Properties> workflowDefinitions;
    private List<String> models = new ArrayList<String>();
    private List<String> resourceBundles = new ArrayList<String>();
    private TenantAdminService tenantAdminService;
    private TenantService tenantService;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private SearchService searchService;
    private RepositoryLocation repoWorkflowDefsLocation;
    public static final String CRITERIA_ALL = "/*";
    public static final String defaultSubtypeOfWorkflowDefinitionType = "subtypeOf('bpm:workflowDefinition')";

    public void setAllowWrite(boolean write) {
        this.allowWrite = write;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setWorkflowDefinitions(List<Properties> workflowDefinitions) {
        this.workflowDefinitions = workflowDefinitions;
    }

    public void setModels(List<String> modelResources) {
        this.models = modelResources;
    }

    public void setLabels(List<String> labels) {
        this.resourceBundles = labels;
    }

    public List<Properties> getWorkflowDefinitions() {
        return this.workflowDefinitions;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setRepositoryWorkflowDefsLocations(RepositoryLocation repoWorkflowDefsLocation) {
        this.repoWorkflowDefsLocation = repoWorkflowDefsLocation;
    }

    public void init() {
        if (this.transactionService == null) {
            throw new ImporterException("Transaction Service must be provided");
        }
        if (this.authenticationContext == null) {
            throw new ImporterException("Authentication Component must be provided");
        }
        if (this.workflowService == null) {
            throw new ImporterException("Workflow Service must be provided");
        }
        String currentUser = this.authenticationContext.getCurrentUserName();
        if (currentUser == null) {
            this.authenticationContext.setSystemUserAsCurrentUser();
        }
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        try {
            StoreRef storeRef;
            NodeRef rootNode;
            List nodeRefs;
            userTransaction.begin();
            if (this.models != null && this.resourceBundles != null && (this.models.size() > 0 || this.resourceBundles.size() > 0)) {
                DictionaryBootstrap dictionaryBootstrap = new DictionaryBootstrap();
                dictionaryBootstrap.setDictionaryDAO(this.dictionaryDAO);
                dictionaryBootstrap.setTenantService(this.tenantService);
                dictionaryBootstrap.setModels(this.models);
                dictionaryBootstrap.setLabels(this.resourceBundles);
                dictionaryBootstrap.bootstrap();
            }
            if (this.workflowDefinitions != null) {
                for (Properties workflowDefinition : this.workflowDefinitions) {
                    String engineId = workflowDefinition.getProperty(ENGINE_ID);
                    if (engineId == null || engineId.length() == 0) {
                        throw new WorkflowException("Workflow Engine Id must be provided");
                    }
                    String location = workflowDefinition.getProperty(LOCATION);
                    if (location == null || location.length() == 0) {
                        throw new WorkflowException("Workflow definition location must be provided");
                    }
                    Boolean redeploy = Boolean.valueOf(workflowDefinition.getProperty(REDEPLOY));
                    String mimetype = workflowDefinition.getProperty(MIMETYPE);
                    ClassPathResource workflowResource = new ClassPathResource(location);
                    if (!this.allowWrite) {
                        logger.warn((Object)("Repository is in read-only mode; not deploying workflow " + location));
                        continue;
                    }
                    if (!redeploy.booleanValue() && this.workflowService.isDefinitionDeployed(engineId, workflowResource.getInputStream(), mimetype)) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Workflow deployer: Definition '" + location + "' already deployed"));
                        continue;
                    }
                    WorkflowDeployment deployment = this.workflowService.deployDefinition(engineId, workflowResource.getInputStream(), mimetype);
                    if (!logger.isInfoEnabled()) continue;
                    logger.info((Object)("Workflow deployer: Deployed process definition '" + deployment.definition.title + "' (version " + deployment.definition.version + ") from '" + location + "' with " + deployment.problems.length + " problems"));
                }
            }
            if (this.repoWorkflowDefsLocation != null && (nodeRefs = this.searchService.selectNodes(rootNode = this.nodeService.getRootNode(storeRef = this.repoWorkflowDefsLocation.getStoreRef()), this.repoWorkflowDefsLocation.getPath() + CRITERIA_ALL + "[" + defaultSubtypeOfWorkflowDefinitionType + "]", null, (NamespacePrefixResolver)this.namespaceService, false)).size() > 0) {
                for (NodeRef nodeRef : nodeRefs) {
                    this.deploy(nodeRef, false);
                }
            }
            userTransaction.commit();
        }
        catch (Throwable e) {
            try {
                if (userTransaction != null) {
                    userTransaction.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new AlfrescoRuntimeException("Workflow deployment failed", e);
        }
        finally {
            if (currentUser == null) {
                this.authenticationContext.clearCurrentSecurityContext();
            }
        }
    }

    public void deploy(NodeRef nodeRef, boolean redeploy) {
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            Boolean value = (Boolean)this.nodeService.getProperty(nodeRef, WorkflowModel.PROP_WORKFLOW_DEF_DEPLOYED);
            if (value != null && value.booleanValue()) {
                if (!redeploy && this.workflowService.isDefinitionDeployed(nodeRef)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Workflow deployer: Definition '" + nodeRef + "' already deployed"));
                    }
                } else {
                    WorkflowDeployment deployment = this.workflowService.deployDefinition(nodeRef);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Workflow deployer: Deployed process definition '" + deployment.definition.title + "' (version " + deployment.definition.version + ") from '" + nodeRef + "' with " + deployment.problems.length + " problems"));
                    }
                    if (deployment != null) {
                        WorkflowDefinition def = deployment.definition;
                        Map props = this.nodeService.getProperties(nodeRef);
                        props.put(WorkflowModel.PROP_WORKFLOW_DEF_NAME, def.getName());
                        if (deployment.problems.length > 0) {
                            for (String problem : deployment.problems) {
                                logger.warn((Object)problem);
                            }
                        }
                        this.nodeService.setProperties(nodeRef, props);
                    }
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Workflow deployer: Definition '" + nodeRef + "' not deployed since it is a working copy"));
        }
    }

    public void undeploy(NodeRef nodeRef) {
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            String defName = (String)((Object)this.nodeService.getProperty(nodeRef, WorkflowModel.PROP_WORKFLOW_DEF_NAME));
            if (defName != null) {
                List<WorkflowDefinition> defs = this.workflowService.getAllDefinitionsByName(defName);
                for (WorkflowDefinition def : defs) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Undeploying workflow '" + defName + "' ..."));
                    }
                    this.workflowService.undeployDefinition(def.getId());
                    if (!logger.isInfoEnabled()) continue;
                    logger.info((Object)("... undeployed '" + def.getId() + "' v" + def.getVersion()));
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Workflow deployer: Definition '" + nodeRef + "' not undeployed since it is a working copy"));
        }
    }

    protected void onBootstrap(ApplicationEvent event) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                WorkflowDeployer.this.init();
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        this.tenantAdminService.register(this);
    }

    protected void onShutdown(ApplicationEvent event) {
    }
}

