/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.json;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.json.JsonSerializer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlfrescoJsonSerializer {
    private final NamespaceService namespaceService;
    private final Map<Class<?>, JsonSerializer<?, ?>> serializers = new HashMap();

    public AlfrescoJsonSerializer(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void register(Class<?> clazz, JsonSerializer<?, ?> serializer) {
        this.serializers.put(clazz, serializer);
    }

    public Object getJsonValue(Object value) throws JSONException {
        if (value instanceof Date) {
            return this.getJsonDate((Date)value);
        }
        if (value instanceof QName) {
            return this.getJsonQName((QName)value);
        }
        if (value instanceof NodeRef) {
            return value.toString();
        }
        if (value instanceof Collection) {
            return this.getJsonArray((Collection)value);
        }
        if (value instanceof Map) {
            return this.getJsonObject((Map)value);
        }
        return value;
    }

    private JSONObject getJsonObject(Map<?, ?> map) throws JSONException {
        JSONObject object = new JSONObject();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = this.getJsonKey(entry.getKey());
            Object value = this.getJsonValue(entry.getValue());
            object.put(key, value);
        }
        return object;
    }

    private String getJsonKey(Object key) {
        if (key instanceof QName) {
            return this.getJsonQName((QName)key);
        }
        return key.toString();
    }

    private String getJsonQName(QName name) {
        String nameString = name.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        return nameString.replaceFirst(":", "_");
    }

    private JSONObject getJsonDate(Date date) throws JSONException {
        JSONObject isoDate = new JSONObject();
        isoDate.put("iso8601", (Object)ISO8601DateFormat.format((Date)date));
        return isoDate;
    }

    private JSONArray getJsonArray(Collection<?> values) throws JSONException {
        JSONArray array = new JSONArray();
        for (Object val : values) {
            array.put(this.getJsonValue(val));
        }
        return array;
    }
}

