/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.cas.ticketvalidator;

import edu.yale.its.tp.cas.client.ProxyTicketValidator;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.AuthenticationServiceException;
import net.sf.acegisecurity.BadCredentialsException;
import net.sf.acegisecurity.providers.cas.TicketResponse;
import net.sf.acegisecurity.providers.cas.ticketvalidator.AbstractTicketValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CasProxyTicketValidator
extends AbstractTicketValidator {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$providers$cas$ticketvalidator$CasProxyTicketValidator == null ? (class$net$sf$acegisecurity$providers$cas$ticketvalidator$CasProxyTicketValidator = CasProxyTicketValidator.class$("net.sf.acegisecurity.providers.cas.ticketvalidator.CasProxyTicketValidator")) : class$net$sf$acegisecurity$providers$cas$ticketvalidator$CasProxyTicketValidator));
    private String proxyCallbackUrl;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$cas$ticketvalidator$CasProxyTicketValidator;

    public void setProxyCallbackUrl(String proxyCallbackUrl) {
        this.proxyCallbackUrl = proxyCallbackUrl;
    }

    public String getProxyCallbackUrl() {
        return this.proxyCallbackUrl;
    }

    public TicketResponse confirmTicketValid(String serviceTicket) throws AuthenticationException {
        ProxyTicketValidator pv = new ProxyTicketValidator();
        pv.setCasValidateUrl(super.getCasValidate());
        pv.setServiceTicket(serviceTicket);
        pv.setService(super.getServiceProperties().getService());
        if (super.getServiceProperties().isSendRenew()) {
            logger.warn((Object)"The current CAS ProxyTicketValidator does not support the 'renew' property. The ticket cannot be validated as having been issued by a 'renew' authentication. It is expected this will be corrected in a future version of CAS' ProxyTicketValidator.");
        }
        if (this.proxyCallbackUrl != null && !"".equals(this.proxyCallbackUrl)) {
            pv.setProxyCallbackUrl(this.proxyCallbackUrl);
        }
        return this.validateNow(pv);
    }

    protected TicketResponse validateNow(ProxyTicketValidator pv) throws AuthenticationServiceException, BadCredentialsException {
        try {
            pv.validate();
        }
        catch (Exception internalProxyTicketValidatorProblem) {
            throw new AuthenticationServiceException(internalProxyTicketValidatorProblem.getMessage());
        }
        if (!pv.isAuthenticationSuccesful()) {
            throw new BadCredentialsException(pv.getErrorCode() + ": " + pv.getErrorMessage());
        }
        return new TicketResponse(pv.getUser(), pv.getProxyList(), pv.getPgtIou());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

