/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.dao.cache;

import java.io.Serializable;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.dao.UserCache;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.Assert;

public class EhCacheBasedUserCache
implements UserCache,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$providers$dao$cache$EhCacheBasedUserCache == null ? (class$net$sf$acegisecurity$providers$dao$cache$EhCacheBasedUserCache = EhCacheBasedUserCache.class$("net.sf.acegisecurity.providers.dao.cache.EhCacheBasedUserCache")) : class$net$sf$acegisecurity$providers$dao$cache$EhCacheBasedUserCache));
    private Cache cache;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$dao$cache$EhCacheBasedUserCache;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    public UserDetails getUserFromCache(String username) {
        Element element = null;
        try {
            element = this.cache.get((Serializable)((Object)username));
        }
        catch (CacheException cacheException) {
            throw new DataRetrievalFailureException("Cache failure: " + cacheException.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache hit: " + (element != null) + "; username: " + username));
        }
        if (element == null) {
            return null;
        }
        return (UserDetails)element.getValue();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cache, (String)"cache mandatory");
    }

    public void putUserInCache(UserDetails user) {
        Element element = new Element((Serializable)((Object)user.getUsername()), (Serializable)user);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache put: " + element.getKey()));
        }
        this.cache.put(element);
    }

    public void removeUserFromCache(UserDetails user) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache remove: " + user.getUsername()));
        }
        this.removeUserFromCache(user.getUsername());
    }

    public void removeUserFromCache(String username) {
        this.cache.remove((Serializable)((Object)username));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

