/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.deployment.transformers;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.alfresco.deployment.DeploymentTransportInputFilter;
import org.alfresco.deployment.DeploymentTransportOutputFilter;
import org.alfresco.deployment.impl.DeploymentException;

public class SampleEncryptionTransformer
implements DeploymentTransportInputFilter,
DeploymentTransportOutputFilter {
    private String cipherName = "PBEWithMD5AndDES";
    private byte[] salt = new byte[]{-94, 107, 18, 102, 116, 83, 49, -103};
    private int iterationCount = 19;
    private String password = "Alfresco";

    private SecretKey getSecretKey() throws InvalidKeySpecException, NoSuchAlgorithmException {
        PBEKeySpec keySpec = new PBEKeySpec(this.password.toCharArray(), this.salt, this.getIterationCount());
        SecretKey key = SecretKeyFactory.getInstance(this.cipherName).generateSecret(keySpec);
        return key;
    }

    public OutputStream addFilter(OutputStream out, String path, String mimeType, String encoding) {
        try {
            SecretKey key = this.getSecretKey();
            Cipher ecipher = Cipher.getInstance(key.getAlgorithm());
            PBEParameterSpec paramSpec = new PBEParameterSpec(this.salt, this.getIterationCount());
            ecipher.init(1, (Key)key, paramSpec);
            CipherOutputStream cos = new CipherOutputStream(out, ecipher);
            return new EncryptedOutputStream(cos, this.password);
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to initialise encryption cipherName:" + this.cipherName, e);
        }
    }

    public InputStream addFilter(InputStream in, String path, String mimeType, String encoding) {
        try {
            SecretKey key = this.getSecretKey();
            Cipher dcipher = Cipher.getInstance(key.getAlgorithm());
            PBEParameterSpec paramSpec = new PBEParameterSpec(this.salt, this.getIterationCount());
            dcipher.init(2, (Key)key, paramSpec);
            CipherInputStream cis = new CipherInputStream(in, dcipher);
            return new EncryptedInputStream(cis, this.password);
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to initialise decryption cipherName:" + this.cipherName, e);
        }
    }

    public void setCipherName(String cipherName) {
        this.cipherName = cipherName;
    }

    public String getCipherName() {
        return this.cipherName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    private class EncryptedInputStream
    extends FilterInputStream {
        private String password;
        private boolean firstRx;

        protected EncryptedInputStream(InputStream in, String password) {
            super(in);
            this.firstRx = true;
            this.password = password;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.extractPassword();
            return this.in.read(b, off, len);
        }

        public int read(byte[] b) throws IOException {
            this.extractPassword();
            return this.in.read(b);
        }

        public int read() throws IOException {
            this.extractPassword();
            return this.in.read();
        }

        private void extractPassword() throws IOException {
            if (this.firstRx) {
                this.firstRx = false;
                byte[] expectedPassword = this.password.getBytes("UTF-8");
                byte[] gotPassword = new byte[expectedPassword.length];
                this.in.read(gotPassword);
                if (!Arrays.equals(expectedPassword, gotPassword)) {
                    throw new IOException("Password error");
                }
            }
        }
    }

    private class EncryptedOutputStream
    extends FilterOutputStream {
        private boolean firstSend;
        private String password;

        public EncryptedOutputStream(OutputStream out, String password) {
            super(out);
            this.firstSend = true;
            this.password = password;
        }

        public void write(byte[] b) throws IOException {
            this.injectPassword();
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.injectPassword();
            this.out.write(b, off, len);
        }

        public void write(int b) throws IOException {
            this.injectPassword();
            this.out.write(b);
        }

        private void injectPassword() throws IOException {
            if (this.firstSend) {
                this.firstSend = false;
                this.out.write(this.password.getBytes("UTF-8"));
            }
        }
    }
}

