/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.AuthenticatedStateCommand;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;

class StatusCommand
extends AuthenticatedStateCommand {
    public static final String NAME = "STATUS";
    public static final String ARGS = "<mailbox> ( <status-data-item>+ )";
    private static final String MESSAGES = "MESSAGES";
    private static final String RECENT = "RECENT";
    private static final String UIDNEXT = "UIDNEXT";
    private static final String UIDVALIDITY = "UIDVALIDITY";
    private static final String UNSEEN = "UNSEEN";
    private StatusCommandParser parser = new StatusCommandParser();

    StatusCommand() {
    }

    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException {
        String mailboxName = this.parser.mailbox(request);
        StatusDataItems statusDataItems = this.parser.statusDataItems(request);
        this.parser.endLine(request);
        MailFolder folder = this.getMailbox(mailboxName, session, true);
        StringBuffer buffer = new StringBuffer("\"" + mailboxName + "\"");
        buffer.append(" ");
        buffer.append("(");
        if (statusDataItems.messages) {
            buffer.append(MESSAGES);
            buffer.append(" ");
            buffer.append(folder.getMessageCount());
            buffer.append(" ");
        }
        if (statusDataItems.recent) {
            buffer.append(RECENT);
            buffer.append(" ");
            buffer.append(folder.getRecentCount(false));
            buffer.append(" ");
        }
        if (statusDataItems.uidNext) {
            buffer.append(UIDNEXT);
            buffer.append(" ");
            buffer.append(folder.getUidNext());
            buffer.append(" ");
        }
        if (statusDataItems.uidValidity) {
            buffer.append(UIDVALIDITY);
            buffer.append(" ");
            buffer.append(folder.getUidValidity());
            buffer.append(" ");
        }
        if (statusDataItems.unseen) {
            buffer.append(UNSEEN);
            buffer.append(" ");
            buffer.append(folder.getUnseenCount());
            buffer.append(" ");
        }
        if (buffer.charAt(buffer.length() - 1) == ' ') {
            buffer.setLength(buffer.length() - 1);
        }
        buffer.append(')');
        response.commandResponse(this, buffer.toString());
        session.unsolicitedResponses(response);
        response.commandComplete(this);
    }

    public String getName() {
        return NAME;
    }

    public String getArgSyntax() {
        return ARGS;
    }

    private class StatusCommandParser
    extends CommandParser {
        private StatusCommandParser() {
        }

        StatusDataItems statusDataItems(ImapRequestLineReader request) throws ProtocolException {
            StatusDataItems items = new StatusDataItems();
            request.nextWordChar();
            this.consumeChar(request, '(');
            CommandParser.NoopCharValidator validator = new CommandParser.NoopCharValidator();
            String nextWord = this.consumeWord(request, validator);
            while (!nextWord.endsWith(")")) {
                this.addItem(nextWord, items);
                nextWord = this.consumeWord(request, validator);
            }
            if (nextWord.length() > 1) {
                this.addItem(nextWord.substring(0, nextWord.length() - 1), items);
            }
            return items;
        }

        private void addItem(String nextWord, StatusDataItems items) throws ProtocolException {
            if (nextWord.equals(StatusCommand.MESSAGES)) {
                items.messages = true;
            } else if (nextWord.equals(StatusCommand.RECENT)) {
                items.recent = true;
            } else if (nextWord.equals(StatusCommand.UIDNEXT)) {
                items.uidNext = true;
            } else if (nextWord.equals(StatusCommand.UIDVALIDITY)) {
                items.uidValidity = true;
            } else if (nextWord.equals(StatusCommand.UNSEEN)) {
                items.unseen = true;
            } else {
                throw new ProtocolException("Unknown status item: '" + nextWord + "'");
            }
        }
    }

    private class StatusDataItems {
        boolean messages;
        boolean recent;
        boolean uidNext;
        boolean uidValidity;
        boolean unseen;

        private StatusDataItems() {
        }
    }
}

