/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.utils.timing;

import com.vladium.utils.timing.ITimer;
import com.vladium.utils.timing.ITimerConstants;

final class HRTimer
implements ITimer,
ITimerConstants {
    private int m_state;
    private double m_data;
    private static final String HRTIMER_LIB = "hrtlib";

    HRTimer() {
    }

    public void start() {
        if (this.m_state != 0) {
            throw new IllegalStateException(this + ": start() must be called from READY state, current state is " + ITimerConstants.STATE_NAMES[this.m_state]);
        }
        this.m_state = 1;
        this.m_data = HRTimer.getTime();
    }

    public void stop() {
        double d = HRTimer.getTime();
        if (this.m_state != 1) {
            throw new IllegalStateException(this + ": stop() must be called from STARTED state, current state is " + ITimerConstants.STATE_NAMES[this.m_state]);
        }
        this.m_data = d - this.m_data;
        this.m_state = 2;
    }

    public double getDuration() {
        if (this.m_state != 2) {
            throw new IllegalStateException(this + ": getDuration() must be called from STOPPED state, current state is " + ITimerConstants.STATE_NAMES[this.m_state]);
        }
        return this.m_data;
    }

    public void reset() {
        this.m_state = 0;
    }

    private static native double getTime();

    static {
        try {
            System.loadLibrary(HRTIMER_LIB);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("native lib 'hrtlib' not found in 'java.library.path': " + System.getProperty("java.library.path"));
            throw unsatisfiedLinkError;
        }
    }
}

