/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mbeans;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.alfresco.mbeans.JMXConnectorCloser;
import org.alfresco.mbeans.VirtServerRegistryMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class VirtServerRegistry
implements VirtServerRegistryMBean {
    private static Log log = LogFactory.getLog(VirtServerRegistry.class);
    private String virtServerJmxUrl_;
    private String virtServerFQDN_;
    private Integer virtServerHttpPort_;
    private String passwordFile_;
    private String accessFile_;
    private ObjectName virtWebappRegistry_;
    private JMXConnector conn_;
    private JMXServiceURL jmxServiceUrl_;
    private Map<String, Object> env_;
    private MBeanServerConnection mbsc_;
    private ApplicationContext context_;

    public VirtServerRegistry() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Creating VirtServerRegistry MBean");
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context_ = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        block12: {
            Properties passwordProps = new Properties();
            String jmxrmi_password = null;
            try {
                FileInputStream is = new FileInputStream(this.passwordFile_);
                try {
                    passwordProps.load(is);
                }
                finally {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException e) {}
                    }
                }
                this.context_.getBean("serverConnector");
                if (log.isInfoEnabled()) {
                    log.info((Object)"Created JMX serverConnector");
                }
                jmxrmi_password = passwordProps.getProperty("controlRole");
                this.env_ = new HashMap<String, Object>();
                String[] cred = new String[]{"controlRole", jmxrmi_password};
                this.env_.put("jmx.remote.credentials", cred);
                this.virtWebappRegistry_ = ObjectName.getInstance("Alfresco:Name=VirtWebappRegistry,Type=VirtWebappRegistry");
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block12;
                log.warn((Object)("WCM virtualization disabled (alfresco-jmxrmi.password and/or alfresco-jmxrmi.access isn't on classpath) due to: " + e));
            }
        }
    }

    public void setPasswordFile(String path) {
        this.passwordFile_ = path;
    }

    public String getPasswordFile() {
        return this.passwordFile_;
    }

    public void setAccessFile(String path) {
        this.accessFile_ = path;
    }

    public String getAccessFile() {
        return this.accessFile_;
    }

    public Integer getVirtServerHttpPort() {
        return this.virtServerHttpPort_;
    }

    public String getVirtServerFQDN() {
        return this.virtServerFQDN_;
    }

    public synchronized void registerVirtServerInfo(String virtServerJmxUrl, String virtServerFQDN, Integer virtServerHttpPort) {
        if (this.virtServerJmxUrl_ != null && !this.virtServerJmxUrl_.equals(virtServerJmxUrl)) {
            this.jmxServiceUrl_ = null;
        }
        this.virtServerJmxUrl_ = virtServerJmxUrl;
        this.virtServerFQDN_ = virtServerFQDN;
        this.virtServerHttpPort_ = virtServerHttpPort;
    }

    synchronized JMXServiceURL getJMXServiceURL() {
        if (this.jmxServiceUrl_ != null) {
            return this.jmxServiceUrl_;
        }
        if (this.virtServerJmxUrl_ == null) {
            return null;
        }
        try {
            this.jmxServiceUrl_ = new JMXServiceURL(this.virtServerJmxUrl_);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Could not create JMXServiceURL from: " + this.virtServerJmxUrl_));
            }
            this.jmxServiceUrl_ = null;
        }
        return this.jmxServiceUrl_;
    }

    public String getVirtServerJmxUrl() {
        return this.virtServerJmxUrl_;
    }

    public boolean updateWebapp(int version, String pathToWebapp, boolean isRecursive) {
        return this.jmxRmiWebappNotification("updateVirtualWebapp", version, pathToWebapp, isRecursive);
    }

    public boolean updateAllWebapps(int version, String path, boolean isRecursive) {
        return this.jmxRmiWebappNotification("updateAllVirtualWebapps", version, path, isRecursive);
    }

    public boolean removeWebapp(int version, String pathToWebapp, boolean isRecursive) {
        return this.jmxRmiWebappNotification("removeVirtualWebapp", version, pathToWebapp, isRecursive);
    }

    public boolean removeAllWebapps(int version, String path, boolean isRecursive) {
        return this.jmxRmiWebappNotification("removeAllVirtualWebapps", version, path, isRecursive);
    }

    public boolean verifyJmxRmiConnection() {
        boolean result = false;
        if (this.getVirtServerJmxUrl() == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No virtualization servers have registered as listeners");
            }
            return result;
        }
        if (this.conn_ == null) {
            try {
                this.conn_ = JMXConnectorFactory.connect(this.getJMXServiceURL(), this.env_);
                this.mbsc_ = this.conn_.getMBeanServerConnection();
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Could not connect to virtualization server: " + this.getVirtServerJmxUrl()));
                }
                return result;
            }
        } else {
            result = this.pingVirtServer();
        }
        return result;
    }

    public boolean pingVirtServer() {
        if (this.conn_ != null) {
            try {
                this.conn_.getConnectionId();
                return true;
            }
            catch (Exception ex) {
                this.closeJmxRmiConnection();
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean jmxRmiWebappNotification(String action, int version, String pathToWebapp, boolean isRecursive) {
        long start = System.currentTimeMillis();
        if (!this.verifyJmxRmiConnection()) {
            return false;
        }
        try {
            Boolean result = (Boolean)this.mbsc_.invoke(this.virtWebappRegistry_, action, new Object[]{new Integer(version), pathToWebapp, new Boolean(isRecursive)}, new String[]{"java.lang.Integer", "java.lang.String", "java.lang.Boolean"});
            if (!result.booleanValue()) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Action failed: " + action + "  Version: " + version + "  Webapp: " + pathToWebapp));
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not connect to JMX Server within remote virtualization server (this may be a transient error.)");
            }
            this.closeJmxRmiConnection();
            boolean bl = false;
            return bl;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("jmxRmiWebappNotification: " + action + "[" + version + ", " + pathToWebapp + "," + isRecursive + " in " + (System.currentTimeMillis() - start) + " ms"));
            }
        }
    }

    public void closeJmxRmiConnection() {
        JMXConnectorCloser conn_closer = new JMXConnectorCloser(this.conn_);
        new Thread(conn_closer).start();
        this.conn_ = null;
    }
}

