/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.util.ArrayList;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.TerracottaConfigConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.terracotta.ClusteredInstanceFactory;
import net.sf.ehcache.util.ClassLoaderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TerracottaClusteredInstanceHelper {
    private static final boolean TC_DSO_MODE = Boolean.getBoolean("tc.active");
    private static final String STANDALONE_FACTORY = "net.sf.ehcache.terracotta.StandaloneTerracottaClusteredInstanceFactory";
    private static final String DIRECT_FACTORY = "org.terracotta.modules.ehcache.store.TerracottaClusteredInstanceFactory";

    TerracottaClusteredInstanceHelper() {
    }

    static ClusteredInstanceFactory newClusteredInstanceFactory(Map<String, CacheConfiguration> cacheConfigs, TerracottaConfigConfiguration terracottaConfig) {
        Class factoryClass;
        block8: {
            try {
                factoryClass = ClassLoaderUtil.loadClass(STANDALONE_FACTORY);
                ArrayList<String> identityCaches = new ArrayList<String>();
                for (CacheConfiguration config : cacheConfigs.values()) {
                    TerracottaConfiguration tcConfig = config.getTerracottaConfiguration();
                    if (tcConfig == null || tcConfig.getValueMode() != TerracottaConfiguration.ValueMode.IDENTITY) continue;
                    identityCaches.add(config.getName());
                }
                if (!identityCaches.isEmpty()) {
                    throw new CacheException("One or more caches are configured for identity value mode which is not permitted with standalone deployment " + ((Object)identityCaches).toString());
                }
                if (terracottaConfig == null) {
                    throw new CacheException("Terracotta caches are defined but no <terracottaConfig> element was used to specify the Terracotta configuration.");
                }
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    factoryClass = ClassLoaderUtil.loadClass(DIRECT_FACTORY);
                    if (!TC_DSO_MODE) {
                        throw new CacheException("When not using standalone deployment, you need to use full install of Terracotta in order to use Terracotta Clustered Caches.");
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new CacheException("Terracotta cache classes are not available, you are missing jar(s) most likely", e);
                }
                if (terracottaConfig == null) break block8;
                throw new CacheException("The ehcache configuration specified Terracotta configuration information, but when using the full install of Terracotta, you must specify the Terracotta configuration only with an external tc-config.xml file, not embedded or referenced from the ehcache configuration file.");
            }
        }
        return (ClusteredInstanceFactory)ClassLoaderUtil.createNewInstance(factoryClass.getName(), new Class[]{TerracottaConfigConfiguration.class}, new Object[]{terracottaConfig});
    }
}

