/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.concurrent;

import java.util.TreeSet;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.ConcurrencyUtil;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.ReadWriteLockSync;
import net.sf.ehcache.concurrent.Sync;

public class StripedReadWriteLockSync
implements CacheLockProvider {
    public static final int DEFAULT_NUMBER_OF_MUTEXES = 2048;
    private final Sync[] mutexes;
    private final int numberOfStripes;

    public StripedReadWriteLockSync() {
        this(2048);
    }

    public StripedReadWriteLockSync(int numberOfStripes) {
        if (numberOfStripes % 2 != 0) {
            throw new CacheException("Cannot create a CacheLockProvider with an odd number of stripes");
        }
        if (numberOfStripes == 0) {
            throw new CacheException("A zero size CacheLockProvider does not have useful semantics.");
        }
        this.numberOfStripes = numberOfStripes;
        this.mutexes = new Sync[numberOfStripes];
        for (int i = 0; i < numberOfStripes; ++i) {
            this.mutexes[i] = new ReadWriteLockSync();
        }
    }

    public Sync getSyncForKey(Object key) {
        int lockNumber = ConcurrencyUtil.selectLock(key, this.numberOfStripes);
        return this.mutexes[lockNumber];
    }

    public Sync[] getAndWriteLockAllSyncForKeys(Object ... keys) {
        TreeSet<Sync> locks = new TreeSet<Sync>();
        for (Object key : keys) {
            locks.add(this.getSyncForKey(key));
        }
        Sync[] syncs = new Sync[locks.size()];
        int i = 0;
        for (Sync lock : locks) {
            lock.lock(LockType.WRITE);
            syncs[i++] = lock;
        }
        return syncs;
    }

    public void unlockWriteLockForAllKeys(Object ... keys) {
        TreeSet<Sync> locks = new TreeSet<Sync>();
        for (Object key : keys) {
            locks.add(this.getSyncForKey(key));
        }
        for (Sync lock : locks) {
            lock.unlock(LockType.WRITE);
        }
    }
}

