/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.event;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.NotificationScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisteredEventListeners {
    private final Set<ListenerWrapper> cacheEventListeners = new CopyOnWriteArraySet<ListenerWrapper>();
    private final Ehcache cache;
    private AtomicLong elementsRemovedCounter = new AtomicLong(0L);
    private AtomicLong elementsPutCounter = new AtomicLong(0L);
    private AtomicLong elementsUpdatedCounter = new AtomicLong(0L);
    private AtomicLong elementsExpiredCounter = new AtomicLong(0L);
    private AtomicLong elementsEvictedCounter = new AtomicLong(0L);
    private AtomicLong elementsRemoveAllCounter = new AtomicLong(0L);

    public RegisteredEventListeners(Ehcache cache) {
        this.cache = cache;
    }

    public final void notifyElementRemoved(Element element, boolean remoteEvent) throws CacheException {
        this.elementsRemovedCounter.incrementAndGet();
        if (this.hasCacheEventListeners()) {
            for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
                if (!listenerWrapper.getScope().shouldDeliver(remoteEvent) || RegisteredEventListeners.isCircularNotification(remoteEvent, listenerWrapper.getListener())) continue;
                listenerWrapper.getListener().notifyElementRemoved(this.cache, element);
            }
        }
    }

    public final void notifyElementPut(Element element, boolean remoteEvent) throws CacheException {
        this.elementsPutCounter.incrementAndGet();
        if (this.hasCacheEventListeners()) {
            for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
                if (!listenerWrapper.getScope().shouldDeliver(remoteEvent) || RegisteredEventListeners.isCircularNotification(remoteEvent, listenerWrapper.getListener())) continue;
                listenerWrapper.getListener().notifyElementPut(this.cache, element);
            }
        }
    }

    public final void notifyElementUpdated(Element element, boolean remoteEvent) {
        this.elementsUpdatedCounter.incrementAndGet();
        if (this.hasCacheEventListeners()) {
            for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
                if (!listenerWrapper.getScope().shouldDeliver(remoteEvent) || RegisteredEventListeners.isCircularNotification(remoteEvent, listenerWrapper.getListener())) continue;
                listenerWrapper.getListener().notifyElementUpdated(this.cache, element);
            }
        }
    }

    public final void notifyElementExpiry(Element element, boolean remoteEvent) {
        this.elementsExpiredCounter.incrementAndGet();
        if (this.hasCacheEventListeners()) {
            for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
                if (!listenerWrapper.getScope().shouldDeliver(remoteEvent) || RegisteredEventListeners.isCircularNotification(remoteEvent, listenerWrapper.getListener())) continue;
                listenerWrapper.getListener().notifyElementExpired(this.cache, element);
            }
        }
    }

    public final boolean hasCacheEventListeners() {
        return this.cacheEventListeners.size() > 0;
    }

    public void notifyElementEvicted(Element element, boolean remoteEvent) {
        this.elementsEvictedCounter.incrementAndGet();
        if (this.hasCacheEventListeners()) {
            for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
                if (!listenerWrapper.getScope().shouldDeliver(remoteEvent) || RegisteredEventListeners.isCircularNotification(remoteEvent, listenerWrapper.getListener())) continue;
                listenerWrapper.getListener().notifyElementEvicted(this.cache, element);
            }
        }
    }

    public void notifyRemoveAll(boolean remoteEvent) {
        this.elementsRemoveAllCounter.incrementAndGet();
        if (this.hasCacheEventListeners()) {
            for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
                if (!listenerWrapper.getScope().shouldDeliver(remoteEvent) || RegisteredEventListeners.isCircularNotification(remoteEvent, listenerWrapper.getListener())) continue;
                listenerWrapper.getListener().notifyRemoveAll(this.cache);
            }
        }
    }

    private static boolean isCircularNotification(boolean remoteEvent, CacheEventListener cacheEventListener) {
        return remoteEvent && cacheEventListener instanceof CacheReplicator;
    }

    public final boolean registerListener(CacheEventListener cacheEventListener) {
        return this.registerListener(cacheEventListener, NotificationScope.ALL);
    }

    public final boolean registerListener(CacheEventListener cacheEventListener, NotificationScope scope) {
        if (cacheEventListener == null) {
            return false;
        }
        return this.cacheEventListeners.add(new ListenerWrapper(cacheEventListener, scope));
    }

    public final boolean unregisterListener(CacheEventListener cacheEventListener) {
        Iterator<ListenerWrapper> it = this.cacheEventListeners.iterator();
        while (it.hasNext()) {
            ListenerWrapper listenerWrapper = it.next();
            if (!listenerWrapper.getListener().equals(cacheEventListener)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public final Set<CacheEventListener> getCacheEventListeners() {
        HashSet<CacheEventListener> listenerSet = new HashSet<CacheEventListener>();
        for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
            listenerSet.add(listenerWrapper.getListener());
        }
        return listenerSet;
    }

    public final void dispose() {
        for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
            listenerWrapper.getListener().dispose();
        }
        this.cacheEventListeners.clear();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(" cacheEventListeners: ");
        for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
            sb.append(listenerWrapper.getListener().getClass().getName()).append(" ");
        }
        return sb.toString();
    }

    public void clearCounters() {
        this.elementsRemovedCounter.set(0L);
        this.elementsPutCounter.set(0L);
        this.elementsUpdatedCounter.set(0L);
        this.elementsExpiredCounter.set(0L);
        this.elementsEvictedCounter.set(0L);
        this.elementsRemoveAllCounter.set(0L);
    }

    public long getElementsRemovedCounter() {
        return this.elementsRemovedCounter.get();
    }

    public long getElementsPutCounter() {
        return this.elementsPutCounter.get();
    }

    public long getElementsUpdatedCounter() {
        return this.elementsUpdatedCounter.get();
    }

    public long getElementsExpiredCounter() {
        return this.elementsExpiredCounter.get();
    }

    public long getElementsEvictedCounter() {
        return this.elementsEvictedCounter.get();
    }

    public long getElementsRemoveAllCounter() {
        return this.elementsRemoveAllCounter.get();
    }

    private static final class ListenerWrapper {
        private final CacheEventListener listener;
        private final NotificationScope scope;

        private ListenerWrapper(CacheEventListener listener, NotificationScope scope) {
            this.listener = listener;
            this.scope = scope;
        }

        private CacheEventListener getListener() {
            return this.listener;
        }

        private NotificationScope getScope() {
            return this.scope;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListenerWrapper other = (ListenerWrapper)obj;
            return !(this.listener == null ? other.listener != null : !this.listener.equals(other.listener));
        }

        public String toString() {
            return this.listener.toString();
        }
    }
}

