/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.manager.btm;

import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.ResourceConfigurationException;
import bitronix.tm.resource.ResourceObjectFactory;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.RecoveryXAResourceHolder;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.resource.common.XAStatefulHolder;
import bitronix.tm.utils.ClassLoaderUtils;
import bitronix.tm.utils.PropertyUtils;
import java.util.Map;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.transaction.xa.XAResource;
import net.sf.ehcache.transaction.manager.btm.GenericXAResourceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericXAResourceProducer
extends ResourceBean
implements XAResourceProducer {
    private static final Logger LOG = LoggerFactory.getLogger(GenericXAResourceProducer.class);
    private static final long serialVersionUID = 1L;
    private XAResource xaResource;
    private GenericXAResourceHolder xaResourceHolder;
    private RecoveryXAResourceHolder recoveryXAResourceHolder;

    public static synchronized void registerXAResource(String uniqueName, XAResource resource) {
        GenericXAResourceProducer producer = new GenericXAResourceProducer();
        producer.setXAResource(resource);
        producer.setUniqueName(uniqueName);
        producer.init();
    }

    public void setXAResource(XAResource resource) {
        this.xaResource = resource;
    }

    public void init() {
        try {
            this.xaResource = this.createXAResource(this);
            this.xaResourceHolder = (GenericXAResourceHolder)this.createPooledConnection(this.xaResource, this);
            ResourceRegistrar.register((XAResourceProducer)this);
            XAResourceHolderState xaResourceHolderState = new XAResourceHolderState((XAResourceHolder)this.xaResourceHolder, (ResourceBean)this);
            this.xaResourceHolder.setXAResourceHolderState(xaResourceHolderState);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ResourceConfigurationException("cannot create XAResources named " + this.getUniqueName(), (Throwable)e);
        }
    }

    public XAResourceHolderState startRecovery() throws RecoveryException {
        if (this.xaResource == null && this.xaResourceHolder == null) {
            this.init();
        }
        this.recoveryXAResourceHolder = this.xaResourceHolder.createRecoveryXAResourceHolder();
        return new XAResourceHolderState((XAResourceHolder)this.recoveryXAResourceHolder, (ResourceBean)this);
    }

    public void endRecovery() throws RecoveryException {
    }

    public void setFailed(boolean failed) {
    }

    public void close() {
        ResourceRegistrar.unregister((XAResourceProducer)this);
        this.xaResourceHolder = null;
        this.recoveryXAResourceHolder = null;
    }

    public XAStatefulHolder createPooledConnection(Object xaFactory, ResourceBean bean) throws Exception {
        if (this.xaResourceHolder == null) {
            this.xaResourceHolder = new GenericXAResourceHolder((XAResource)xaFactory, this);
        }
        return this.xaResourceHolder;
    }

    public XAResourceHolder findXAResourceHolder(XAResource aXAResource) {
        return this.xaResourceHolder.getXAResource() == aXAResource ? this.xaResourceHolder : null;
    }

    public Reference getReference() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating new JNDI reference of " + (Object)((Object)this));
        }
        return new Reference(GenericXAResourceProducer.class.getName(), new StringRefAddr("uniqueName", this.getUniqueName()), ResourceObjectFactory.class.getName(), null);
    }

    private XAResource createXAResource(ResourceBean bean) throws Exception {
        if (this.xaResource != null) {
            return this.xaResource;
        }
        String className = bean.getClassName();
        if (className == null) {
            throw new IllegalArgumentException("className cannot be null");
        }
        Class xaResourceClass = ClassLoaderUtils.loadClass((String)className);
        XAResource resource = (XAResource)xaResourceClass.newInstance();
        for (Map.Entry<Object, Object> entry : bean.getDriverProperties().entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            LOG.debug("setting vendor property '{}' to '{}'", (Object)name, (Object)value);
            PropertyUtils.setProperty((Object)xaResourceClass, (String)name, (Object)value);
        }
        return resource;
    }
}

