/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;

public class CompressionUtil {
    public static CompressionCodec getCodec(String name) {
        CompressionCodec codec = null;
        if (name == null) {
            return null;
        }
        try {
            codec = CompressionCodec.valueOf(name.toUpperCase().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return codec;
    }

    public static OutputStream getEncodedOutputStream(OutputStream out, CompressionCodec encoding) throws IOException {
        return CompressionUtil.getEncodedOutputStream(out, new CompressionCodec[]{encoding});
    }

    public static OutputStream getEncodedOutputStream(OutputStream out, CompressionCodec ... encodings) throws IOException {
        block4: for (CompressionCodec encoding : encodings) {
            switch (encoding) {
                case GZIP: {
                    out = new GZIPOutputStream(out);
                    continue block4;
                }
                case DEFLATE: {
                    out = new DeflaterOutputStream(out);
                }
            }
        }
        return out;
    }

    public static InputStream getDecodingInputStream(InputStream in, CompressionCodec encoding) throws IOException {
        switch (encoding) {
            case GZIP: 
            case XGZIP: {
                in = new GZIPInputStream(in);
                break;
            }
            case DEFLATE: {
                in = new InflaterInputStream(in);
            }
        }
        return in;
    }

    public static InputStream getDecodingInputStream(InputStream in, CompressionCodec ... encoding) throws IOException {
        for (CompressionCodec codec : encoding) {
            in = CompressionUtil.getDecodingInputStream(in, codec);
        }
        return in;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompressionCodec {
        GZIP,
        XGZIP,
        DEFLATE;

    }
}

