/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ModelObjectPersister;
import org.springframework.extensions.surf.persister.MultiObjectPersister;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.Store;
import org.springframework.extensions.webscripts.processor.FTLTemplateProcessor;
import org.springframework.extensions.webscripts.processor.JSScriptProcessor;

public class AutowireService
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(AutowireService.class);
    private ApplicationContext applicationContext;
    private ConfigService configService;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public WebFrameworkConfigElement getWebFrameworkConfiguration() {
        Config webFrameworkConfig = this.configService.getConfig((Object)"WebFramework");
        return (WebFrameworkConfigElement)webFrameworkConfig.getConfigElement("web-framework");
    }

    public void init() {
        this.autoWire();
    }

    protected void autoWire() {
        JSScriptProcessor templatesScriptProcessor;
        FTLTemplateProcessor templatesTemplateProcessor;
        JSScriptProcessor webscriptsScriptProcessor;
        FTLTemplateProcessor webscriptsTemplateProcessor;
        WebFrameworkConfigElement configElement = this.getWebFrameworkConfiguration();
        String autowireModeId = configElement.getAutowireModeId();
        String autowireRuntimeId = configElement.getAutowireRuntimeId();
        if ("developer".equalsIgnoreCase(autowireModeId) || "development".equalsIgnoreCase(autowireModeId)) {
            configElement.getPersisterConfigDescriptor().setCacheEnabled(false);
            configElement.getPersisterConfigDescriptor().setCacheCheckDelay(0);
            webscriptsTemplateProcessor = (FTLTemplateProcessor)this.getApplicationContext().getBean("webframework.webscripts.templateprocessor.freemarker");
            webscriptsTemplateProcessor.setUpdateDelay(0);
            webscriptsScriptProcessor = (JSScriptProcessor)this.getApplicationContext().getBean("webframework.webscripts.scriptprocessor.javascript");
            webscriptsScriptProcessor.setCompile(false);
            templatesTemplateProcessor = (FTLTemplateProcessor)this.getApplicationContext().getBean("webframework.templates.templateprocessor.freemarker");
            templatesTemplateProcessor.setUpdateDelay(0);
            templatesScriptProcessor = (JSScriptProcessor)this.getApplicationContext().getBean("webframework.templates.scriptprocessor.javascript");
            templatesScriptProcessor.setCompile(false);
        }
        if ("production".equalsIgnoreCase(autowireModeId)) {
            configElement.getPersisterConfigDescriptor().setCacheEnabled(true);
            configElement.getPersisterConfigDescriptor().setCacheCheckDelay(-1);
            webscriptsTemplateProcessor = (FTLTemplateProcessor)this.getApplicationContext().getBean("webframework.webscripts.templateprocessor.freemarker");
            webscriptsTemplateProcessor.setUpdateDelay(86400);
            webscriptsScriptProcessor = (JSScriptProcessor)this.getApplicationContext().getBean("webframework.webscripts.scriptprocessor.javascript");
            webscriptsScriptProcessor.setCompile(true);
            templatesTemplateProcessor = (FTLTemplateProcessor)this.getApplicationContext().getBean("webframework.templates.templateprocessor.freemarker");
            templatesTemplateProcessor.setUpdateDelay(86400);
            templatesScriptProcessor = (JSScriptProcessor)this.getApplicationContext().getBean("webframework.templates.scriptprocessor.javascript");
            templatesScriptProcessor.setCompile(true);
        }
        String[] webscriptPaths = new String[]{"webframework.webscripts.store.remote", "webframework.webscripts.store.local", "webframework.webscripts.store.webinf", "webframework.webscripts.store.alfresco.custom", "webframework.webscripts.store.alfresco.classpath", "webframework.webscripts.store.classpath", "webscripts.store.alfresco", "webscripts.store"};
        String[] templatePaths = new String[]{"webframework.templates.store.remote", "webframework.webscripts.store.remote", "webframework.templates.store.local", "webframework.webscripts.store.local", "webframework.templates.store.webinf", "webframework.webscripts.store.webinf", "webframework.templates.store.alfresco.custom", "webframework.webscripts.store.alfresco.custom", "webframework.templates.store.alfresco.classpath", "webframework.webscripts.store.alfresco.classpath", "webframework.templates.store.classpath", "webframework.webscripts.store.classpath"};
        String[] persisterPaths = new String[]{"webframework.webinf.persister.remote", "webframework.webinf.persister.local", "webframework.webinf.persister.root", "webframework.sitedata.persister.classpath.alfresco-custom", "webframework.sitedata.persister.alfresco-classpath", "webframework.sitedata.persister.classpath"};
        boolean includeAlfresco = true;
        boolean includeWebInf = true;
        boolean includeLocal = true;
        boolean includeRemote = true;
        if ("classpath".equalsIgnoreCase(autowireRuntimeId)) {
            includeWebInf = false;
            includeLocal = false;
            includeRemote = false;
        }
        if ("webapp".equalsIgnoreCase(autowireRuntimeId)) {
            includeLocal = false;
            includeRemote = false;
        }
        if ("local".equalsIgnoreCase(autowireRuntimeId)) {
            includeRemote = false;
        }
        if ("alfresco".equalsIgnoreCase(autowireRuntimeId)) {
            // empty if block
        }
        boolean adjusted = false;
        if (!includeAlfresco) {
            webscriptPaths = this.spliceArrayElement(webscriptPaths, "webframework.webscripts.store.alfresco.custom");
            webscriptPaths = this.spliceArrayElement(webscriptPaths, "webframework.webscripts.store.alfresco.classpath");
            templatePaths = this.spliceArrayElement(templatePaths, "webframework.templates.store.alfresco.custom");
            templatePaths = this.spliceArrayElement(templatePaths, "webframework.webscripts.store.alfresco.custom");
            templatePaths = this.spliceArrayElement(templatePaths, "webframework.templates.store.alfresco.classpath");
            templatePaths = this.spliceArrayElement(templatePaths, "webframework.webscripts.store.alfresco.classpath");
            persisterPaths = this.spliceArrayElement(persisterPaths, "webframework.sitedata.persister.classpath.alfresco-custom");
            persisterPaths = this.spliceArrayElement(persisterPaths, "webframework.sitedata.persister.alfresco-classpath");
            adjusted = true;
        }
        if (!includeWebInf) {
            webscriptPaths = this.spliceArrayElement(webscriptPaths, "webframework.webscripts.store.webinf");
            templatePaths = this.spliceArrayElement(templatePaths, "webframework.webscripts.store.webinf");
            templatePaths = this.spliceArrayElement(templatePaths, "webframework.templates.store.webinf");
            persisterPaths = this.spliceArrayElement(persisterPaths, "webframework.webinf.persister.root");
            adjusted = true;
        }
        if (!includeLocal) {
            webscriptPaths = this.spliceArrayElement(webscriptPaths, "webframework.webscripts.store.local");
            templatePaths = this.spliceArrayElement(templatePaths, "webframework.templates.store.local");
            templatePaths = this.spliceArrayElement(templatePaths, "webframework.webscripts.store.local");
            persisterPaths = this.spliceArrayElement(persisterPaths, "webframework.webinf.persister.local");
            adjusted = true;
        }
        if (!includeRemote) {
            webscriptPaths = this.spliceArrayElement(webscriptPaths, "webframework.webscripts.store.remote");
            templatePaths = this.spliceArrayElement(templatePaths, "webframework.templates.store.remote");
            templatePaths = this.spliceArrayElement(templatePaths, "webframework.webscripts.store.remote");
            persisterPaths = this.spliceArrayElement(persisterPaths, "webframework.webinf.persister.remote");
            adjusted = true;
        }
        if (adjusted) {
            this.bindSearchPath("webframework.webscripts.searchpath", webscriptPaths);
            this.bindSearchPath("webframework.templates.searchpath", templatePaths);
            this.bindObjectsPersister("webframework.objects.persister", persisterPaths, "webframework.sitedata.persister.classpath");
        }
        if (logger.isInfoEnabled()) {
            if (autowireModeId != null) {
                logger.info((Object)("Autowire Mode - " + autowireModeId));
            }
            if (autowireRuntimeId != null) {
                logger.info((Object)("Autowire Runtime - " + autowireRuntimeId));
            }
            this.reportSearchPath("webframework.webscripts.searchpath");
            this.reportSearchPath("webframework.templates.searchpath");
            this.reportPersister("webframework.objects.persister");
        }
    }

    protected void bindObjectsPersister(String persisterId, String[] persisterIds, String defaultPersisterId) {
        ModelObjectPersister persister = (ModelObjectPersister)this.getApplicationContext().getBean(persisterId);
        if (persister != null) {
            if (persister instanceof MultiObjectPersister) {
                ArrayList<ModelObjectPersister> list = new ArrayList<ModelObjectPersister>();
                for (String childPersisterId : persisterIds) {
                    ModelObjectPersister childPersister = (ModelObjectPersister)this.getApplicationContext().getBean(childPersisterId);
                    if (childPersister != null) {
                        list.add(childPersister);
                        continue;
                    }
                    if (!logger.isInfoEnabled()) continue;
                    logger.info((Object)("Unable to locate child persister: " + childPersisterId));
                }
                ((MultiObjectPersister)persister).setPersisters(list);
                ModelObjectPersister defaultPersister = (ModelObjectPersister)this.getApplicationContext().getBean(defaultPersisterId);
                if (defaultPersister != null) {
                    ((MultiObjectPersister)persister).setDefaultPersister(defaultPersister);
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)("Unable to locate default persister for id: " + defaultPersisterId));
                }
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)("Persister with id: " + persisterId + " is not a multi object persister"));
            }
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("Unable to locate persister: " + persisterId));
        }
    }

    protected void bindSearchPath(String searchPathId, String[] storeIds) {
        SearchPath searchPath = (SearchPath)this.getApplicationContext().getBean(searchPathId);
        if (searchPath != null) {
            ArrayList<Store> searchPathList = new ArrayList<Store>(16);
            for (int i = 0; i < storeIds.length; ++i) {
                Store store = (Store)this.getApplicationContext().getBean(storeIds[i]);
                searchPathList.add(store);
            }
            searchPath.setSearchPath(searchPathList);
        }
    }

    protected void insertIntoSearchPath(String searchPathId, String storeId, String referenceStoreId, boolean before) {
        Store referenceStore = (Store)this.getApplicationContext().getBean(referenceStoreId);
        Store additionalStore = (Store)this.getApplicationContext().getBean(storeId);
        SearchPath searchPath = (SearchPath)this.getApplicationContext().getBean(searchPathId);
        if (searchPath != null) {
            ArrayList<Store> searchPathList = new ArrayList<Store>(searchPath.getStores().size());
            for (Store store : searchPath.getStores()) {
                if (store == referenceStore && before) {
                    searchPathList.add(additionalStore);
                }
                searchPathList.add(store);
                if (store != referenceStore || before) continue;
                searchPathList.add(additionalStore);
            }
            searchPath.setSearchPath(searchPathList);
        }
    }

    protected void reportSearchPath(String searchPathId) {
        if (logger.isInfoEnabled()) {
            StringBuilder s = new StringBuilder();
            s.append("[");
            SearchPath searchPath = (SearchPath)this.getApplicationContext().getBean(searchPathId);
            if (searchPath != null) {
                Iterator it = searchPath.getStores().iterator();
                while (it.hasNext()) {
                    Store store = (Store)it.next();
                    s.append("'");
                    s.append(store.toString());
                    s.append("'");
                    if (!it.hasNext()) continue;
                    s.append(",");
                }
            }
            s.append("]");
            logger.info((Object)("Search Path: " + searchPathId + " = " + s.toString()));
        }
    }

    protected void reportPersister(String persisterId) {
        if (logger.isInfoEnabled()) {
            StringBuilder s = new StringBuilder();
            s.append("[");
            ModelObjectPersister persister = (ModelObjectPersister)this.getApplicationContext().getBean(persisterId);
            if (persister != null && persister instanceof MultiObjectPersister) {
                MultiObjectPersister mop = (MultiObjectPersister)persister;
                List<ModelObjectPersister> persisters = mop.getPersisters();
                for (int i = 0; i < persisters.size(); ++i) {
                    ModelObjectPersister p = persisters.get(i);
                    s.append("'");
                    s.append(p.getId());
                    s.append("'");
                    if (i + 1 < persisters.size()) {
                        // empty if block
                    }
                    s.append(",");
                }
            }
            s.append("]");
            logger.info((Object)("Persister: " + persisterId + " = " + s.toString()));
        }
    }

    protected String[] spliceArrayElement(String[] array, String element) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(array));
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equals(element)) continue;
            list.remove(i);
            break;
        }
        return list.toArray(new String[list.size()]);
    }
}

