/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.ModelHelper;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelObjectPersister;
import org.springframework.extensions.surf.ModelPersistenceContext;
import org.springframework.extensions.surf.ThreadLocalPreviewContext;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.surf.persister.CachedPersister;
import org.springframework.extensions.surf.persister.PersisterService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectPersistenceService {
    private static final Log logger = LogFactory.getLog(ObjectPersistenceService.class);
    private PersisterService persisterService;

    public void setPersisterService(PersisterService persisterService) {
        this.persisterService = persisterService;
    }

    public PersisterService getPersisterService() {
        return this.persisterService;
    }

    public ModelPersistenceContext getPersistenceContext() {
        ModelPersistenceContext mpc = null;
        ThreadLocalPreviewContext previewContext = ThreadLocalPreviewContext.getPreviewContext();
        if (previewContext != null) {
            mpc = new ModelPersistenceContext(previewContext.getUserId());
            mpc.setStoreId(previewContext.getStoreId());
            mpc.setWebappId(previewContext.getWebappId());
        } else {
            mpc = new ModelPersistenceContext(null);
        }
        return mpc;
    }

    public ModelObject getObject(String objectTypeId, String objectId) {
        ModelObject obj = null;
        PersisterService ps = this.getPersisterService();
        ModelObjectPersister persister = ps.getPersisterByTypeId(objectTypeId);
        if (persister != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getObject loading: " + objectId + " of type: " + objectTypeId));
            }
            try {
                ModelPersistenceContext context = this.getPersistenceContext();
                obj = persister.getObject(context, objectTypeId, objectId);
            }
            catch (ModelObjectPersisterException mope) {
                throw new PlatformRuntimeException("Unable to retrieve object: " + objectId + " of type: " + objectTypeId, (Throwable)mope);
            }
        }
        return obj;
    }

    public ModelObject newObject(String objectTypeId, String objectId) {
        ModelObject obj;
        block3: {
            obj = null;
            ModelObjectPersister persister = this.getPersisterService().getPersisterByTypeId(objectTypeId);
            if (persister != null) {
                try {
                    obj = persister.newObject(this.getPersistenceContext(), objectTypeId, objectId);
                }
                catch (ModelObjectPersisterException mope) {
                    if (!logger.isInfoEnabled()) break block3;
                    logger.info((Object)("Unable to create object: " + objectId + " of type: " + objectTypeId), (Throwable)mope);
                }
            }
        }
        return obj;
    }

    public ModelObject newObject(String objectTypeId) {
        ModelObject obj;
        block3: {
            obj = null;
            ModelObjectPersister persister = this.getPersisterService().getPersisterByTypeId(objectTypeId);
            if (persister != null) {
                String objectId = ObjectPersistenceService.newGUID();
                try {
                    obj = persister.newObject(this.getPersistenceContext(), objectTypeId, objectId);
                }
                catch (ModelObjectPersisterException mope) {
                    if (!logger.isInfoEnabled()) break block3;
                    logger.info((Object)("Unable to create object: " + objectId + " of type: " + objectTypeId), (Throwable)mope);
                }
            }
        }
        return obj;
    }

    public boolean saveObject(ModelObject object) {
        boolean saved;
        block4: {
            saved = false;
            ModelObjectPersister persister = this.getPersisterService().getPersisterByTypeId(object.getPersisterId());
            if (persister != null) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Attempting to save object '" + object.getId() + "' to persister: " + persister.getId()));
                    }
                    saved = persister.saveObject(this.getPersistenceContext(), object);
                }
                catch (ModelObjectPersisterException mope) {
                    if (!logger.isInfoEnabled()) break block4;
                    logger.info((Object)("Unable to save object: " + object.getId() + " of type: " + object.getTypeId() + " to persister: " + persister.getId() + " due to error"), (Throwable)mope);
                }
            }
        }
        return saved;
    }

    public boolean removeObject(ModelObject object) {
        return this.removeObject(object.getTypeId(), object.getId());
    }

    public boolean removeObject(String objectTypeId, String objectId) {
        boolean removed;
        block4: {
            removed = false;
            ModelObjectPersister persister = this.getPersisterService().getPersisterByTypeId(objectTypeId);
            if (persister != null) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Attempting to remove object '" + objectId + "' of type '" + objectTypeId + "' from persister: " + persister.getId()));
                    }
                    removed = persister.removeObject(this.getPersistenceContext(), objectTypeId, objectId);
                }
                catch (ModelObjectPersisterException mope) {
                    if (!logger.isInfoEnabled()) break block4;
                    logger.info((Object)("Unable to remove object: " + objectId + " of type: " + objectTypeId), (Throwable)mope);
                }
            }
        }
        return removed;
    }

    public Map<String, ModelObject> getAllObjects(String objectTypeId) {
        Map<String, ModelObject> objects;
        block3: {
            objects = Collections.emptyMap();
            ModelObjectPersister persister = this.getPersisterService().getPersisterByTypeId(objectTypeId);
            if (persister != null) {
                try {
                    objects = persister.getAllObjects(this.getPersistenceContext(), objectTypeId);
                }
                catch (ModelObjectPersisterException mope) {
                    if (!logger.isInfoEnabled()) break block3;
                    logger.info((Object)"ModelObjectManager unable to retrieve all objects", (Throwable)mope);
                }
            }
        }
        return objects;
    }

    public Map<String, ModelObject> getAllObjects(String objectTypeId, String filter) {
        Map<String, ModelObject> objects;
        block3: {
            objects = Collections.emptyMap();
            ModelObjectPersister persister = this.getPersisterService().getPersisterByTypeId(objectTypeId);
            if (persister != null) {
                try {
                    objects = persister.getAllObjectsByFilter(this.getPersistenceContext(), objectTypeId, filter);
                }
                catch (ModelObjectPersisterException mope) {
                    if (!logger.isInfoEnabled()) break block3;
                    logger.info((Object)("ModelObjectManager unable to retrieve all objects by filter: " + filter), (Throwable)mope);
                }
            }
        }
        return objects;
    }

    private static String newGUID() {
        return ModelHelper.newGUID();
    }

    public void invalidateCache() {
        Map<String, ModelObjectPersister> objectPersisters = this.getPersisterService().getObjectPersisters();
        for (ModelObjectPersister persister : objectPersisters.values()) {
            if (!(persister instanceof CachedPersister)) continue;
            ((CachedPersister)((Object)persister)).invalidateCache();
        }
    }
}

