/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.persister;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelObjectPersister;
import org.springframework.extensions.surf.ModelPersistenceContext;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.surf.persister.AbstractObjectPersister;
import org.springframework.extensions.surf.persister.CachedPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiObjectPersister
extends AbstractObjectPersister
implements CachedPersister {
    private static final Log logger = LogFactory.getLog(MultiObjectPersister.class);
    private List<ModelObjectPersister> persisters;
    private ModelObjectPersister defaultPersister;

    public void setPersisters(List<ModelObjectPersister> persisters) {
        this.persisters = persisters;
    }

    public List<ModelObjectPersister> getPersisters() {
        return this.persisters;
    }

    public void setDefaultPersister(ModelObjectPersister defaultPersister) {
        this.defaultPersister = defaultPersister;
    }

    @Override
    public ModelObject getObject(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        boolean debug = logger.isDebugEnabled();
        ModelObject modelObject = null;
        for (ModelObjectPersister persister : this.persisters) {
            String persisterId = persister.getId();
            try {
                if (debug) {
                    logger.debug((Object)("getObject attempting to load '" + objectId + "' of type '" + objectTypeId + "' from persister: " + persisterId));
                }
                modelObject = persister.getObject(context, objectTypeId, objectId);
            }
            catch (ModelObjectPersisterException mope) {
                throw new ModelObjectPersisterException("Error loading object id: " + objectId + " from persister id: " + persisterId, mope);
            }
            if (modelObject == null) continue;
            if (!debug) break;
            logger.debug((Object)("getObject loaded '" + objectId + "' from persister: " + persisterId));
            break;
        }
        if (modelObject == null && debug) {
            logger.debug((Object)"getObject() unable to get object from any persisters");
        }
        return modelObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveObject(ModelPersistenceContext context, ModelObject object) throws ModelObjectPersisterException {
        boolean saved = false;
        ModelObjectPersister persister = this.getPersisterService().getPersisterById(object.getPersisterId());
        if (persister != null) {
            ModelObjectPersister savedToPersister = persister;
            try {
                try {
                    saved = persister.saveObject(context, object);
                }
                catch (ModelObjectPersisterException moe) {
                    if (this.defaultPersister != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Failed to save object: " + object.getId() + " of type: " + object.getTypeId() + " to current persister: " + persister.getId() + " due to error: " + moe.getMessage()));
                        }
                        savedToPersister = this.defaultPersister;
                        saved = this.defaultPersister.saveObject(context, object);
                    }
                    throw moe;
                }
                if (!saved && this.defaultPersister != null && savedToPersister != this.defaultPersister) {
                    savedToPersister = this.defaultPersister;
                    saved = this.defaultPersister.saveObject(context, object);
                }
            }
            finally {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("saveObject save to persister '" + savedToPersister + "' returned: " + saved));
                }
            }
        }
        return saved;
    }

    @Override
    public boolean removeObject(ModelPersistenceContext context, ModelObject object) throws ModelObjectPersisterException {
        return this.removeObject(context, object.getTypeId(), object.getId());
    }

    @Override
    public boolean removeObject(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        boolean removed = false;
        for (ModelObjectPersister persister : this.persisters) {
            String persisterId = persister.getId();
            if (!persister.hasObject(context, objectTypeId, objectId)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("removeObject attempting to remove '" + objectId + "' of type '" + objectTypeId + "' from persister: " + persisterId));
            }
            removed = persister.removeObject(context, objectTypeId, objectId);
            if (!logger.isDebugEnabled()) break;
            logger.debug((Object)("removeObject removed from persister '" + persisterId + "' returned: " + removed));
            break;
        }
        return removed;
    }

    @Override
    public boolean hasObject(ModelPersistenceContext context, ModelObject object) throws ModelObjectPersisterException {
        return this.hasObject(context, object.getTypeId(), object.getId());
    }

    @Override
    public boolean hasObject(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        boolean hasObject = false;
        for (ModelObjectPersister persister : this.persisters) {
            String persisterId = persister.getId();
            if (!persister.hasObject(context, objectTypeId, objectId)) continue;
            hasObject = true;
            break;
        }
        return hasObject;
    }

    @Override
    public ModelObject newObject(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        ModelObject obj = null;
        if (this.defaultPersister != null) {
            obj = this.defaultPersister.newObject(context, objectTypeId, objectId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("newObject created on persister '" + this.defaultPersister.getId() + "' returned: " + obj));
            }
        } else {
            throw new ModelObjectPersisterException("Unable to create new object - no default persister found for object type id: " + objectTypeId);
        }
        return obj;
    }

    @Override
    public Map<String, ModelObject> getAllObjects(ModelPersistenceContext context, String objectTypeId) throws ModelObjectPersisterException {
        HashMap<String, ModelObject> objects = new HashMap<String, ModelObject>(512, 1.0f);
        for (ModelObjectPersister persister : this.persisters) {
            String persisterId = persister.getId();
            Map<String, ModelObject> map = persister.getAllObjects(context, objectTypeId);
            objects.putAll(map);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getAllObjects returned set of size: " + objects.size()));
        }
        return objects;
    }

    @Override
    public Map<String, ModelObject> getAllObjectsByFilter(ModelPersistenceContext context, String objectTypeId, String filter) throws ModelObjectPersisterException {
        HashMap<String, ModelObject> objects = new HashMap<String, ModelObject>(128, 1.0f);
        for (ModelObjectPersister persister : this.persisters) {
            String persisterId = persister.getId();
            Map<String, ModelObject> map = persister.getAllObjectsByFilter(context, objectTypeId, filter);
            objects.putAll(map);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getAllObjects by filter: " + filter + " returned set of size: " + objects.size()));
        }
        return objects;
    }

    @Override
    public long getTimestamp(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        long timestamp = -1L;
        for (ModelObjectPersister persister : this.persisters) {
            if (!persister.hasObject(context, objectTypeId, objectId)) continue;
            timestamp = persister.getTimestamp(context, objectTypeId, objectId);
            break;
        }
        return timestamp;
    }

    @Override
    public void init(ModelPersistenceContext context) {
        for (ModelObjectPersister persister : this.persisters) {
            persister.init(context);
        }
    }

    @Override
    public void invalidateCache() {
        for (ModelObjectPersister persister : this.persisters) {
            if (!(persister instanceof CachedPersister)) continue;
            ((CachedPersister)((Object)persister)).invalidateCache();
        }
    }

    @Override
    public void setCache(boolean cache) {
        for (ModelObjectPersister persister : this.persisters) {
            if (!(persister instanceof CachedPersister)) continue;
            ((CachedPersister)((Object)persister)).setCache(cache);
        }
    }

    @Override
    public void setCacheCheckDelay(int cacheCheckDelay) {
        for (ModelObjectPersister persister : this.persisters) {
            if (!(persister instanceof CachedPersister)) continue;
            ((CachedPersister)((Object)persister)).setCacheCheckDelay(cacheCheckDelay);
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        int i = 0;
        for (ModelObjectPersister p : this.persisters) {
            if (i == 0) {
                out.append("[");
            }
            out.append(p.toString());
            if (i < this.persisters.size() - 1) {
                out.append(", ");
            }
            if (i == this.persisters.size() - 1) {
                out.append("]");
            }
            ++i;
        }
        return out.toString();
    }
}

