/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.persister;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ModelObjectPersister;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.persister.CachedPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersisterService
implements ApplicationContextAware,
ApplicationListener {
    private static final Log logger = LogFactory.getLog(PersisterService.class);
    private ApplicationContext applicationContext;
    private WebFrameworkServiceRegistry serviceRegistry;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setServiceRegistry(WebFrameworkServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public WebFrameworkServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public WebFrameworkConfigElement getWebFrameworkConfig() {
        return this.getServiceRegistry().getWebFrameworkConfiguration();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        ContextRefreshedEvent refreshEvent;
        ApplicationContext refreshContext;
        if (event instanceof ContextRefreshedEvent && (refreshContext = (refreshEvent = (ContextRefreshedEvent)event).getApplicationContext()) != null && refreshContext.equals(this.getApplicationContext())) {
            this.initPersisters();
        }
    }

    public void initPersisters() {
        Map<String, ModelObjectPersister> objectPersisters = this.getObjectPersisters();
        WebFrameworkConfigElement.PersisterConfigDescriptor config = this.getWebFrameworkConfig().getPersisterConfigDescriptor();
        for (ModelObjectPersister persister : objectPersisters.values()) {
            if (persister instanceof CachedPersister && config != null) {
                boolean cache = config.getCacheEnabled();
                int cacheCheckDelay = config.getCacheCheckDelay();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Setting global cache setting: " + cache + " delay: " + cacheCheckDelay + " onto persister: " + persister.getId()));
                }
                ((CachedPersister)((Object)persister)).setCache(cache);
                ((CachedPersister)((Object)persister)).setCacheCheckDelay(cacheCheckDelay);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Initalising persister: " + persister.getId()));
            }
            persister.init(null);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Finished initalising persister: " + persister.getId()));
        }
    }

    public ModelObjectPersister getPersisterByTypeId(String objectTypeId) {
        String persisterId;
        ModelObjectPersister persister = null;
        WebFrameworkConfigElement wfce = this.getWebFrameworkConfig();
        WebFrameworkConfigElement.TypeDescriptor typeDescriptor = wfce.getTypeDescriptor(objectTypeId);
        if (typeDescriptor != null && (persisterId = typeDescriptor.getPersisterId()) != null) {
            persister = this.getPersisterById(persisterId);
        }
        if (persister == null && this.getWebFrameworkConfig().getDefaultPersisterId() != null) {
            persister = this.getPersisterById(this.getWebFrameworkConfig().getDefaultPersisterId());
        }
        return persister;
    }

    public ModelObjectPersister getPersisterById(String persisterId) {
        return (ModelObjectPersister)this.getApplicationContext().getBean(persisterId);
    }

    public Map<String, ModelObjectPersister> getObjectPersisters() {
        HashMap<String, ModelObjectPersister> persisters = new HashMap<String, ModelObjectPersister>(4);
        String[] typeIds = this.getWebFrameworkConfig().getTypeIds();
        for (int i = 0; i < typeIds.length; ++i) {
            ModelObjectPersister persister;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Initializing persister for type: " + typeIds[i]));
            }
            if ((persister = this.getPersisterByTypeId(typeIds[i])) == null) continue;
            persisters.put(persister.getId(), persister);
        }
        return persisters;
    }
}

